/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcYg;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.InsertVo;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.Xmxx;
import cn.gtmap.estateplat.server.core.mapper.BdcZsMapper;
import cn.gtmap.estateplat.server.core.service.BdcSqlxDjsyRelService;
import cn.gtmap.estateplat.server.core.service.BdcYgService;
import cn.gtmap.estateplat.server.core.service.GdXmService;
import cn.gtmap.estateplat.server.service.impl.CreatProjectDefaultServiceImpl;
import cn.gtmap.estateplat.server.service.impl.CreatProjectYgdjServiceImpl;
import cn.gtmap.estateplat.server.utils.Constants;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CreatProjectYgZydjServiceImpl
extends CreatProjectDefaultServiceImpl {
    @Autowired
    EntityMapper entityMapper;
    @Resource(name="creatProjectYgdjServiceImpl")
    CreatProjectYgdjServiceImpl creatProjectYgdjServiceImpl;
    @Autowired
    BdcZsMapper bdcZsMapper;
    @Autowired
    BdcYgService bdcYgService;
    @Autowired
    GdXmService gdXmService;
    @Autowired
    BdcSqlxDjsyRelService bdcSqlxDjsyRelService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    public List<InsertVo> initVoFromOldData(Xmxx xmxx) {
        Project project = null;
        if (xmxx instanceof Project) {
            project = (Project)xmxx;
        }
        if (null != project) {
            Project newProject = this.cloneProject(project);
            super.delOldInfo(project.getWiid());
            super.thisProjectNode(project);
            this.generateBdcYgBg(project);
            this.generateBdcYgDyaBg(project, newProject);
        }
        return new ArrayList<InsertVo>();
    }

    private void generateBdcYgDyaBg(Project project, Project newProject) {
        if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh())) {
            List yBdcYgDyList = this.bdcYgService.getBdcYgList(project.getBdcdyh(), String.valueOf(Constants.QLLX_QSZT_XS), "3,4");
            if (null != newProject && CollectionUtils.isNotEmpty((Collection)yBdcYgDyList)) {
                for (BdcYg bdcYg : yBdcYgDyList) {
                    this.generateBdcYgDyBg(newProject, bdcYg);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh()) && StringUtils.isNotBlank((CharSequence)project.getGdproid())) {
            List yGdYgDyList = this.gdXmService.getGdYgDyListByBdcdyh(project.getBdcdyh());
            if (null != newProject && StringUtils.equals((CharSequence)project.getXmly(), (CharSequence)"3") && CollectionUtils.isNotEmpty((Collection)yGdYgDyList)) {
                for (Map ygDyMap : yGdYgDyList) {
                    this.generateGdYgDyBgFromTransition(newProject, ygDyMap);
                }
            }
        }
    }

    private Project cloneProject(Project project) {
        Project newProject = new Project();
        try {
            newProject = (Project)BeanUtils.cloneBean((Object)project);
        }
        catch (Exception e) {
            this.logger.info("clone\u5bf9\u8c61\u5f02\u5e38\uff01\u5f02\u5e38\u4e0d\u52a8\u4ea7\u5355\u5143\u53f7\uff1a".concat(project.getBdcdyh()));
        }
        return newProject;
    }

    private void generateBdcYgBg(Project project) {
        project.setQllx("19");
        project.setSqlx("704");
        project.setDjlx("700");
        String djsy = this.bdcSqlxDjsyRelService.getDjsyBySqlx("704");
        project.setDjsy(djsy);
        super.insertProjectDate(this.creatProjectYgdjServiceImpl.initVoFromOldData((Xmxx)project));
    }

    private void generateBdcYgDyBg(Project project, BdcYg bdcYg) {
        String proid = UUIDGenerator.generate();
        project.setProid(proid);
        project.setQllx("19");
        project.setSqlx("717");
        project.setDjlx("700");
        String djsy = this.bdcSqlxDjsyRelService.getDjsyBySqlx("717");
        project.setDjsy(djsy);
        HashMap param = Maps.newHashMap();
        param.put("proid", bdcYg.getProid());
        List bdcZses = this.bdcZsMapper.queryBdcZs((Map)param);
        if (CollectionUtils.isNotEmpty((Collection)bdcZses)) {
            project.setYbdcqzh(((BdcZs)bdcZses.get(0)).getBdcqzh());
        }
        project.setYxmid(bdcYg.getProid());
        project.setYbh(bdcYg.getYwh());
        project.setYbdcdyid(bdcYg.getBdcdyid());
        List insertVos = this.creatProjectYgdjServiceImpl.initVoFromOldData((Xmxx)project);
        super.insertProjectDate(insertVos);
    }

    private void generateGdYgDyBgFromTransition(Project project, Map ygDyMap) {
        String proid = UUIDGenerator.generate();
        project.setProid(proid);
        project.setQllx("19");
        project.setSqlx("717");
        project.setDjlx("700");
        String djsy = this.bdcSqlxDjsyRelService.getDjsyBySqlx("717");
        project.setDjsy(djsy);
        project.setGdproid(ygDyMap.get("PROID").toString());
        project.setYqlid(ygDyMap.get("YGID").toString());
        List insertVos = this.creatProjectYgdjServiceImpl.initVoFromOldData((Xmxx)project);
        super.insertProjectDate(insertVos);
    }
}

