/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcDelZszh;
import cn.gtmap.estateplat.model.server.core.BdcDyZs;
import cn.gtmap.estateplat.model.server.core.BdcFdcq;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.BdcDelZszhMapper;
import cn.gtmap.estateplat.server.core.mapper.BdcZsMapper;
import cn.gtmap.estateplat.server.core.model.BdcYlZszh;
import cn.gtmap.estateplat.server.core.service.BdcFdcqService;
import cn.gtmap.estateplat.server.core.service.BdcXtConfigService;
import cn.gtmap.estateplat.server.core.service.BdcYlZszhService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.service.BdczsBhService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class BdczsBhServiceImpl
implements BdczsBhService {
    @Autowired
    public BdcZsService bdcZsService;
    @Autowired
    public BdcXtConfigService bdcXtConfigService;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcFdcqService bdcFdcqService;
    @Autowired
    BdcDelZszhMapper bdcDelZszhMapper;
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    public BdcZsMapper bdcZsMapper;
    @Autowired
    BdcYlZszhService bdcYlZszhService;
    @Autowired
    EntityMapper entityMapper;

    public String getProvinceShortName(BdcXtConfig bdcXtConfig) {
        String provinceShortName = "";
        if (bdcXtConfig != null) {
            provinceShortName = bdcXtConfig.getSqsjc();
        }
        return provinceShortName;
    }

    public String getBhYear(BdcXtConfig bdcXtConfig) {
        String year = "";
        if (bdcXtConfig != null) {
            year = bdcXtConfig.getNf();
        }
        return year;
    }

    public String getXzqShortName(BdcXtConfig bdcXtConfig) {
        String xzq = "";
        if (bdcXtConfig != null) {
            xzq = bdcXtConfig.getSzsxqc();
        }
        return xzq;
    }

    @Transactional(readOnly=true)
    public String getLsh(BdcXtConfig bdcXtConfig, String zsFont, int zsIndex) {
        Integer lshContData;
        String lsh = "";
        Integer len = 0;
        if (bdcXtConfig != null) {
            len = bdcXtConfig.getBdcqzhws();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("zstype", zsFont);
        map.put("nf", CalendarUtil.getCurrYear());
        Integer initNum = this.getBdcqzhInitNumber(zsFont);
        if (null != initNum && initNum > 0) {
            map.put("initNum", initNum);
        }
        if (null != (lshContData = this.getLshContData(map))) {
            lsh = lshContData.toString();
        } else {
            Integer maxLsh = this.bdcZsService.getMaxLsh(map);
            if (maxLsh == null) {
                maxLsh = initNum != null && initNum > 0 ? initNum : Integer.valueOf(0);
            }
            maxLsh = maxLsh + 1;
            maxLsh = maxLsh + zsIndex;
            lsh = maxLsh.toString();
        }
        if (lsh.length() < len) {
            while ((lsh = "0" + lsh).length() < len) {
            }
        }
        return lsh;
    }

    public Integer getBdcqzhInitNumber(String zsFont) {
        Integer initNum = null;
        if (StringUtils.isNotBlank((CharSequence)zsFont)) {
            String scdjzNumStr;
            if (StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u6743")) {
                String bdcqzsNumStr = AppConfig.getProperty((String)"bdcqzs.initNumber");
                if (StringUtils.isNotBlank((CharSequence)bdcqzsNumStr)) {
                    initNum = Integer.parseInt(bdcqzsNumStr);
                }
            } else if (StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e")) {
                String bdcqzmNumStr = AppConfig.getProperty((String)"bdcqzm.initNumber");
                if (StringUtils.isNotBlank((CharSequence)bdcqzmNumStr)) {
                    initNum = Integer.parseInt(bdcqzmNumStr);
                }
            } else if (StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u9996\u6b21\u767b\u8bb0\u8bc1") && StringUtils.isNotBlank((CharSequence)(scdjzNumStr = AppConfig.getProperty((String)"bdcqscdjz.initNumber")))) {
                initNum = Integer.parseInt(scdjzNumStr);
            }
        }
        return initNum;
    }

    private Integer getLshContData(HashMap map) {
        List lshContDataList = this.bdcZsMapper.getLshContData(map);
        Integer lsh = null;
        if (CollectionUtils.isNotEmpty((Collection)lshContDataList)) {
            Integer size = lshContDataList.size();
            String startLshStr = (String)((Map)lshContDataList.get(size - 1)).get("STARTLSH");
            Integer startLsh = Integer.parseInt(startLshStr);
            lsh = startLsh + 1;
        }
        return lsh;
    }

    public String getMaxLshBySl(BdcXtConfig bdcXtConfig, String zsFont, BdcXm bdcXm) {
        HashMap<String, String> map;
        Integer maxLsh = null;
        Integer len = 0;
        String lsh = "";
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)zsFont) && StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u6743")) {
            map = new HashMap<String, String>();
            String sqZscqzLsh = "sq_zscqz_lsh";
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getSsxz()) && bdcXm.getSsxz().length() != 6) {
                sqZscqzLsh = sqZscqzLsh + "_" + bdcXm.getSsxz();
            }
            map.put("BdcqzLsh", sqZscqzLsh);
            maxLsh = this.getMaxLshByXl(map);
        } else if (bdcXm != null && StringUtils.isNotBlank((CharSequence)zsFont) && StringUtils.equals((CharSequence)zsFont, (CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e")) {
            map = new HashMap();
            String sqZsczmLsh = "sq_zsczm_lsh";
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getSsxz())) {
                sqZsczmLsh = sqZsczmLsh + "_" + bdcXm.getSsxz();
            }
            map.put("BdcqzLsh", sqZsczmLsh);
            maxLsh = this.getMaxLshByXl(map);
        }
        if (maxLsh != null) {
            lsh = maxLsh.toString();
        }
        if (bdcXtConfig != null && bdcXtConfig.getBdcqzhws() != null) {
            len = bdcXtConfig.getBdcqzhws();
        }
        if (lsh.length() < len) {
            while ((lsh = "0" + lsh).length() < len) {
            }
        }
        return lsh;
    }

    public Integer getMaxLshByXl(HashMap map) {
        return this.bdcZsMapper.getMaxLshByXl(map);
    }

    public String getBdczsBh(BdcXtConfig bdcXtConfig) {
        String provinceShortName = this.getProvinceShortName(bdcXtConfig);
        String year = this.getBhYear(bdcXtConfig);
        String xzq = this.getXzqShortName(bdcXtConfig);
        String lsh = this.getLsh(bdcXtConfig, "\u4e0d\u52a8\u4ea7\u6743", 0);
        String bh = provinceShortName + "" + year + "" + xzq + "\u4e0d\u52a8\u4ea7\u6743" + "\u7b2c" + lsh + "\u53f7";
        return bh;
    }

    public String getBdczmBh(BdcXtConfig bdcXtConfig) {
        String provinceShortName = this.getProvinceShortName(bdcXtConfig);
        String year = this.getBhYear(bdcXtConfig);
        String xzq = this.getXzqShortName(bdcXtConfig);
        String lsh = this.getLsh(bdcXtConfig, "\u4e0d\u52a8\u4ea7\u8bc1\u660e", 0);
        String bh = provinceShortName + "(" + year + ")" + xzq + "\u4e0d\u52a8\u4ea7\u8bc1\u660e" + "\u7b2c" + lsh + "\u53f7";
        return bh;
    }

    @Transactional
    public BdcDyZs creatBdcqzBh(BdcXm bdcXm, BdcDyZs bdcZs, int zsIndex) {
        String bdcqzh = "";
        if (bdcZs == null) {
            bdcZs = new BdcDyZs();
        }
        if (StringUtils.isBlank((CharSequence)bdcZs.getBdcqzh())) {
            BdcXtConfig bdcXtConfig = this.bdcXtConfigService.queryBdczsBhConfig(bdcXm);
            String nf = this.getBhYear(bdcXtConfig);
            String sqsjc = this.getProvinceShortName(bdcXtConfig);
            String szsxqc = this.getXzqShortName(bdcXtConfig);
            QllxVo qllxVo = this.qllxService.makeSureQllx(bdcXm);
            String zsFont = this.qllxService.makeSureBdcqzlx(qllxVo);
            String zsFont1 = AppConfig.getProperty((String)"spfscdj.zstype");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zsFont1}) && StringUtils.equals((CharSequence)zsFont1, (CharSequence)"\u9996\u6b21\u767b\u8bb0\u8bc1") && StringUtils.equals((CharSequence)bdcXm.getSqlx(), (CharSequence)"130")) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("bdcdyid", bdcZs.getBdcdyid());
                hashMap.put("ywh", bdcXm.getBh());
                BdcFdcq bdcFdcq = this.bdcFdcqService.getBdcFdcq(hashMap);
                zsFont = null != bdcFdcq && StringUtils.equals((CharSequence)bdcFdcq.getFzlx(), (CharSequence)"\u4e0d\u52a8\u4ea7\u6743") ? "\u4e0d\u52a8\u4ea7\u6743" : zsFont1;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zsFont})) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("isuse", "0");
                map.put("zstype", zsFont);
                map.put("nf", nf);
                map.put("proid", bdcXm.getProid());
                String bdcqzhFilterZhXzdm = AppConfig.getProperty((String)"bdcqzh.filterZh.xzdm");
                if (StringUtils.equals((CharSequence)bdcqzhFilterZhXzdm, (CharSequence)"true")) {
                    map.put("dwdm", bdcXm.getSsxz());
                } else {
                    map.put("dwdm", bdcXm.getDwdm());
                }
                map.put("syqks", new String[]{"0", "1"});
                List bdcYlZszhList = this.bdcYlZszhService.queryBdcYlZszhList(map);
                List bdcDelZszhList = this.bdcDelZszhMapper.getBdcDelZszhList(map);
                if (CollectionUtils.isNotEmpty((Collection)bdcYlZszhList)) {
                    BdcYlZszh bdcYlZszh = (BdcYlZszh)bdcYlZszhList.get(0);
                    bdcZs.setZstype(zsFont);
                    bdcZs.setSqsjc(sqsjc);
                    bdcZs.setSzsxqc(szsxqc);
                    bdcZs = this.setZsXxFromBdcYlZszh(bdcZs, bdcYlZszh);
                } else if (bdcDelZszhList != null && bdcDelZszhList.size() > 0) {
                    BdcDelZszh bdcDelZszh = (BdcDelZszh)bdcDelZszhList.get(0);
                    bdcZs.setZstype(zsFont);
                    bdcZs.setZhlsh(bdcDelZszh.getZhlsh());
                    bdcZs.setNf(bdcDelZszh.getNf());
                    bdcZs.setSqsjc(bdcDelZszh.getSqsjc());
                    bdcZs.setSzsxqc(bdcDelZszh.getSzsxqc());
                    bdcZs.setBdcqzh(bdcDelZszh.getBdcqzh());
                    bdcDelZszh.setIsuse("1");
                    this.entryMapper.saveOrUpdate((Object)bdcDelZszh, (Object)bdcDelZszh.getZszhid());
                } else {
                    String lsh = "";
                    String useSequence = AppConfig.getProperty((String)"use.sequence");
                    lsh = StringUtils.equals((CharSequence)useSequence, (CharSequence)"true") ? this.getMaxLshBySl(bdcXtConfig, zsFont, bdcXm) : this.getLsh(bdcXtConfig, zsFont, zsIndex);
                    String bdcqzhInsertZhXzdm = AppConfig.getProperty((String)"bdcqzh.insertZh.xzdm");
                    if (StringUtils.equals((CharSequence)bdcqzhInsertZhXzdm, (CharSequence)"true")) {
                        lsh = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcXm.getSsxz()}) && bdcXm.getSsxz().length() == 9 ? bdcXm.getSsxz().substring(7) + lsh : "00" + lsh;
                    }
                    bdcqzh = sqsjc + "(" + nf + ")" + szsxqc + zsFont + "\u7b2c" + lsh + "\u53f7";
                    bdcZs.setZstype(zsFont);
                    bdcZs.setZhlsh(lsh);
                    bdcZs.setNf(nf);
                    bdcZs.setSqsjc(sqsjc);
                    bdcZs.setSzsxqc(szsxqc);
                    bdcZs.setBdcqzh(bdcqzh);
                }
            }
        }
        return bdcZs;
    }

    private BdcDyZs setZsXxFromBdcYlZszh(BdcDyZs bdcZs, BdcYlZszh bdcYlZszh) {
        String bdcZsId = UUIDGenerator.generate18();
        bdcZs.setZsid(bdcZsId);
        bdcZs.setZhlsh(bdcYlZszh.getZhlsh());
        bdcZs.setNf(bdcYlZszh.getNf());
        bdcZs.setBdcqzh(bdcYlZszh.getBdcqzh());
        bdcYlZszh.setSyqk("2");
        bdcYlZszh.setZsid(bdcZsId);
        this.entityMapper.saveOrUpdate((Object)bdcYlZszh, (Object)bdcYlZszh.getZszhid());
        return bdcZs;
    }
}

