/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcDyaq;
import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.BdcJsydzjdsyq;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcTdcbnydsyq;
import cn.gtmap.estateplat.model.server.core.BdcTdsyq;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcYg;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdDy;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdQlr;
import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.model.server.core.GdTdQl;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.GdTdMapper;
import cn.gtmap.estateplat.server.core.mapper.GdXmMapper;
import cn.gtmap.estateplat.server.core.service.BdcCheckCancelService;
import cn.gtmap.estateplat.server.core.service.BdcGdDyhRelService;
import cn.gtmap.estateplat.server.core.service.BdcXmRelService;
import cn.gtmap.estateplat.server.core.service.GdFwService;
import cn.gtmap.estateplat.server.core.service.GdQlrService;
import cn.gtmap.estateplat.server.core.service.GdTdService;
import cn.gtmap.estateplat.server.core.service.GdXmService;
import cn.gtmap.estateplat.server.core.service.QllxParentService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class GdTdServiceImpl
implements GdTdService {
    @Autowired
    GdTdMapper gdTdMapper;
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    GdXmMapper gdXmMapper;
    @Autowired
    GdXmService gdXmService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    GdQlrService gdQlrService;
    @Autowired
    private BdcCheckCancelService bdcCheckCancelService;
    @Autowired
    private QllxParentService qllxParentService;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private EntityMapper entityMapper;

    public GdTd queryGdTdByProid(String proid) {
        GdTd gdTd = null;
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example gdTdExample = new Example(GdTd.class);
            gdTdExample.createCriteria().andEqualTo("proid", (Object)proid);
            List gdTdList = this.entryMapper.selectByExample(GdTd.class, (Object)gdTdExample);
            if (gdTdList != null && gdTdList.size() > 0) {
                gdTd = (GdTd)gdTdList.get(0);
            }
        }
        return gdTd;
    }

    public List<Map> getGdTdJson(HashMap map) {
        return this.gdTdMapper.getGdTdJsonByPage((Map)map);
    }

    public GdTd queryGdTd(String tdId) {
        GdTd gdTd = null;
        if (StringUtils.isNotBlank((CharSequence)tdId)) {
            gdTd = (GdTd)this.entryMapper.selectByPrimaryKey(GdTd.class, (Object)tdId);
        }
        return gdTd;
    }

    public GdTd queryGdTdByTdzh(String tdzh) {
        GdTd gdTd = null;
        if (StringUtils.isNotBlank((CharSequence)tdzh)) {
            Example example = new Example(GdTdsyq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("tdzh", (Object)tdzh);
            List gdTdsyqList = this.entryMapper.selectByExample(GdTdsyq.class, (Object)example);
            if (gdTdsyqList != null && gdTdsyqList.size() > 0 && StringUtils.isNotBlank((CharSequence)((GdTdsyq)gdTdsyqList.get(0)).getTdid())) {
                gdTd = (GdTd)this.entryMapper.selectByPrimaryKey(GdTd.class, (Object)((GdTdsyq)gdTdsyqList.get(0)).getTdid());
            }
        }
        return gdTd;
    }

    public BdcTdsyq readBdcTdsyqFromGdTd(GdTd gdTd, GdTdsyq gdTdsyq, BdcTdsyq bdcTdsyq) {
        if (gdTd != null) {
            if (bdcTdsyq == null) {
                bdcTdsyq = new BdcTdsyq();
            }
            if (StringUtils.isNotBlank((CharSequence)gdTd.getGyqk())) {
                bdcTdsyq.setGyqk(gdTd.getGyqk());
            }
            if (gdTdsyq != null) {
                bdcTdsyq.setNydmj(gdTdsyq.getNyd());
                bdcTdsyq.setJsydmj(gdTdsyq.getJsyd());
                bdcTdsyq.setWlydmj(gdTdsyq.getWlyd());
                bdcTdsyq.setGdmj(gdTdsyq.getGd());
                bdcTdsyq.setLdmj(gdTdsyq.getLd());
                bdcTdsyq.setCdmj(gdTdsyq.getMcd());
                bdcTdsyq.setQtmj(gdTdsyq.getQtnyd());
            }
        }
        return bdcTdsyq;
    }

    public BdcJsydzjdsyq readBdcJsydzjdsyqFromGdTd(GdTd gdTd, BdcJsydzjdsyq bdcJsydzjdsyq) {
        Date date = null;
        if (gdTd != null) {
            if (bdcJsydzjdsyq == null) {
                bdcJsydzjdsyq = new BdcJsydzjdsyq();
            }
            if (StringUtils.isNotBlank((CharSequence)gdTd.getGyqk())) {
                bdcJsydzjdsyq.setGyqk(gdTd.getGyqk());
            }
            if (gdTd.getQdjg() != null) {
                bdcJsydzjdsyq.setQdjg(gdTd.getQdjg());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gdTd.getQsrq()}) && StringUtils.isNotBlank((CharSequence)gdTd.getZzrq())) {
                if (bdcJsydzjdsyq.getSyksqx() == null) {
                    bdcJsydzjdsyq.setSyksqx(CalendarUtil.formatDate((String)gdTd.getQsrq()));
                }
                if (bdcJsydzjdsyq.getSyjsqx() == null) {
                    bdcJsydzjdsyq.setSyjsqx(CalendarUtil.formatDate((String)gdTd.getZzrq()));
                }
            }
            if (StringUtils.isBlank((CharSequence)gdTd.getQsrq()) && StringUtils.isNotBlank((CharSequence)gdTd.getZzrq())) {
                date = this.gdXmService.getRqFromYt(null, gdTd.getZzrq(), gdTd.getYt(), gdTd.getSyqlx());
                if (bdcJsydzjdsyq.getSyksqx() == null) {
                    bdcJsydzjdsyq.setSyksqx(date);
                }
                if (bdcJsydzjdsyq.getSyjsqx() == null) {
                    bdcJsydzjdsyq.setSyjsqx(CalendarUtil.formatDate((String)gdTd.getZzrq()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)gdTd.getQsrq()) && StringUtils.isBlank((CharSequence)gdTd.getZzrq())) {
                date = this.gdXmService.getRqFromYt(gdTd.getQsrq(), null, gdTd.getYt(), gdTd.getSyqlx());
                if (bdcJsydzjdsyq.getSyksqx() == null) {
                    bdcJsydzjdsyq.setSyksqx(CalendarUtil.formatDate((String)gdTd.getQsrq()));
                }
                if (bdcJsydzjdsyq.getSyjsqx() == null) {
                    bdcJsydzjdsyq.setSyjsqx(date);
                }
            }
            if (gdTd.getZdmj() != null) {
                bdcJsydzjdsyq.setSyqmj(gdTd.getZdmj());
            }
        }
        return bdcJsydzjdsyq;
    }

    public List<GdTdsyq> queryTdsyqByFwid(String fwid) {
        if (StringUtils.isNotBlank((CharSequence)fwid)) {
            Example example = new Example(GdTdsyq.class);
            example.createCriteria().andEqualTo("fwid", (Object)fwid);
            List list = this.entryMapper.selectByExample(GdTdsyq.class, (Object)example);
            return list;
        }
        return null;
    }

    public List<GdTdsyq> queryTdsyqByTdid(String tdid) {
        List gdBdcQlRelList;
        ArrayList<GdTdsyq> list = null;
        if (StringUtils.isNotBlank((CharSequence)tdid) && CollectionUtils.isNotEmpty((Collection)(gdBdcQlRelList = this.gdFwService.getGdBdcQlRelByBdcidOrQlid(tdid, null)))) {
            list = new ArrayList<GdTdsyq>();
            for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                GdTdsyq gdTdsyq = this.getGdTdsyqByQlid(gdBdcQlRel.getQlid());
                if (gdTdsyq == null) continue;
                list.add(gdTdsyq);
            }
        }
        return list;
    }

    public List<GdDy> queryTddyqByTdid(String tdid) {
        List gdBdcQlRelList;
        ArrayList<GdDy> list = null;
        if (StringUtils.isNotBlank((CharSequence)tdid) && CollectionUtils.isNotEmpty((Collection)(gdBdcQlRelList = this.gdFwService.getGdBdcQlRelByBdcidOrQlid(tdid, null)))) {
            list = new ArrayList<GdDy>();
            for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                GdDy gdDy = this.getGddyqByQlid(gdBdcQlRel.getQlid());
                if (gdDy == null) continue;
                list.add(gdDy);
            }
        }
        return list;
    }

    public List<BdcQlr> getQlrFromGdTd(String tdid, String qlid) {
        List gdTdsyqList;
        List<Object> bdcQlrList = new ArrayList<BdcQlr>();
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            List gdQlrs = this.gdQlrService.queryGdQlrs(qlid, "qlr");
            bdcQlrList = this.gdQlrService.readGdQlrs(gdQlrs);
        } else if (StringUtils.isNotBlank((CharSequence)tdid) && (gdTdsyqList = this.queryTdsyqByTdid(tdid)) != null && gdTdsyqList.size() > 0) {
            for (GdTdsyq gdTdsyq : gdTdsyqList) {
                List gdQlrs = this.gdQlrService.queryGdQlrs(gdTdsyq.getQlid(), "qlr");
                bdcQlrList.addAll(this.gdQlrService.readGdQlrs(gdQlrs));
            }
        }
        return bdcQlrList;
    }

    public List<BdcQlr> getYwrFromGdTd(String tdid, String qlid) {
        List gdTdsyqList;
        List<Object> bdcQlrList = new ArrayList<BdcQlr>();
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            List gdQlrs = this.gdQlrService.queryGdQlrs(qlid, "ywr");
            bdcQlrList = this.gdQlrService.readGdQlrs(gdQlrs);
        } else if (StringUtils.isNotBlank((CharSequence)tdid) && (gdTdsyqList = this.queryTdsyqByTdid(tdid)) != null && gdTdsyqList.size() > 0) {
            for (GdTdsyq gdTdsyq : gdTdsyqList) {
                List gdQlrs = this.gdQlrService.queryGdQlrs(gdTdsyq.getQlid(), "ywr");
                bdcQlrList.addAll(this.gdQlrService.readGdQlrs(gdQlrs));
            }
        }
        return bdcQlrList;
    }

    public List<GdQlr> getQlrByName(String qlrname) {
        return this.gdTdMapper.getQlrByName(qlrname);
    }

    public String[] getQlrByNameToArr(String qlrname) {
        List gdQlrList;
        ArrayList<String> idList = new ArrayList<String>();
        String[] ids = null;
        if (StringUtils.isNotBlank((CharSequence)qlrname) && (gdQlrList = this.getQlrByName(qlrname)) != null && gdQlrList.size() > 0) {
            for (GdQlr gdQlr : gdQlrList) {
                if (!StringUtils.isNotBlank((CharSequence)CommonUtil.formatEmptyValue((Object)gdQlr.getQlid())) || idList.contains(CommonUtil.formatEmptyValue((Object)gdQlr.getQlid()))) continue;
                idList.add(CommonUtil.formatEmptyValue((Object)gdQlr.getQlid()));
            }
        }
        if (idList != null && idList.size() > 0) {
            ids = new String[idList.size()];
            int i = 0;
            Iterator i$ = idList.iterator();
            while (i$.hasNext()) {
                String id;
                ids[i] = id = (String)i$.next();
                ++i;
            }
        }
        return ids;
    }

    public String getqlrByQlid(String qlid) {
        String qlr = "";
        List qlrList = this.gdQlrService.queryGdQlrs(qlid, "qlr");
        if (qlrList != null && qlrList.size() > 0) {
            for (GdQlr qlr1 : qlrList) {
                if (StringUtils.isBlank((CharSequence)qlr)) {
                    qlr = CommonUtil.formatEmptyValue((Object)qlr1.getQlr());
                    continue;
                }
                qlr = qlr + "/" + CommonUtil.formatEmptyValue((Object)qlr1.getQlr());
            }
        }
        return qlr;
    }

    public String getTdzhsByProid(String proid) {
        List bdcXmRelList;
        String tdzhs = "";
        if (StringUtils.isNotBlank((CharSequence)proid) && (bdcXmRelList = this.bdcXmRelService.queryBdcXmRelByProid(proid)) != null && bdcXmRelList.size() > 0) {
            for (BdcXmRel bdcXmRel : bdcXmRelList) {
                List gdDyhRelList;
                if (!StringUtils.isNotBlank((CharSequence)bdcXmRel.getYproid())) continue;
                String bdcid = "";
                List bdcidList = this.gdXmService.getGdBdcidByProid(bdcXmRel.getYproid());
                if (CollectionUtils.isNotEmpty((Collection)bdcidList)) {
                    bdcid = (String)bdcidList.get(0);
                }
                if ((gdDyhRelList = this.bdcGdDyhRelService.getGdDyhRel(null, bdcid)) == null || gdDyhRelList.size() <= 0) continue;
                for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                    if (gdDyhRel == null || !StringUtils.isNotBlank((CharSequence)gdDyhRel.getGdid())) continue;
                    List gdTdsyqList = this.gdTdMapper.getGdTdSyq(gdDyhRel.getGdid());
                    GdTdsyq gdTdsyq = null;
                    if (gdTdsyqList != null && gdTdsyqList.size() > 0) {
                        gdTdsyq = (GdTdsyq)gdTdsyqList.get(0);
                    }
                    if (gdTdsyq == null || StringUtils.indexOf((CharSequence)tdzhs, (CharSequence)gdTdsyq.getTdzh()) >= 0) continue;
                    if (StringUtils.isBlank((CharSequence)tdzhs)) {
                        tdzhs = gdTdsyq.getTdzh();
                        continue;
                    }
                    tdzhs = tdzhs + "," + gdTdsyq.getTdzh();
                }
            }
        }
        return tdzhs;
    }

    public String getDhDzbDjhByTdid(String tdid) {
        return this.gdTdMapper.getDhDzbDjhByTdid(tdid);
    }

    public String getZdDcbDjhByTdid(String tdid) {
        return this.gdTdMapper.getZdDcbDjhByTdid(tdid);
    }

    public String getNewDjh(String tdzdz, String tdid) {
        String djh = "";
        if (StringUtils.isNotBlank((CharSequence)tdzdz)) {
            if (StringUtils.equals((CharSequence)tdzdz, (CharSequence)"zddcb")) {
                djh = this.getZdDcbDjhByTdid(tdid);
            } else if (StringUtils.equals((CharSequence)tdzdz, (CharSequence)"dhdzb")) {
                djh = this.getDhDzbDjhByTdid(tdid);
            }
        }
        return djh;
    }

    public String getTdzhByTdid(String tdid) {
        return this.gdTdMapper.getTdzhByTdid(tdid);
    }

    public String getBdcdyhByTdids(HashMap map) {
        return this.gdTdMapper.getBdcdyhByTdids((Map)map);
    }

    public List<GdTd> getGdTdyTdids(HashMap map) {
        ArrayList<GdTd> gdTds = new ArrayList<GdTd>();
        List gdTdList = this.gdTdMapper.getGdTdyTdids((Map)map);
        if (CollectionUtils.isNotEmpty((Collection)gdTdList)) {
            for (GdTd gdTd : gdTdList) {
                gdTd = this.bdcCheckCancelService.getGdTdFilterZdsj(gdTd);
                gdTds.add(gdTd);
            }
        }
        return gdTds;
    }

    public String getTdzsZt(String bdcid, String dyid) {
        String xx = "";
        xx = this.queryTdZtbyBdcdyh(bdcid, false);
        if (StringUtils.isBlank((CharSequence)xx)) {
            xx = this.queryTdZtbyBdcdyh(bdcid, true);
        }
        List cfList = null;
        List dyList = null;
        List ygList = null;
        if (StringUtils.isBlank((CharSequence)xx)) {
            GdDy gdDy;
            ygList = this.bdcCheckCancelService.getGdYgByProid(bdcid, Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty((Collection)ygList)) {
                xx = "\u9884\u544a";
            }
            if (CollectionUtils.isNotEmpty((Collection)(dyList = this.bdcCheckCancelService.getGdDyByProid(bdcid, Integer.valueOf(0))))) {
                xx = "\u62b5\u62bc";
            }
            if (CollectionUtils.isNotEmpty((Collection)(cfList = this.bdcCheckCancelService.getGdCfByProid(bdcid, Integer.valueOf(0))))) {
                xx = "\u67e5\u5c01";
            }
            if (StringUtils.isNotBlank((CharSequence)dyid) && (gdDy = this.gdFwService.getGdDyByDyid(dyid, null)) != null && gdDy.getIsjy() == 1) {
                xx = "\u6ce8\u9500";
            }
        }
        return xx;
    }

    public String queryTdZtbyBdcdyh(String tdid, boolean isfw) {
        String xx = "";
        List qllxList = null;
        HashMap<String, String> map = new HashMap<String, String>();
        List bdcGdDyhRelList = this.bdcGdDyhRelService.getGdDyhRelByGdId(tdid);
        if (CollectionUtils.isNotEmpty((Collection)bdcGdDyhRelList)) {
            for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                if (StringUtils.isNotBlank((CharSequence)xx)) break;
                if (!StringUtils.isNotBlank((CharSequence)bdcGdDyhRel.getBdcdyh())) continue;
                map.put("bdcdyh", bdcGdDyhRel.getBdcdyh());
                map.put("qszt", "1");
                qllxList = this.qllxParentService.queryZtzcQllxVo((QllxVo)new BdcYg(), map);
                if (CollectionUtils.isNotEmpty((Collection)qllxList)) {
                    xx = "\u9884\u544a";
                }
                if (CollectionUtils.isNotEmpty((Collection)(qllxList = this.qllxParentService.queryZtzcQllxVo((QllxVo)new BdcDyaq(), map)))) {
                    xx = "\u62b5\u62bc";
                }
                if (CollectionUtils.isNotEmpty((Collection)(qllxList = this.qllxParentService.queryZtzcQllxVo((QllxVo)new BdcCf(), map)))) {
                    xx = "\u67e5\u5c01";
                }
                map.clear();
                map.put("bdcdyh", bdcGdDyhRel.getBdcdyh());
                map.put("qszt", "2");
                qllxList = this.qllxParentService.queryZtzcQllxVo((QllxVo)new BdcJsydzjdsyq(), map);
                if (CollectionUtils.isNotEmpty((Collection)qllxList)) {
                    xx = "\u6ce8\u9500";
                    continue;
                }
                qllxList = this.qllxParentService.queryZtzcQllxVo((QllxVo)new BdcTdcbnydsyq(), map);
                if (!CollectionUtils.isNotEmpty((Collection)qllxList)) continue;
                xx = "\u6ce8\u9500";
            }
        }
        return xx;
    }

    @Transactional(readOnly=true)
    public List<GdTdsyq> getGdTdsyqListByGdproid(String gdProid, Integer iszx) {
        List gdTdsyqList = null;
        if (StringUtils.isNotBlank((CharSequence)gdProid)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("proid", gdProid);
            map.put("iszx", iszx);
            gdTdsyqList = this.andEqualQueryGdTdsyq(map);
        }
        return gdTdsyqList;
    }

    @Transactional(readOnly=true)
    public List<GdTdsyq> andEqualQueryGdTdsyq(HashMap<String, Object> map) {
        List list = null;
        Example qllxTemp = new Example(GdTdsyq.class);
        if (map != null && map.entrySet().size() > 0) {
            Iterator<Map.Entry<String, Object>> iter = map.entrySet().iterator();
            Example.Criteria criteria = qllxTemp.createCriteria();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String key = entry.getKey();
                Object val = entry.getValue();
                if (val == null) continue;
                criteria.andEqualTo(key.toString(), val);
            }
        }
        list = this.entryMapper.selectByExample(GdTdsyq.class, (Object)qllxTemp);
        return list;
    }

    @Transactional(readOnly=true)
    public List<GdTd> getGdTdListByQlid(String qlid) {
        List gdBdcQlRelList;
        ArrayList<GdTd> gdTdList = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlid}) && CollectionUtils.isNotEmpty((Collection)(gdBdcQlRelList = this.gdFwService.getGdBdcQlRelByBdcidOrQlid(null, qlid)))) {
            gdTdList = new ArrayList<GdTd>();
            for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                GdTd gdTd;
                if (!StringUtils.isNotBlank((CharSequence)gdBdcQlRel.getBdcid()) || (gdTd = this.queryGdTd(gdBdcQlRel.getBdcid())) == null) continue;
                gdTdList.add(gdTd);
            }
        }
        return gdTdList;
    }

    @Transactional(readOnly=true)
    public List<GdTd> getGdTdListByProid(String proid, String qlids) {
        ArrayList gdTdList = null;
        if (StringUtils.isBlank((CharSequence)qlids)) {
            qlids = this.gdFwService.getGdFwQlidsByProid(proid);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlids})) {
            gdTdList = new ArrayList();
            for (String qlid : qlids.split(",")) {
                List tdList = this.getGdTdListByQlid(qlid);
                if (!CollectionUtils.isNotEmpty((Collection)tdList)) continue;
                gdTdList.addAll(tdList);
            }
        }
        return gdTdList;
    }

    @Transactional(readOnly=true)
    public List<GdTdsyq> andLikeQueryGdTdsyq(HashMap<String, Object> map) {
        List list = null;
        Example qllxTemp = new Example(GdTdsyq.class);
        if (map != null && map.entrySet().size() > 0) {
            Iterator<Map.Entry<String, Object>> iter = map.entrySet().iterator();
            Example.Criteria criteria = qllxTemp.createCriteria();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String key = entry.getKey();
                Object val = entry.getValue();
                if (val == null) continue;
                criteria.andLike(key.toString(), val.toString());
            }
        }
        list = this.entryMapper.selectByExample(GdTdsyq.class, (Object)qllxTemp);
        return list;
    }

    @Transactional(readOnly=true)
    public GdTdsyq getGdTdsyqByQlid(String qlid) {
        GdTdsyq gdTdsyq = null;
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("qlid", qlid);
            List gdTdsyqList = this.andEqualQueryGdTdsyq(map);
            if (gdTdsyqList != null && gdTdsyqList.size() > 0) {
                gdTdsyq = (GdTdsyq)gdTdsyqList.get(0);
            }
        }
        return gdTdsyq;
    }

    public GdDy getGddyqByQlid(String qlid) {
        GdDy gdDy = null;
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dyid", qlid);
            List gdDyList = this.andEqualQueryGdDy(map);
            if (gdDyList != null && gdDyList.size() > 0) {
                gdDy = (GdDy)gdDyList.get(0);
            }
        }
        return gdDy;
    }

    public List<GdDy> andEqualQueryGdDy(Map<String, Object> map) {
        List list = null;
        Example qllxTemp = new Example(GdDy.class);
        if (map != null && map.entrySet().size() > 0) {
            Iterator<Map.Entry<String, Object>> iter = map.entrySet().iterator();
            Example.Criteria criteria = qllxTemp.createCriteria();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String key = entry.getKey();
                Object val = entry.getValue();
                if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue((Object)key), (CharSequence)"iszx")) {
                    if (val == null || !NumberUtils.isNumber((String)CommonUtil.formatEmptyValue((Object)val))) continue;
                    criteria.andEqualNvlTo("isjy", val, (Object)0);
                    continue;
                }
                if (val == null) continue;
                criteria.andEqualTo(key.toString(), val);
            }
        }
        list = this.entryMapper.selectByExample(GdDy.class, (Object)qllxTemp);
        return list;
    }

    @Transactional(readOnly=true)
    public List<GdTd> getGdTdListByFwQlid(String qlid) {
        List gdFwList;
        ArrayList<GdTd> gdTdList = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlid}) && CollectionUtils.isNotEmpty((Collection)(gdFwList = this.gdFwService.getGdFwByQlid(qlid)))) {
            for (GdFw gdFw : gdFwList) {
                List gdBdcQlRelList = this.bdcGdDyhRelService.getGdDyhRel(null, gdFw.getFwid());
                if (!CollectionUtils.isNotEmpty((Collection)gdBdcQlRelList)) continue;
                gdTdList = new ArrayList<GdTd>();
                for (BdcGdDyhRel bdcGdDyhRel : gdBdcQlRelList) {
                    GdTd gdTd;
                    if (!StringUtils.isNotBlank((CharSequence)bdcGdDyhRel.getTdid()) || (gdTd = this.queryGdTd(bdcGdDyhRel.getTdid())) == null) continue;
                    gdTdList.add(gdTd);
                }
            }
        }
        return gdTdList;
    }

    public List<GdTdsyq> getTdsyqByFczh(HashMap hashMap) {
        return this.gdTdMapper.getTdsyqByFczh(hashMap);
    }

    public List<GdDy> getTdDyByFczh(HashMap hashMap) {
        return this.gdTdMapper.getTdDyByFczh(hashMap);
    }

    public List<GdTdQl> getGdTdQlZs(HashMap map) {
        return this.gdTdMapper.getGdTdQlZs(map);
    }

    public List<String> getGdTdListByZl(String zl) {
        List gdTdList = null;
        if (StringUtils.isNotBlank((CharSequence)zl)) {
            gdTdList = this.gdTdMapper.getGdTdQlidByZl(zl);
        }
        return gdTdList;
    }

    public List<String> getGdTdQlidByDjh(String djh) {
        return this.gdTdMapper.getGdTdQlidByDjh(djh);
    }

    public List<GdTdsyq> getGdTdsyqByFwQlid(String qlid) {
        List gdFwList;
        ArrayList<GdTdsyq> gdTdsyqList = new ArrayList<GdTdsyq>();
        if (StringUtils.isNotBlank((CharSequence)qlid) && CollectionUtils.isNotEmpty((Collection)(gdFwList = this.gdFwService.getGdFwByQlid(qlid)))) {
            for (GdFw gdFw : gdFwList) {
                List gdTdList = this.getGdTdByGdDyhFwid(gdFw.getFwid());
                if (!CollectionUtils.isNotEmpty((Collection)gdTdList)) continue;
                for (GdTd gdTd : gdTdList) {
                    List gdTdsyqLists = this.queryTdsyqByTdid(gdTd.getTdid());
                    if (!CollectionUtils.isNotEmpty((Collection)gdTdsyqLists)) continue;
                    gdTdsyqList.add((GdTdsyq)gdTdsyqLists.get(0));
                }
            }
        }
        return gdTdsyqList;
    }

    public List<GdTd> getGdTdByGdDyhFwid(String fwid) {
        ArrayList<GdTd> gdTdList = new ArrayList<GdTd>();
        ArrayList<String> tdidList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)fwid)) {
            Example example = new Example(BdcGdDyhRel.class);
            example.createCriteria().andEqualTo("gdid", (Object)fwid);
            List gdDyhRelList = this.entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)gdDyhRelList)) {
                for (BdcGdDyhRel bdcGdDyhRel : gdDyhRelList) {
                    if (!StringUtils.isNotBlank((CharSequence)bdcGdDyhRel.getTdid()) || tdidList.contains(bdcGdDyhRel.getTdid())) continue;
                    tdidList.add(bdcGdDyhRel.getTdid());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(tdidList)) {
            for (String tdid : tdidList) {
                GdTd gdTd = this.queryGdTd(tdid);
                if (gdTd == null) continue;
                gdTdList.add(gdTd);
            }
        }
        return gdTdList;
    }

    public List<HashMap> getGdTdQl(HashMap map) {
        return this.gdTdMapper.getGdTdQl(map);
    }
}

