/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdQlr;
import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.server.core.mapper.GdQlrMapper;
import cn.gtmap.estateplat.server.core.service.GdQlrService;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GdQlrServiceImpl
implements GdQlrService {
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    GdQlrMapper gdQlrMapper;

    public List<GdQlr> queryGdQlrs(String qlid, String qlrlx) {
        ArrayList list = null;
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            String[] qlidarr;
            for (String qlidtemp : qlidarr = qlid.split(",")) {
                Example qlrTemp = new Example(GdQlr.class);
                Example.Criteria criteria = qlrTemp.createCriteria();
                criteria.andEqualTo("qlid", (Object)qlidtemp);
                if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                    criteria.andEqualTo("qlrlx", (Object)qlrlx);
                }
                List listtemp = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
                list = new ArrayList();
                if (!CollectionUtils.isNotEmpty((Collection)listtemp)) continue;
                list.addAll(listtemp);
            }
        }
        return list;
    }

    public List<BdcQlr> readGdQlrs(List<GdQlr> gdQlrs) {
        ArrayList<BdcQlr> bdcQlrList = new ArrayList<BdcQlr>();
        if (gdQlrs != null && gdQlrs.size() > 0) {
            for (GdQlr gdQlr : gdQlrs) {
                BdcQlr bdcQlr = null;
                if (gdQlr == null) continue;
                bdcQlr = new BdcQlr();
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                if (gdQlr.getSxh() == 0) {
                    bdcQlr.setSxh(2);
                } else {
                    bdcQlr.setSxh(gdQlr.getSxh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                    bdcQlr.setQlrmc(gdQlr.getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrzjh())) {
                    bdcQlr.setQlrzjh(gdQlr.getQlrzjh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrsfzjzl())) {
                    bdcQlr.setQlrsfzjzl(gdQlr.getQlrsfzjzl());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrlx())) {
                    bdcQlr.setQlrlx(gdQlr.getQlrlx());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrxz())) {
                    bdcQlr.setQlrxz(gdQlr.getQlrxz());
                }
                if (gdQlrs.size() > 1) {
                    if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlbl())) {
                        Double qlbl = CommonUtil.getGybl((String)gdQlr.getQlbl());
                        if (qlbl != null) {
                            if (StringUtils.equals((CharSequence)AppConfig.getProperty((String)"bdcqlr.qlbl.fs"), (CharSequence)"true")) {
                                bdcQlr.setQlbl(gdQlr.getQlbl());
                            } else {
                                bdcQlr.setQlbl(qlbl.toString());
                            }
                            if (CommonUtil.getGybl((String)gdQlr.getQlbl()) < 1.0) {
                                bdcQlr.setGyfs("2");
                            }
                        }
                    } else {
                        bdcQlr.setGyfs("1");
                    }
                } else {
                    bdcQlr.setGyfs("0");
                }
                bdcQlrList.add(bdcQlr);
            }
        }
        return bdcQlrList;
    }

    public List<BdcQlr> readGdFwQlrs(List<GdQlr> gdQlrs, GdFw gdFw, String proid) {
        ArrayList<BdcQlr> bdcQlrList = new ArrayList<BdcQlr>();
        if (gdQlrs != null && gdQlrs.size() > 0) {
            for (GdQlr gdQlr : gdQlrs) {
                BdcQlr bdcQlr = null;
                if (gdQlr == null) continue;
                bdcQlr = new BdcQlr();
                if (gdQlr.getSxh() == 0) {
                    bdcQlr.setSxh(2);
                } else {
                    bdcQlr.setSxh(gdQlr.getSxh());
                }
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                    bdcQlr.setQlrmc(gdQlr.getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrzjh())) {
                    bdcQlr.setQlrzjh(gdQlr.getQlrzjh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrsfzjzl())) {
                    bdcQlr.setQlrsfzjzl(gdQlr.getQlrsfzjzl());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrlx())) {
                    bdcQlr.setQlrlx(gdQlr.getQlrlx());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrxz())) {
                    bdcQlr.setQlrxz(gdQlr.getQlrxz());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlbl())) {
                    bdcQlr.setQlbl(CommonUtil.getGybl((String)gdQlr.getQlbl()).toString());
                    if (gdQlrs.size() > 1) {
                        if (CommonUtil.getGybl((String)gdQlr.getQlbl()) < 1.0) {
                            bdcQlr.setGyfs("2");
                        } else {
                            bdcQlr.setGyfs("1");
                        }
                    } else {
                        bdcQlr.setGyfs("0");
                    }
                }
                if (gdFw != null && StringUtils.isNotBlank((CharSequence)gdFw.getGyqk())) {
                    bdcQlr.setGyfs(gdFw.getGyqk());
                }
                bdcQlr.setProid(proid);
                bdcQlrList.add(bdcQlr);
            }
        }
        return bdcQlrList;
    }

    public List<BdcQlr> readGdTdQlrs(List<GdQlr> gdQlrs, GdTd gdTd) {
        ArrayList<BdcQlr> bdcQlrList = new ArrayList<BdcQlr>();
        if (gdQlrs != null && gdQlrs.size() > 0) {
            for (GdQlr gdQlr : gdQlrs) {
                BdcQlr bdcQlr = null;
                if (gdQlr == null) continue;
                bdcQlr = new BdcQlr();
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                if (gdQlr.getSxh() == 0) {
                    bdcQlr.setSxh(2);
                } else {
                    bdcQlr.setSxh(gdQlr.getSxh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                    bdcQlr.setQlrmc(gdQlr.getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrzjh())) {
                    bdcQlr.setQlrzjh(gdQlr.getQlrzjh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrsfzjzl())) {
                    bdcQlr.setQlrsfzjzl(gdQlr.getQlrsfzjzl());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrlx())) {
                    bdcQlr.setQlrlx(gdQlr.getQlrlx());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrxz())) {
                    bdcQlr.setQlrxz(gdQlr.getQlrxz());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlbl())) {
                    bdcQlr.setQlbl(CommonUtil.getGybl((String)gdQlr.getQlbl()).toString());
                    if (gdQlrs.size() > 1) {
                        if (CommonUtil.getGybl((String)gdQlr.getQlbl()) < 1.0) {
                            bdcQlr.setGyfs("2");
                        } else {
                            bdcQlr.setGyfs("1");
                        }
                    } else {
                        bdcQlr.setGyfs("0");
                    }
                }
                if (gdTd != null && StringUtils.isNotBlank((CharSequence)gdTd.getGyqk())) {
                    bdcQlr.setGyfs(gdTd.getGyqk());
                }
                bdcQlrList.add(bdcQlr);
            }
        }
        return bdcQlrList;
    }

    public void delGdQlrByQlid(String qlid) {
        this.gdQlrMapper.delGdQlrByQlid(qlid);
    }

    @Transactional(readOnly=true)
    public List<GdQlr> queryGdQlrListByProid(String proid, String qlrlx) {
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)proid) && StringUtils.isNotBlank((CharSequence)qlrlx)) {
            Example qlrTemp = new Example(GdQlr.class);
            Example.Criteria criteria = qlrTemp.createCriteria();
            criteria.andEqualTo("proid", (Object)proid).andEqualTo("qlrlx", (Object)qlrlx);
            list = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
        }
        return list;
    }

    @Transactional(readOnly=true)
    public String getGdQlrsByProid(String proid, String qlrlx) {
        String qlrs = "";
        List gdQlrList = this.queryGdQlrListByProid(proid, qlrlx);
        if (CollectionUtils.isNotEmpty((Collection)gdQlrList)) {
            if (CollectionUtils.size((Object)gdQlrList) > 3) {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs = qlrs + "," + gdQlr.getQlr();
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs = gdQlr.getQlr();
                }
                if (StringUtils.isNotBlank((CharSequence)qlrs)) {
                    qlrs = qlrs + "\u7b49";
                }
            } else {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs = qlrs + "," + gdQlr.getQlr();
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs = gdQlr.getQlr();
                }
            }
        }
        return qlrs;
    }

    @Transactional(readOnly=true)
    public List<GdQlr> queryGdQlrsByQlr(String qlr, String qlrlx) {
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)qlr)) {
            Example qlrTemp = new Example(GdQlr.class);
            Example.Criteria criteria = qlrTemp.createCriteria();
            criteria.andLike("qlr", "%" + qlr + "%");
            if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                criteria.andEqualTo("qlrlx", (Object)qlrlx);
            }
            list = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
        }
        return list;
    }

    @Transactional(readOnly=true)
    public String getGdQlrsByQlid(String qlid, String qlrlx) {
        String qlrs = "";
        List gdQlrList = this.queryGdQlrs(qlid, qlrlx);
        if (CollectionUtils.isNotEmpty((Collection)gdQlrList)) {
            if (CollectionUtils.size((Object)gdQlrList) > 3) {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs = qlrs + "," + gdQlr.getQlr();
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs = gdQlr.getQlr();
                }
                if (StringUtils.isNotBlank((CharSequence)qlrs)) {
                    qlrs = qlrs + "\u7b49";
                }
            } else {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs = qlrs + "," + gdQlr.getQlr();
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs = gdQlr.getQlr();
                }
            }
        }
        return qlrs;
    }

    public String combinationQlr(List<GdQlr> gdQlrList) {
        String qlr = "";
        if (gdQlrList != null && gdQlrList.size() > 0) {
            for (GdQlr gdQlr : gdQlrList) {
                if (qlr.equals("")) {
                    qlr = gdQlr.getQlr();
                    continue;
                }
                qlr = qlr + "\u3001" + gdQlr.getQlr();
            }
        }
        return qlr;
    }

    public List<GdQlr> getGdQlrsByQlids(List qlids, String qlrlx) {
        if (CollectionUtils.isNotEmpty((Collection)qlids)) {
            Example exampQlr = new Example(GdQlr.class);
            exampQlr.setOrderByClause("qlid DESC");
            exampQlr.createCriteria().andIn("qlid", qlids).andEqualTo("qlrlx", (Object)"qlr");
            return this.entryMapper.selectByExampleNotNull(exampQlr);
        }
        return new ArrayList<GdQlr>();
    }

    public List<String> getGdQlrmcs(List qlids, String qlrlx) {
        List gdQlrList;
        if (CollectionUtils.isNotEmpty((Collection)qlids) && StringUtils.isNotBlank((CharSequence)qlrlx) && CollectionUtils.isNotEmpty((Collection)(gdQlrList = this.getGdQlrsByQlids(qlids, qlrlx)))) {
            HashSet<String> qlrmcSet = new HashSet<String>();
            for (GdQlr gdQlr : gdQlrList) {
                qlrmcSet.add(gdQlr.getQlr());
            }
            if (CollectionUtils.isNotEmpty(qlrmcSet)) {
                return new ArrayList<String>(qlrmcSet);
            }
        }
        return new ArrayList<String>();
    }
}

