/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.server.core.service.BdcXmZsRelService;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcXmZsRelServiceImpl
implements BdcXmZsRelService {
    @Autowired
    EntityMapper entryMapper;

    public List<BdcXmzsRel> queryBdcXmZsRelByProid(String proid) {
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcXmzsRel.class);
            example.createCriteria().andEqualTo("proid", (Object)proid);
            list = this.entryMapper.selectByExample(BdcXmzsRel.class, (Object)example);
        }
        return list;
    }

    public String getProidByZsid(String zsid) {
        String proid = null;
        if (StringUtils.isNotBlank((CharSequence)zsid)) {
            Example example = new Example(BdcXmzsRel.class);
            example.createCriteria().andEqualTo("zsid", (Object)zsid);
            List list = this.entryMapper.selectByExample(BdcXmzsRel.class, (Object)example);
            if (list != null && list.size() > 0) {
                proid = ((BdcXmzsRel)list.get(0)).getProid();
            }
        }
        return proid;
    }

    public void delBdcXmZsRelByProid(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcXmzsRel.class);
            example.createCriteria().andEqualTo("proid", (Object)proid);
            this.entryMapper.deleteByExample(BdcXmzsRel.class, (Object)example);
        }
    }

    public void delBdcXmZsRelByXmzsgxid(String xmzsgxid) {
        if (StringUtils.isNotBlank((CharSequence)xmzsgxid)) {
            Example example = new Example(BdcXmzsRel.class);
            example.createCriteria().andEqualTo("xmzsgxid", (Object)xmzsgxid);
            this.entryMapper.deleteByExample(BdcXmzsRel.class, (Object)example);
        }
    }

    public List<BdcXmzsRel> creatBdcXmZsRel(List<BdcZs> list, String proid) {
        this.delBdcXmZsRelByProid(proid);
        ArrayList<BdcXmzsRel> bdcXmzsRelList = this.queryBdcXmZsRelByProid(proid);
        if (bdcXmzsRelList != null && bdcXmzsRelList.size() > 0) {
            for (BdcZs bdcZs : list) {
                String zsid = bdcZs.getZsid();
                Boolean isInsert = true;
                for (BdcXmzsRel bdcXmzsRel : bdcXmzsRelList) {
                    if (!bdcXmzsRel.getZsid().equals(zsid)) continue;
                    isInsert = false;
                    break;
                }
                if (!isInsert.booleanValue()) continue;
                BdcXmzsRel bdcXmzsRel = this.creatBdcXmZsRel(bdcZs.getZsid(), proid);
                bdcXmzsRelList.add(bdcXmzsRel);
            }
        } else {
            bdcXmzsRelList = new ArrayList<BdcXmzsRel>();
            for (BdcZs bdcZs : list) {
                BdcXmzsRel bdcXmzsRel = this.creatBdcXmZsRel(bdcZs.getZsid(), proid);
                bdcXmzsRelList.add(bdcXmzsRel);
            }
        }
        return bdcXmzsRelList;
    }

    public BdcXmzsRel creatBdcXmZsRel(String zsid, String proid) {
        BdcXmzsRel bdcXmzsRel = new BdcXmzsRel();
        bdcXmzsRel.setProid(proid);
        bdcXmzsRel.setXmzsgxid(UUIDGenerator.generate18());
        bdcXmzsRel.setZsid(zsid);
        this.entryMapper.insertSelective((Object)bdcXmzsRel);
        return bdcXmzsRel;
    }
}

