/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcSjclConfig;
import cn.gtmap.estateplat.model.server.core.BdcSjclRel;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcSjdService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.model.FileModel;
import cn.gtmap.estateplat.server.model.FolderModel;
import cn.gtmap.estateplat.server.model.FoldersModel;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcSjdServiceImpl
implements BdcSjdService {
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;

    @Transactional(readOnly=true)
    public List<BdcSjcl> getSjclListByWiid(String wiid, String proid) {
        List bdcSjclList = null;
        Example bdcSjxx = new Example(BdcSjxx.class);
        bdcSjxx.createCriteria().andEqualTo("proid", (Object)proid);
        List bdcSjxxList = this.entryMapper.selectByExample(BdcSjxx.class, (Object)bdcSjxx);
        if (bdcSjxxList != null && bdcSjxxList.size() > 0) {
            String sjxxid = ((BdcSjxx)bdcSjxxList.get(0)).getSjxxid();
            Example bdcSjcl = new Example(BdcSjcl.class);
            bdcSjcl.createCriteria().andEqualTo("sjxxid", (Object)sjxxid);
            bdcSjclList = this.entryMapper.selectByExample(BdcSjcl.class, (Object)bdcSjcl);
        }
        return bdcSjclList;
    }

    @Transactional(readOnly=true)
    public List<BdcSjxx> queryBdcSjdByWiid(String wiid) {
        List bdcSjxxList = null;
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            Example bdcSjxx = new Example(BdcSjxx.class);
            bdcSjxx.createCriteria().andEqualTo("wiid", (Object)wiid);
            bdcSjxxList = this.entryMapper.selectByExample(BdcSjxx.class, (Object)bdcSjxx);
        }
        return bdcSjxxList;
    }

    @Transactional(readOnly=true)
    public List<BdcSjcl> getSjclListBySjxxid(String sjxxid) {
        List bdcSjclList = null;
        if (StringUtils.isNotBlank((CharSequence)sjxxid)) {
            Example bdcSjcl = new Example(BdcSjcl.class);
            bdcSjcl.createCriteria().andEqualTo("sjxxid", (Object)sjxxid);
            bdcSjcl.setOrderByClause("to_number(xh)");
            bdcSjclList = this.entryMapper.selectByExample(BdcSjcl.class, (Object)bdcSjcl);
        }
        return bdcSjclList;
    }

    @Transactional
    public void delSjclListBySjxxid(String sjxxid) {
        if (StringUtils.isNotBlank((CharSequence)sjxxid)) {
            Example bdcSjcl = new Example(BdcSjcl.class);
            bdcSjcl.createCriteria().andEqualTo("sjxxid", (Object)sjxxid);
            this.entryMapper.deleteByExample(BdcSjcl.class, (Object)bdcSjcl);
        }
    }

    @Transactional
    public void delBdcSjxxBySjxxid(String sjxxid) {
        if (StringUtils.isNotBlank((CharSequence)sjxxid)) {
            this.entryMapper.deleteByPrimaryKey(BdcSjxx.class, (Object)sjxxid);
        }
    }

    @Transactional
    public void saveSjcl(BdcSjcl bdcSjcl) {
        if (bdcSjcl != null) {
            if (StringUtils.isBlank((CharSequence)bdcSjcl.getSjclid())) {
                bdcSjcl.setSjclid(UUIDGenerator.generate());
            }
            this.entryMapper.updateByPrimaryKeySelective((Object)bdcSjcl);
        }
    }

    @Transactional(readOnly=true)
    public List<BdcSjclRel> getSjclRelList(String sqlxdm, String ysqlxdm) {
        List bdcSjclRelList = null;
        if (StringUtils.isNotBlank((CharSequence)sqlxdm) && StringUtils.isNotBlank((CharSequence)ysqlxdm)) {
            Example bdcSjcl = new Example(BdcSjclRel.class);
            bdcSjcl.createCriteria().andEqualTo("sqlxdm", (Object)sqlxdm);
            bdcSjcl.createCriteria().andEqualTo("ysqlxdm", (Object)ysqlxdm);
            bdcSjclRelList = this.entryMapper.selectByExample(BdcSjclRel.class, (Object)bdcSjcl);
        }
        return bdcSjclRelList;
    }

    @Transactional
    public void updateSjclFromYpro(String proid, String yproid) {
        if (StringUtils.isNotBlank((CharSequence)yproid) && StringUtils.isNotBlank((CharSequence)proid)) {
            List bdcSjclRelList;
            BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
            BdcXm ybdcXm = this.bdcXmService.getBdcXmByProid(yproid);
            List bdcSjclList = this.getSjclListByWiid(bdcXm.getWiid(), bdcXm.getProid());
            List bdcSjxxList = this.queryBdcSjdByWiid(bdcXm.getWiid());
            Integer yproject_fileId = this.platformUtil.getProjectFileId(yproid);
            Integer project_fileId = this.platformUtil.getProjectFileId(proid);
            BdcSjxx bdcSjxx = null;
            if (bdcSjxxList == null || bdcSjxxList.size() == 0) {
                bdcSjxx = new BdcSjxx();
                bdcSjxx.setSjxxid(UUIDGenerator.generate());
                bdcSjxx.setWiid(bdcXm.getWiid());
                this.addBdcSjxx(bdcSjxx);
            } else {
                bdcSjxx = (BdcSjxx)bdcSjxxList.get(0);
            }
            if (ybdcXm != null && StringUtils.isNotBlank((CharSequence)ybdcXm.getSqlx()) && bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getSqlx()) && (bdcSjclRelList = this.getSjclRelList(bdcXm.getSqlx(), ybdcXm.getSqlx())) != null && bdcSjclRelList.size() > 0 && bdcSjclList != null && bdcSjclList.size() > 0) {
                for (BdcSjclRel bdcSjclRel : bdcSjclRelList) {
                    boolean hasSjcl = false;
                    int xh = 0;
                    BdcSjcl sjcl = null;
                    for (BdcSjcl bdcSjcl : bdcSjclList) {
                        if (StringUtils.equals((CharSequence)bdcSjcl.getClmc(), (CharSequence)bdcSjclRel.getSjclmc())) {
                            hasSjcl = true;
                            sjcl = bdcSjcl;
                        }
                        if (bdcSjcl.getXh() <= xh) continue;
                        xh = bdcSjcl.getXh();
                    }
                    if (!hasSjcl || sjcl == null) continue;
                    sjcl.setFs(this.platformUtil.getAllChildFilesCountByNodeName(yproject_fileId, bdcSjclRel.getYsjclmc()));
                    this.platformUtil.copyNodeToNode(yproject_fileId, bdcSjclRel.getYsjclmc(), project_fileId, bdcSjclRel.getSjclmc(), false);
                    this.saveSjcl(sjcl);
                }
            }
        }
    }

    @Transactional
    public void addBdcSjxx(BdcSjxx bdcSjxx) {
        if (bdcSjxx != null) {
            if (StringUtils.isBlank((CharSequence)bdcSjxx.getSjxxid())) {
                bdcSjxx.setSjxxid(UUIDGenerator.generate());
            }
            this.entryMapper.insertSelective((Object)bdcSjxx);
        }
    }

    @Transactional
    public void addBdcSjcl(BdcSjcl bdcSjcl) {
        if (bdcSjcl != null) {
            if (StringUtils.isBlank((CharSequence)bdcSjcl.getSjclid())) {
                bdcSjcl.setSjclid(UUIDGenerator.generate());
            }
            this.entryMapper.insertSelective((Object)bdcSjcl);
        }
    }

    @Transactional(readOnly=true)
    public List<BdcSjclConfig> getSjclConfigList(String sqlxdm) {
        List bdcSjclList = null;
        if (StringUtils.isNotBlank((CharSequence)sqlxdm)) {
            Example bdcSjcl = new Example(BdcSjclConfig.class);
            bdcSjcl.createCriteria().andEqualTo("sqlxdm", (Object)sqlxdm);
            bdcSjclList = this.entryMapper.selectByExample(BdcSjclConfig.class, (Object)bdcSjcl);
        }
        return bdcSjclList;
    }

    public BdcSjxx createSjxxByBdcxm(BdcXm bdcXm) {
        List bdcSjxxList;
        BdcSjxx bdcSjxx = new BdcSjxx();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getWiid()) && ((bdcSjxxList = this.queryBdcSjdByWiid(bdcXm.getWiid())) == null || bdcSjxxList.size() == 0)) {
            bdcSjxx.setSjxxid(UUIDGenerator.generate());
            bdcSjxx.setProid(bdcXm.getProid());
            bdcSjxx.setWiid(bdcXm.getWiid());
            bdcSjxx.setSjr(bdcXm.getCjr());
            bdcSjxx.setSjrq(bdcXm.getCjsj());
            this.addBdcSjxx(bdcSjxx);
        }
        return bdcSjxx;
    }

    @Transactional(readOnly=true)
    public BdcSjxx createSjxxByBdcxmByProid(BdcXm bdcXm) {
        List bdcSjxxList;
        BdcSjxx bdcSjxx = new BdcSjxx();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getProid()) && ((bdcSjxxList = this.queryBdcSjdByProid(bdcXm.getProid())) == null || bdcSjxxList.size() == 0)) {
            bdcSjxx.setSjxxid(UUIDGenerator.generate());
            bdcSjxx.setProid(bdcXm.getProid());
            bdcSjxx.setWiid(bdcXm.getWiid());
            bdcSjxx.setSjr(bdcXm.getCjr());
            bdcSjxx.setSjrq(bdcXm.getCjsj());
        }
        return bdcSjxx;
    }

    @Transactional(readOnly=true)
    public List<BdcSjxx> queryBdcSjdByProid(String proid) {
        List bdcSjxxList = null;
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example bdcSjxx = new Example(BdcSjxx.class);
            bdcSjxx.createCriteria().andEqualTo("proid", (Object)proid);
            bdcSjxxList = this.entryMapper.selectByExample(BdcSjxx.class, (Object)bdcSjxx);
        }
        return bdcSjxxList;
    }

    public void delBdcSjxxByWiid(String wiid) {
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            Example bdcSjxx = new Example(BdcSjxx.class);
            bdcSjxx.createCriteria().andEqualTo("wiid", (Object)wiid);
            this.entryMapper.deleteByExample(BdcSjxx.class, (Object)bdcSjxx);
        }
    }

    public boolean updateSjcls(FoldersModel foldersModel) {
        boolean tag = false;
        if (foldersModel != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{foldersModel.getSjbh()})) {
            String wiid;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
            String proid = "";
            Integer project_fileId = null;
            List bdcXmList = this.bdcXmService.getBdcXmBySlbh(foldersModel.getSjbh());
            if (CollectionUtils.isNotEmpty((Collection)bdcXmList) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid = ((BdcXm)bdcXmList.get(0)).getWiid())) != null) {
                proid = pfWorkFlowInstanceVo.getProId();
            }
            try {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid})) {
                    project_fileId = this.platformUtil.getProjectFileId(proid);
                    if (CollectionUtils.isNotEmpty((Collection)foldersModel.getFolderList())) {
                        for (FolderModel folderModel : foldersModel.getFolderList()) {
                            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{folderModel.getName()})) continue;
                            Integer nodeId = this.platformUtil.createFileFolderByclmc(project_fileId, folderModel.getName());
                            if (folderModel.getFiles() == null || !CollectionUtils.isNotEmpty((Collection)folderModel.getFiles().getFileModelList())) continue;
                            for (FileModel fileModel : folderModel.getFiles().getFileModelList()) {
                                this.platformUtil.uploadFileFromUrl(fileModel.getUrl(), nodeId, fileModel.getName());
                            }
                        }
                    }
                }
                tag = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                tag = false;
            }
        }
        return tag;
    }

    public boolean updateSjclsFiles(FoldersModel foldersModel) {
        boolean tag = false;
        if (foldersModel != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{foldersModel.getSjbh()})) {
            String wiid;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
            String proid = "";
            Integer project_fileId = null;
            List bdcXmList = this.bdcXmService.getBdcXmBySlbh(foldersModel.getSjbh());
            if (CollectionUtils.isNotEmpty((Collection)bdcXmList) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid = ((BdcXm)bdcXmList.get(0)).getWiid())) != null) {
                proid = pfWorkFlowInstanceVo.getProId();
            }
            try {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid})) {
                    project_fileId = this.platformUtil.getProjectFileId(proid);
                    if (CollectionUtils.isNotEmpty((Collection)foldersModel.getFolderList())) {
                        for (FolderModel folderModel : foldersModel.getFolderList()) {
                            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{folderModel.getName()}) || folderModel.getFiles() == null || !CollectionUtils.isNotEmpty((Collection)folderModel.getFiles().getFileModelList())) continue;
                            for (FileModel fileModel : folderModel.getFiles().getFileModelList()) {
                                this.platformUtil.uploadFileFromUrl(fileModel.getUrl(), project_fileId, fileModel.getName());
                            }
                        }
                    }
                }
                tag = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                tag = false;
            }
        }
        return tag;
    }
}

