/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.DjsjCbzdDcb;
import cn.gtmap.estateplat.model.server.core.DjsjFwxx;
import cn.gtmap.estateplat.model.server.core.DjsjLqxx;
import cn.gtmap.estateplat.model.server.core.DjsjQszdDcb;
import cn.gtmap.estateplat.model.server.core.DjsjQszdQlr;
import cn.gtmap.estateplat.model.server.core.DjsjZdxx;
import cn.gtmap.estateplat.model.server.core.DjsjZhxx;
import cn.gtmap.estateplat.model.server.core.NydQlr;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.mapper.BdcQlrMapper;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcQlrServiceImpl
implements BdcQlrService {
    @Autowired
    BdcQlrMapper bdcQlrMapper;
    @Autowired
    EntityMapper entryMapper;

    public String combinationQlr(List<BdcQlr> bdcQlrList) {
        String qlr = "";
        if (bdcQlrList != null && bdcQlrList.size() > 0) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (qlr.equals("")) {
                    qlr = bdcQlr.getQlrmc();
                    continue;
                }
                qlr = qlr + "\u3001" + bdcQlr.getQlrmc();
            }
        }
        return qlr;
    }

    public List<BdcQlr> queryBdcQlrByProid(String proid) {
        ArrayList<BdcQlr> list = new ArrayList<BdcQlr>();
        List tempList = this.queryBdcQlrYwrByProid(proid);
        if (tempList != null && tempList.size() > 0) {
            for (int i = 0; i < tempList.size(); ++i) {
                BdcQlr bdcQlr = (BdcQlr)tempList.get(i);
                if (!StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrlx()) || !bdcQlr.getQlrlx().equals("qlr")) continue;
                list.add(bdcQlr);
            }
        }
        return list;
    }

    public List<BdcQlr> queryBdcYwrByProid(String proid) {
        ArrayList<BdcQlr> list = new ArrayList<BdcQlr>();
        List tempList = this.queryBdcQlrYwrByProid(proid);
        if (tempList != null && tempList.size() > 0) {
            for (BdcQlr bdcQlr : tempList) {
                if (!StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrlx()) || !bdcQlr.getQlrlx().equals("ywr")) continue;
                list.add(bdcQlr);
            }
        }
        return list;
    }

    @Transactional(readOnly=true)
    public List<BdcQlr> queryBdcQlrYwrByProid(String proid) {
        ArrayList<BdcQlr> list = new ArrayList<BdcQlr>();
        List tempList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            tempList = this.bdcQlrMapper.queryBdcQlrByProid(proid);
        }
        if (tempList != null && tempList.size() > 0) {
            for (BdcQlr bdcQlr : tempList) {
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                list.add(bdcQlr);
            }
        }
        return list;
    }

    public BdcQlr getBdcQlrFromProject(Project project, BdcQlr qlr) {
        if (project == null) {
            return qlr;
        }
        if (qlr == null) {
            qlr = new BdcQlr();
        }
        if (StringUtils.isBlank((CharSequence)qlr.getQlrid())) {
            qlr.setQlrid(UUIDGenerator.generate());
        }
        qlr.setProid(project.getProid());
        return qlr;
    }

    public BdcQlr getBdcQlrFromFw(DjsjFwxx fwxx, BdcQlr qlr) {
        if (fwxx == null) {
            return qlr;
        }
        if (qlr == null) {
            qlr = new BdcQlr();
        }
        qlr.setQlrmc(fwxx.getQlr());
        qlr.setQlrsfzjzl(fwxx.getQlrzjlx());
        qlr.setQlrzjh(fwxx.getQlrzjh());
        if (StringUtils.isNotBlank((CharSequence)fwxx.getDh())) {
            qlr.setQlrlxdh(fwxx.getDh());
        }
        if (StringUtils.isNotBlank((CharSequence)fwxx.getDz())) {
            qlr.setQlrtxdz(fwxx.getDz());
        }
        if (StringUtils.isNotBlank((CharSequence)fwxx.getYb())) {
            qlr.setQlryb(fwxx.getYb());
        }
        qlr.setGyfs(fwxx.getGyfs());
        if (fwxx.getDwxz() != null) {
            qlr.setQlrxz(fwxx.getDwxz().toString());
        }
        if (StringUtils.isBlank((CharSequence)qlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"7")) {
                qlr.setQlrxz("2");
            } else {
                qlr.setQlrxz("1");
            }
        }
        return qlr;
    }

    public List<BdcQlr> getBdcQlrFromLq(DjsjLqxx lqxx, BdcQlr qlr) {
        List nydQlrList = new ArrayList();
        ArrayList<BdcQlr> qlrList = new ArrayList<BdcQlr>();
        if (lqxx != null && StringUtils.isNotBlank((CharSequence)lqxx.getDjh()) && CollectionUtils.isNotEmpty(nydQlrList = this.getNydQlrByDjh(lqxx.getDjh()))) {
            for (int i = 0; i < nydQlrList.size(); ++i) {
                BdcQlr bdcQlr = new BdcQlr();
                if (StringUtils.isNotBlank((CharSequence)qlr.getProid())) {
                    bdcQlr.setProid(qlr.getProid());
                }
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getSfldsyqr()}) || !StringUtils.equals((CharSequence)((NydQlr)nydQlrList.get(i)).getSfldsyqr(), (CharSequence)"1")) continue;
                bdcQlr.setQlrlx("qlr");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlr()})) {
                    bdcQlr.setQlrmc(((NydQlr)nydQlrList.get(i)).getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)qlr.getQlrid())) {
                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrsfzjzl()})) {
                    bdcQlr.setQlrsfzjzl(((NydQlr)nydQlrList.get(i)).getQlrsfzjzl());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrzjh()})) {
                    bdcQlr.setQlrzjh(((NydQlr)nydQlrList.get(i)).getQlrzjh());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrtxdz()})) {
                    bdcQlr.setQlrtxdz(((NydQlr)nydQlrList.get(i)).getQlrtxdz());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrfddbr()})) {
                    bdcQlr.setQlrfddbr(((NydQlr)nydQlrList.get(i)).getQlrfddbr());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrfddbrdh()})) {
                    bdcQlr.setQlrfddbrdh(((NydQlr)nydQlrList.get(i)).getQlrfddbrdh());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrdlr()})) {
                    bdcQlr.setQlrdlr(((NydQlr)nydQlrList.get(i)).getQlrdlr());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((NydQlr)nydQlrList.get(i)).getQlrdlrdh()})) {
                    bdcQlr.setQlrdlrdh(((NydQlr)nydQlrList.get(i)).getQlrdlrdh());
                }
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                qlrList.add(bdcQlr);
            }
        }
        return qlrList;
    }

    public List<BdcQlr> getBdcQlrFromCb(DjsjCbzdDcb cbzdDcb, BdcQlr qlr) {
        ArrayList<BdcQlr> qlrList = new ArrayList<BdcQlr>();
        List nydQlrList = new ArrayList();
        if (cbzdDcb != null && CollectionUtils.isNotEmpty(nydQlrList = this.getNydQlrByDjh(cbzdDcb.getDjh()))) {
            for (int i = 0; i < nydQlrList.size(); ++i) {
                BdcQlr bdcQlr = new BdcQlr();
                NydQlr nydQlr = (NydQlr)nydQlrList.get(i);
                if (StringUtils.isNotBlank((CharSequence)qlr.getProid())) {
                    bdcQlr.setProid(qlr.getProid());
                }
                if (StringUtils.isNotBlank((CharSequence)qlr.getQlrid())) {
                    bdcQlr.setQlrid(qlr.getQlrid());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlr()})) {
                    bdcQlr.setQlrmc(nydQlr.getQlr());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrsfzjzl()})) {
                    bdcQlr.setQlrsfzjzl(nydQlr.getQlrsfzjzl());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrzjh()})) {
                    bdcQlr.setQlrzjh(nydQlr.getQlrzjh());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrtxdz()})) {
                    bdcQlr.setQlrtxdz(nydQlr.getQlrtxdz());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrfddbr()})) {
                    bdcQlr.setQlrfddbr(nydQlr.getQlrfddbr());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrfddbrdh()})) {
                    bdcQlr.setQlrfddbrdh(nydQlr.getQlrfddbrdh());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrdlr()})) {
                    bdcQlr.setQlrdlr(nydQlr.getQlrdlr());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nydQlr.getQlrdlrdh()})) {
                    bdcQlr.setQlrdlrdh(nydQlr.getQlrdlrdh());
                }
                bdcQlr.setQlrlx("qlr");
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                qlrList.add(bdcQlr);
            }
        }
        return qlrList;
    }

    public List<BdcQlr> getBdcQlrFromQszd(DjsjQszdDcb djsjQszdDcb, BdcQlr qlr) {
        ArrayList<BdcQlr> qlrList = new ArrayList<BdcQlr>();
        List qszdQlrList = new ArrayList();
        String djh = "";
        djh = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{djsjQszdDcb.getDjh()}) ? djsjQszdDcb.getDjh() : StringUtils.substring((String)djsjQszdDcb.getBdcdyh(), (int)0, (int)19);
        qszdQlrList = this.getQszdQlrDjh(djh);
        if (CollectionUtils.isNotEmpty(qszdQlrList)) {
            for (int i = 0; i < qszdQlrList.size(); ++i) {
                BdcQlr bdcQlr = new BdcQlr();
                DjsjQszdQlr qszdQlr = (DjsjQszdQlr)qszdQlrList.get(0);
                if (StringUtils.isNotBlank((CharSequence)qlr.getQlrid())) {
                    bdcQlr.setQlrid(qlr.getQlrid());
                }
                if (StringUtils.isNotBlank((CharSequence)qlr.getProid())) {
                    bdcQlr.setProid(qlr.getProid());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getQlrmc()})) {
                    bdcQlr.setQlrmc(qszdQlr.getQlrmc());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getQlrzjlx()})) {
                    bdcQlr.setQlrsfzjzl(qszdQlr.getQlrzjlx());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getQlrzjh()})) {
                    bdcQlr.setQlrzjh(qszdQlr.getQlrzjh());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getTxdz()})) {
                    bdcQlr.setQlrtxdz(qszdQlr.getTxdz());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getFrdbxm()})) {
                    bdcQlr.setQlrfddbr(qszdQlr.getFrdbxm());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getFrdbxm()})) {
                    bdcQlr.setQlrfddbr(qszdQlr.getFrdbxm());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getDlrxm()})) {
                    bdcQlr.setQlrdlr(qszdQlr.getDlrxm());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszdQlr.getDlrdhhm()})) {
                    bdcQlr.setQlrdlrdh(qszdQlr.getDlrdhhm());
                }
                bdcQlr.setQlrlx("qlr");
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                qlrList.add(bdcQlr);
            }
        }
        return qlrList;
    }

    public BdcQlr getBdcQlrFromZd(DjsjZdxx zdxx, BdcQlr qlr) {
        if (zdxx == null) {
            return qlr;
        }
        if (qlr == null) {
            qlr = new BdcQlr();
        }
        qlr.setQlrmc(zdxx.getQlrmc());
        qlr.setQlrfddbrdh(zdxx.getFrdbdhhm());
        qlr.setQlrdlr(zdxx.getDlrxm());
        qlr.setQlrdlrdh(zdxx.getDlrdhhm());
        qlr.setQlrfddbr(zdxx.getFrdbxm());
        qlr.setQlrsfzjzl(zdxx.getQlrzjlx());
        qlr.setQlrtxdz(zdxx.getTxdz());
        qlr.setQlrzjh(zdxx.getQlrzjh());
        if (StringUtils.isBlank((CharSequence)qlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"7")) {
                qlr.setQlrxz("2");
            } else {
                qlr.setQlrxz("1");
            }
        }
        return qlr;
    }

    @Transactional(readOnly=true)
    public List<BdcQlr> queryBdcQlrList(Map map) {
        return this.bdcQlrMapper.queryBdcQlrList(map);
    }

    @Transactional
    public void delBdcQlrByProid(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcQlr.class);
            example.createCriteria().andEqualTo("proid", (Object)proid);
            this.entryMapper.deleteByExample(BdcQlr.class, (Object)example);
        }
    }

    @Transactional
    public void delBdcQlrByQlrid(String qlrid) {
        if (StringUtils.isNotBlank((CharSequence)qlrid)) {
            this.entryMapper.deleteByPrimaryKey(BdcQlr.class, (Object)qlrid);
        }
    }

    @Transactional
    public void delBdcQlrByQlrid(String qlrid, String qlrlx) {
        if (StringUtils.isNotBlank((CharSequence)qlrid)) {
            Example example = new Example(BdcQlr.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("qlrid", (Object)qlrid);
            if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                criteria.andEqualTo("qlrlx", (Object)qlrlx);
            }
            this.entryMapper.deleteByExample(BdcQlr.class, (Object)example);
        }
    }

    public BdcQlr qlrTurnProjectYwr(BdcQlr bdcQlr, List<BdcQlr> compareBdcqlrs, String proid) {
        bdcQlr.setProid(proid);
        bdcQlr.setQlrlx("ywr");
        String qlrid = "";
        if (StringUtils.isBlank((CharSequence)qlrid)) {
            qlrid = UUIDGenerator.generate18();
        }
        bdcQlr.setQlrid(qlrid);
        if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                bdcQlr.setQlrxz("2");
            } else {
                bdcQlr.setQlrxz("1");
            }
        }
        return bdcQlr;
    }

    public BdcQlr qlrTurnProjectJkr(BdcQlr bdcQlr, List<BdcQlr> compareBdcqlrs, String proid) {
        bdcQlr.setProid(proid);
        bdcQlr.setGyfs("");
        bdcQlr.setQlrlx("jkr");
        String qlrid = "";
        if (StringUtils.isBlank((CharSequence)qlrid)) {
            qlrid = UUIDGenerator.generate18();
        }
        bdcQlr.setQlrid(qlrid);
        if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                bdcQlr.setQlrxz("2");
            } else {
                bdcQlr.setQlrxz("1");
            }
        }
        return bdcQlr;
    }

    public BdcQlr qlrTurnProjectQlr(BdcQlr bdcQlr, List<BdcQlr> compareBdcqlrs, String proid) {
        bdcQlr.setProid(proid);
        bdcQlr.setQlrlx("qlr");
        String qlrid = "";
        if (compareBdcqlrs != null && compareBdcqlrs.size() > 0) {
            for (BdcQlr bdcQlrTemp : compareBdcqlrs) {
                if (bdcQlrTemp.getQlrmc() == null || bdcQlr.getQlrmc() == null || !bdcQlrTemp.getQlrmc().equals(bdcQlr.getQlrmc()) || bdcQlrTemp.getQlrzjh() == null || bdcQlr.getQlrzjh() == null || !bdcQlrTemp.getQlrzjh().equals(bdcQlrTemp.getQlrzjh())) continue;
                qlrid = bdcQlrTemp.getQlrid();
            }
        }
        if (StringUtils.isBlank((CharSequence)qlrid)) {
            qlrid = UUIDGenerator.generate18();
        }
        bdcQlr.setQlrid(qlrid);
        if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                bdcQlr.setQlrxz("2");
            } else {
                bdcQlr.setQlrxz("1");
            }
        }
        return bdcQlr;
    }

    public BdcQlr bdcQlrTurnProjectBdcQlr(BdcQlr bdcQlr, List<BdcQlr> compareBdcqlrs, String proid) {
        bdcQlr.setProid(proid);
        String qlrid = "";
        if (StringUtils.isBlank((CharSequence)qlrid)) {
            qlrid = UUIDGenerator.generate18();
        }
        bdcQlr.setQlrid(qlrid);
        if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                bdcQlr.setQlrxz("2");
            } else {
                bdcQlr.setQlrxz("1");
            }
        }
        return bdcQlr;
    }

    @Transactional(readOnly=true)
    public List<NydQlr> getNydQlrByDjh(String djh) {
        return this.bdcQlrMapper.getNydQlrByDjh(djh);
    }

    @Transactional(readOnly=true)
    public List<DjsjQszdQlr> getQszdQlrDjh(String djh) {
        return this.bdcQlrMapper.getQszdQlrDjh(djh);
    }

    public List<BdcQlr> getBdcQlrFromGdxx(List<BdcQlr> ybdcQlrList, Project project) {
        List tempBdcQlrList;
        ArrayList<BdcQlr> bdcQlrList = null;
        if (ybdcQlrList != null && ybdcQlrList.size() > 0) {
            tempBdcQlrList = this.queryBdcQlrByProid(project.getProid());
            if (tempBdcQlrList != null && tempBdcQlrList.size() > 0) {
                for (BdcQlr bdcQlr : tempBdcQlrList) {
                    this.delBdcQlrByQlrid(bdcQlr.getQlrid(), "qlr");
                }
            }
            ArrayList<BdcQlr> tempBdcQlrs = new ArrayList<BdcQlr>();
            for (BdcQlr bdcQlr : ybdcQlrList) {
                if (StringUtils.isBlank((CharSequence)(bdcQlr = this.qlrTurnProjectQlr(bdcQlr, tempBdcQlrList, project.getProid())).getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                tempBdcQlrs.add(bdcQlr);
            }
            bdcQlrList = tempBdcQlrs;
        }
        if (bdcQlrList != null && bdcQlrList.size() > 0 && (tempBdcQlrList = this.queryBdcQlrByProid(project.getProid())) != null && tempBdcQlrList.size() > 0) {
            for (BdcQlr bdcQlr : tempBdcQlrList) {
                this.delBdcQlrByQlrid(bdcQlr.getQlrid(), "qlr");
            }
        }
        return bdcQlrList;
    }

    public List<BdcQlr> getBdcDyQlrFromGdxx(List<BdcQlr> ybdcDyQlrList, Project project) {
        ArrayList<BdcQlr> bdcQlrList = null;
        if (ybdcDyQlrList != null && ybdcDyQlrList.size() > 0) {
            List tempBdcQlrList = this.queryBdcQlrByProid(project.getProid());
            if (tempBdcQlrList != null && tempBdcQlrList.size() > 0) {
                for (BdcQlr bdcQlr : tempBdcQlrList) {
                    this.delBdcQlrByQlrid(bdcQlr.getQlrid(), "dyqr");
                }
            }
            ArrayList<BdcQlr> tempBdcQlrs = new ArrayList<BdcQlr>();
            for (BdcQlr bdcQlr : ybdcDyQlrList) {
                bdcQlr = this.qlrTurnProjectQlr(bdcQlr, tempBdcQlrList, project.getProid());
                bdcQlr.setQlrxz("dyqr");
                tempBdcQlrs.add(bdcQlr);
            }
            bdcQlrList = tempBdcQlrs;
        }
        return bdcQlrList;
    }

    public List<BdcQlr> setQlrxzByZjlx(String proid) {
        List bdcQlrList = this.queryBdcQlrYwrByProid(proid);
        if (bdcQlrList != null) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                    bdcQlr.setQlrxz("2");
                    continue;
                }
                bdcQlr.setQlrxz("1");
            }
        }
        return bdcQlrList;
    }

    public List<BdcQlr> getBdcYwrFromGdxx(List<BdcQlr> ybdcYwrList, Project project) {
        List tempBdcYwrList;
        ArrayList<BdcQlr> bdcYwrList = null;
        if (ybdcYwrList != null && ybdcYwrList.size() > 0) {
            tempBdcYwrList = this.queryBdcYwrByProid(project.getProid());
            if (tempBdcYwrList != null && tempBdcYwrList.size() > 0) {
                for (BdcQlr bdcYwr : tempBdcYwrList) {
                    this.delBdcQlrByQlrid(bdcYwr.getQlrid(), "ywr");
                }
            }
            ArrayList<BdcQlr> tempBdcYwrs = new ArrayList<BdcQlr>();
            for (BdcQlr bdcQlr : ybdcYwrList) {
                if (StringUtils.isBlank((CharSequence)(bdcQlr = this.qlrTurnProjectYwr(bdcQlr, tempBdcYwrList, project.getProid())).getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                tempBdcYwrs.add(bdcQlr);
            }
            bdcYwrList = tempBdcYwrs;
        }
        if (bdcYwrList != null && bdcYwrList.size() > 0 && (tempBdcYwrList = this.queryBdcYwrByProid(project.getProid())) != null && tempBdcYwrList.size() > 0) {
            for (BdcQlr bdcYwr : tempBdcYwrList) {
                this.delBdcQlrByQlrid(bdcYwr.getQlrid(), "ywr");
            }
        }
        return bdcYwrList;
    }

    public List<BdcQlr> changeBdcQlrlxFromQlrList(List<BdcQlr> bdcQlrList, String qlrlx) {
        ArrayList<BdcQlr> returnBdcQlrList = null;
        if (bdcQlrList != null && bdcQlrList.size() > 0 && StringUtils.isNotBlank((CharSequence)qlrlx)) {
            returnBdcQlrList = new ArrayList<BdcQlr>();
            for (BdcQlr bdcQlr : bdcQlrList) {
                bdcQlr.setQlrlx(qlrlx);
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                returnBdcQlrList.add(bdcQlr);
            }
        }
        return returnBdcQlrList;
    }

    public List<BdcQlr> changeGdqlrYsjToZdsj(List<BdcQlr> bdcQlrList) {
        ArrayList<BdcQlr> returnBdcQlrList = null;
        if (bdcQlrList != null && bdcQlrList.size() > 0) {
            returnBdcQlrList = new ArrayList<BdcQlr>();
            for (BdcQlr bdcQlr : bdcQlrList) {
                String sfzjzldm;
                if (StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrsfzjzl()) && StringUtils.isNotBlank((CharSequence)(sfzjzldm = this.bdcQlrMapper.changQlrsfzjzlToDm(bdcQlr.getQlrsfzjzl())))) {
                    bdcQlr.setQlrsfzjzl(sfzjzldm);
                }
                if (StringUtils.isBlank((CharSequence)bdcQlr.getQlrxz())) {
                    if (StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)bdcQlr.getQlrsfzjzl(), (CharSequence)"7")) {
                        bdcQlr.setQlrxz("2");
                    } else {
                        bdcQlr.setQlrxz("1");
                    }
                }
                returnBdcQlrList.add(bdcQlr);
            }
        }
        return returnBdcQlrList;
    }

    @Transactional(readOnly=true)
    public List<String> getGyfsByProid(String proid) {
        return this.bdcQlrMapper.getGyfsByProid(proid);
    }

    @Transactional(readOnly=true)
    public List<Map> getBdcdyidByProid(Map map) {
        return this.bdcQlrMapper.getBdcdyidByProid(map);
    }

    public BdcQlr ppxmQlr(BdcQlr bdcQlr, List<BdcQlr> yqlrList) {
        if (bdcQlr != null && CollectionUtils.isNotEmpty(yqlrList)) {
            for (BdcQlr ybdcQlr : yqlrList) {
                if (!StringUtils.equals((CharSequence)ybdcQlr.getQlrmc(), (CharSequence)bdcQlr.getQlrmc())) continue;
                bdcQlr.setQlrlxdh(ybdcQlr.getQlrlxdh());
            }
        }
        return bdcQlr;
    }

    @Transactional(readOnly=true)
    public String getGyqk(String proid) {
        List bdcQlrList = this.queryBdcQlrByProid(proid);
        DecimalFormat dc = new DecimalFormat(".00");
        String gyqk = "";
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (bdcQlr == null) continue;
                if (StringUtils.isBlank((CharSequence)gyqk)) {
                    if (StringUtils.equals((CharSequence)AppConfig.getProperty((String)"bdcqlr.qlbl.fs"), (CharSequence)"true")) {
                        if (NumberUtils.isNumber((String)bdcQlr.getQlbl())) {
                            gyqk = bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
                            continue;
                        }
                        gyqk = bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
                        continue;
                    }
                    gyqk = bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
                    continue;
                }
                if (StringUtils.equals((CharSequence)AppConfig.getProperty((String)"bdcqlr.qlbl.fs"), (CharSequence)"true")) {
                    if (NumberUtils.isNumber((String)bdcQlr.getQlbl())) {
                        gyqk = bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
                        continue;
                    }
                    gyqk = gyqk + " " + bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
                    continue;
                }
                gyqk = gyqk + " " + bdcQlr.getQlrmc() + ":" + bdcQlr.getQlbl();
            }
        }
        return gyqk;
    }

    @Transactional
    public void delQlrByProids(String[] proids) {
        this.bdcQlrMapper.delQlrByProids(proids);
    }

    @Transactional
    public void saveDjBdcQlrxx(BdcQlr qlr) {
        this.bdcQlrMapper.saveDjBdcQlrxx(qlr);
    }

    @Transactional
    public String changQlrsfzjzlToDm(String qlrsfzjzl) {
        return this.bdcQlrMapper.changQlrsfzjzlToDm(qlrsfzjzl);
    }

    public List<String> getQlrmcByProid(String proid) {
        return this.bdcQlrMapper.getQlrmcByProid(proid);
    }

    public BdcQlr getBdcQlrFromZh(DjsjZhxx zhxx, BdcQlr qlr) {
        if (zhxx == null) {
            return qlr;
        }
        if (qlr == null) {
            qlr = new BdcQlr();
        }
        qlr.setQlrmc(zhxx.getQlrmc());
        qlr.setQlrfddbrdh(zhxx.getFrdbdhhm());
        qlr.setQlrlxdh(zhxx.getQlrlxdh());
        qlr.setQlrdlr(zhxx.getDlrxm());
        qlr.setQlrdlrdh(zhxx.getDlrdhhm());
        qlr.setQlrfddbr(zhxx.getFrdbxm());
        qlr.setQlrsfzjzl(zhxx.getQlrzjlx());
        qlr.setQlrtxdz(zhxx.getTxdz());
        qlr.setQlrzjh(zhxx.getQlrzjh());
        if (StringUtils.isBlank((CharSequence)qlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"6") || StringUtils.equals((CharSequence)qlr.getQlrsfzjzl(), (CharSequence)"7")) {
                qlr.setQlrxz("2");
            } else {
                qlr.setQlrxz("1");
            }
        }
        return qlr;
    }

    public List<HashMap> getQlrByXmList(List<BdcXm> bdcXmList) {
        ArrayList<HashMap> hashMapList = new ArrayList<HashMap>();
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                String qlr = "";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (bdcXm == null || !StringUtils.isNotBlank((CharSequence)bdcXm.getProid())) continue;
                List bdcQlrList = this.queryBdcQlrByProid(bdcXm.getProid());
                if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
                    int i = 0;
                    for (BdcQlr bdcQlr : bdcQlrList) {
                        if (!StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrmc())) continue;
                        qlr = i == 0 ? bdcQlr.getQlrmc() : qlr + "," + bdcQlr.getQlrmc();
                        ++i;
                    }
                }
                hashMap.put("ID", bdcXm.getProid());
                hashMap.put("QLR", qlr);
                hashMapList.add(hashMap);
            }
        }
        return hashMapList;
    }

    @Transactional
    public void delBdcQlrByProid(String proid, String qlrlx) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcQlr.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("proid", (Object)proid);
            if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                criteria.andEqualTo("qlrlx", (Object)qlrlx);
            }
            this.entryMapper.deleteByExample(BdcQlr.class, (Object)example);
        }
    }

    public List<BdcQlr> queryBdcJkrByProid(String proid) {
        ArrayList<BdcQlr> list = new ArrayList<BdcQlr>();
        List tempList = this.queryBdcQlrYwrByProid(proid);
        if (tempList != null && tempList.size() > 0) {
            for (BdcQlr bdcQlr : tempList) {
                if (!StringUtils.isNotBlank((CharSequence)bdcQlr.getQlrlx()) || !bdcQlr.getQlrlx().equals("jkr")) continue;
                list.add(bdcQlr);
            }
        }
        return list;
    }

    public void saveQlrsByProidsAndQlrlx(List<BdcQlr> bdcQlrList, List<String> proidList, String qlrlx) {
        ArrayList<BdcQlr> bdcQlrListForUpdate = new ArrayList<BdcQlr>();
        if (CollectionUtils.isNotEmpty(bdcQlrList) && CollectionUtils.isNotEmpty(proidList)) {
            for (String proid : proidList) {
                this.delBdcQlrByProid(proid, qlrlx);
            }
            for (String proid : proidList) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    try {
                        BdcQlr tempQlr = new BdcQlr();
                        BeanUtils.copyProperties((Object)tempQlr, (Object)bdcQlr);
                        tempQlr.setQlrid(UUIDGenerator.generate18());
                        tempQlr.setProid(proid);
                        tempQlr.setQlrlx(qlrlx);
                        bdcQlrListForUpdate.add(tempQlr);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(bdcQlrListForUpdate)) {
            for (BdcQlr bdcQlr : bdcQlrListForUpdate) {
                this.entryMapper.saveOrUpdate((Object)bdcQlr, (Object)bdcQlr.getQlrid());
            }
        }
    }

    public void saveQlrsByProidAndQlrmc(String proid, List<BdcQlr> bdcYwrList) {
        for (BdcQlr bdcYwr : bdcYwrList) {
            Example example = new Example(BdcQlr.class);
            example.createCriteria().andEqualTo("proid", (Object)proid).andEqualTo("qlrmc", (Object)bdcYwr.getQlrmc()).andEqualTo("qlrlx", (Object)"ywr");
            List bdcQlrList = this.entryMapper.selectByExample(example);
            if (!CollectionUtils.isNotEmpty((Collection)bdcQlrList)) continue;
            for (BdcQlr bdcQlr : bdcQlrList) {
                BdcQlr newbdcQlr = null;
                newbdcQlr = bdcYwr;
                newbdcQlr.setQlrid(bdcQlr.getQlrid());
                newbdcQlr.setProid(bdcQlr.getProid());
                this.entryMapper.saveOrUpdate((Object)newbdcQlr, (Object)newbdcQlr.getQlrid());
            }
        }
    }

    public String getQlrByProidAndSqlx(String proid, String sqlx, String qlrlx, String wiid) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            queryMap.put("proid", proid);
        }
        if (StringUtils.isNotBlank((CharSequence)sqlx)) {
            queryMap.put("sqlx", sqlx);
        }
        if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
            queryMap.put("qlrlx", qlrlx);
        }
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            queryMap.put("wiid", wiid);
        }
        String qlr = this.bdcQlrMapper.getQlrByProidAndSqlx(queryMap);
        return qlr;
    }
}

