/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcJjd;
import cn.gtmap.estateplat.model.server.core.BdcJjdXx;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcYg;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.server.core.mapper.BdcJjdMapper;
import cn.gtmap.estateplat.server.core.service.BdcJjdService;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcSpxxService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcXmZsRelService;
import cn.gtmap.estateplat.server.core.service.BdcYgService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcJjdServiceImpl
implements BdcJjdService {
    @Autowired
    private BdcJjdMapper bdcJjdMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private BdcYgService bdcYgService;
    @Autowired
    private BdcXmZsRelService bdcXmZsRelService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    BdcZsService bdcZsService;

    @Transactional(readOnly=true)
    public BdcJjdXx getBdcJjdXxBySlh(String slh) {
        Example example = new Example(BdcJjdXx.class);
        example.createCriteria().andEqualTo("slh", (Object)slh);
        List bdcJjdXxList = this.entityMapper.selectByExample(BdcJjdXx.class, (Object)example);
        if (CollectionUtils.isNotEmpty((Collection)bdcJjdXxList)) {
            return (BdcJjdXx)bdcJjdXxList.get(0);
        }
        return null;
    }

    public List<BdcJjdXx> getJjdxxJsonByPage(Map map) {
        return this.bdcJjdMapper.getJjdxxJsonByPage(map);
    }

    public List<BdcJjdXx> getJjdJson(Map map) {
        return this.bdcJjdMapper.getJjdJson(map);
    }

    @Transactional
    public String creatBdcJjd(String slhs, String user) {
        String msg = "\u521b\u5efa\u5931\u8d25";
        String error = "";
        boolean isSave = true;
        try {
            List bdcJjdXxLists;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            if (slhs.split(",").length > 0) {
                map.put("bhs", slhs.split(","));
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdcJjdXxLists = this.getJjdxxJsonByPage(map)))) {
                Calendar a = Calendar.getInstance();
                String nf = a.get(1) + "";
                BdcJjd bdcJjd = new BdcJjd();
                bdcJjd.setJjdid(UUIDGenerator.generate18());
                bdcJjd.setJjrq(new Date());
                bdcJjd.setJjr(user);
                bdcJjd.setJjdbh(this.getJjdXh(nf));
                ArrayList<BdcJjdXx> bdcJjdXxList = new ArrayList<BdcJjdXx>();
                int i = 1;
                for (BdcJjdXx bdcJjdXx : bdcJjdXxLists) {
                    if (StringUtils.isNotBlank((CharSequence)bdcJjdXx.getSlh())) {
                        BdcJjdXx bdcJjdXxTemp = this.getBdcJjdXxBySlh(bdcJjdXx.getSlh());
                        if (bdcJjdXxTemp != null) {
                            error = error + bdcJjdXxTemp.getSlh() + ",";
                            isSave = false;
                        } else {
                            bdcJjdXx.setJjdxxid(UUIDGenerator.generate18());
                            bdcJjdXx.setJjdid(bdcJjd.getJjdid());
                            bdcJjdXx.setXl(i + "");
                        }
                        bdcJjdXxList.add(bdcJjdXx);
                    }
                    ++i;
                }
                if (isSave) {
                    this.entityMapper.saveOrUpdate((Object)bdcJjd, (Object)bdcJjd.getJjdid());
                    for (BdcJjdXx bdcJjdXx : bdcJjdXxList) {
                        this.entityMapper.saveOrUpdate((Object)bdcJjdXx, (Object)bdcJjdXx.getJjdxxid());
                    }
                    msg = bdcJjd.getJjdid();
                } else {
                    msg = "\u521b\u5efa\u5931\u8d25,\u53d7\u7406\u53f7\u4e3a\uff1a" + error + "\u5df2\u751f\u6210\u4ea4\u63a5\u5355";
                }
            } else {
                msg = "\u521b\u5efa\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9879\u76ee\u4fe1\u606f";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return msg;
    }

    public synchronized String getJjdXh(String nf) {
        String jjdbh = "";
        String xh = this.bdcJjdMapper.getJjdXh(nf);
        jjdbh = StringUtils.isNotBlank((CharSequence)xh) ? nf + xh : nf + "000000001";
        return jjdbh;
    }

    @Transactional(readOnly=true)
    public String deleteJjd(String jjdid) {
        String msg = "\u5220\u9664\u6210\u529f";
        try {
            Example example = new Example(BdcJjd.class);
            example.createCriteria().andEqualTo("jjdid", (Object)jjdid);
            this.entityMapper.deleteByExample(BdcJjd.class, (Object)example);
            msg = "\u5220\u9664\u6210\u529f";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    @Transactional(readOnly=true)
    public String deleteJjdxx(String jjdid) {
        String msg = "\u5220\u9664\u6210\u529f";
        Example example = new Example(BdcJjdXx.class);
        example.createCriteria().andEqualTo("jjdid", (Object)jjdid);
        List bdcJjdxxList = this.entityMapper.selectByExample(example);
        try {
            if (CollectionUtils.isNotEmpty((Collection)bdcJjdxxList)) {
                for (BdcJjdXx bdcJjdxx : bdcJjdxxList) {
                    Example exampleByJjdxxid = new Example(BdcJjdXx.class);
                    exampleByJjdxxid.createCriteria().andEqualTo("jjdxxid", (Object)bdcJjdxx.getJjdxxid());
                    this.entityMapper.deleteByExample(BdcJjdXx.class, (Object)example);
                    msg = "\u5220\u9664\u6210\u529f";
                }
            }
        }
        catch (Exception e) {
            System.out.printf(e.getMessage(), new Object[0]);
        }
        return msg;
    }

    @Transactional(readOnly=true)
    public List<String> getBeforeSlh(String bh) {
        return this.bdcJjdMapper.getBeforeSlh(bh);
    }

    @Transactional(readOnly=true)
    public List<String> getAfterSlh(String bh) {
        return this.bdcJjdMapper.getAfterSlh(bh);
    }

    public String checkHasSave(String proids) {
        String msg = "";
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (StringUtils.isNotBlank((CharSequence)proids)) {
            map.put("proids", proids.split(","));
            List bdcJjdXxList = this.bdcJjdMapper.getBdcJjdXx(map);
            if (CollectionUtils.isNotEmpty((Collection)bdcJjdXxList)) {
                for (BdcJjdXx bdcJjdXx : bdcJjdXxList) {
                    String jjdid = bdcJjdXx.getJjdid();
                    BdcJjd bdcJjd = this.getBdcJjdByJjdid(jjdid);
                    String jjdh = "";
                    if (bdcJjd != null) {
                        jjdh = bdcJjd.getJjdbh();
                    }
                    msg = msg + "\u53d7\u7406\u53f7\u4e3a\uff1a" + bdcJjdXx.getSlh() + "\uff0c\u5728\u4ea4\u63a5\u5355\u53f7\uff1a" + jjdh + "\u5df2\u4fdd\u5b58\n";
                }
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public String saveJjdAndJjdxx(String proids) {
        BdcJjd bdcJjd = new BdcJjd();
        bdcJjd.setJjrq(new Date());
        bdcJjd.setJjr(SessionUtil.getCurrentUser().getUsername());
        Calendar calendar = Calendar.getInstance();
        String nf = calendar.get(1) + "";
        String jjdbh = new String();
        BdcJjdServiceImpl bdcJjdServiceImpl = this;
        synchronized (bdcJjdServiceImpl) {
            jjdbh = this.getJjdXh(nf);
            bdcJjd.setJjdbh(jjdbh);
            bdcJjd.setJjdid(UUIDGenerator.generate());
            this.entityMapper.saveOrUpdate((Object)bdcJjd, (Object)bdcJjd.getJjdid());
            if (StringUtils.isNotBlank((CharSequence)proids)) {
                String[] proidsArr = proids.split(",");
                int i = 1;
                for (String proid : proidsArr) {
                    BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
                    HashMap<String, String> queryMap = new HashMap<String, String>();
                    BdcJjdXx bdcJjdXx = new BdcJjdXx();
                    bdcJjdXx.setJjdxxid(UUIDGenerator.generate());
                    if (bdcXm != null) {
                        bdcJjdXx.setSlh(bdcXm.getBh());
                    }
                    bdcJjdXx.setProid(proid);
                    bdcJjdXx.setYwdjlx(this.getYwlxByProid(proid));
                    bdcJjdXx.setSqr(this.getSqrByProid(proid));
                    bdcJjdXx.setBdcdyh(this.getBdcdyhByProid(proid));
                    bdcJjdXx.setXl(i + "");
                    bdcJjdXx.setZl(this.getZlByProid(proid));
                    queryMap.put("proid", proid);
                    List resultList = this.bdcJjdMapper.getDgdByPage(queryMap);
                    if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                        String cqzh;
                        String string = cqzh = ((HashMap)resultList.get(0)).get("CQZH") == null ? "" : ((HashMap)resultList.get(0)).get("CQZH").toString();
                        if (StringUtils.isBlank((CharSequence)cqzh)) {
                            cqzh = this.getBdcqzhForSc(proid);
                        }
                        bdcJjdXx.setCqzh(cqzh);
                    }
                    bdcJjdXx.setJjdid(bdcJjd.getJjdid());
                    this.entityMapper.saveOrUpdate((Object)bdcJjdXx, (Object)bdcJjd.getJjdid());
                    ++i;
                }
            }
        }
        return bdcJjd.getJjdid();
    }

    private List<HashMap> getBdcJjdByJjdBh(String jjdbh) {
        ArrayList<HashMap> jjdMapList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jjdbh", jjdbh);
        jjdMapList = this.bdcJjdMapper.getJjdByPage(map);
        return jjdMapList;
    }

    public String getYwlxByProid(String proid) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        String ywlx = "";
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getWiid()) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(bdcXm.getWiid())) != null) {
            ywlx = PlatformUtil.getWdNameByWdid((String)pfWorkFlowInstanceVo.getWorkflowDefinitionId());
        }
        return ywlx;
    }

    public String getSqrByProid(String proid) {
        String qlr = "";
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        BdcYg bdcYg = this.bdcYgService.getBdcYgByProid(proid);
        HashMap queryMap = new HashMap();
        if (bdcXm != null) {
            List bdcXmzsRelList;
            qlr = StringUtils.equals((CharSequence)bdcXm.getQllx(), (CharSequence)"18") || bdcYg != null && StringUtils.equals((CharSequence)bdcYg.getYgdjzl(), (CharSequence)"3") ? (CollectionUtils.isNotEmpty((Collection)(bdcXmzsRelList = this.bdcXmZsRelService.queryBdcXmZsRelByProid(proid))) && bdcXmzsRelList.size() > 1 ? this.bdcQlrService.getQlrByProidAndSqlx(null, bdcXm.getSqlx(), "ywr", bdcXm.getWiid()) : this.bdcQlrService.getQlrByProidAndSqlx(proid, null, "ywr", null)) : this.bdcQlrService.getQlrByProidAndSqlx(proid, null, "qlr", null);
        }
        return qlr;
    }

    public String getBdcdyhByProid(String proid) {
        String bdcdyh = "";
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        BdcSpxx bdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(proid);
        if (bdcSpxx != null) {
            bdcdyh = bdcSpxx.getBdcdyh();
        }
        List bdcXmList = new ArrayList();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getWiid())) {
            bdcXmList = this.bdcXmService.getBdcXmListByWiid(bdcXm.getWiid());
        }
        bdcXmList = this.initBdcXmList(bdcXmList, bdcXm.getSqlx());
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getDjlx()) && (StringUtils.equals((CharSequence)bdcXm.getDjlx(), (CharSequence)"100") && !StringUtils.equals((CharSequence)bdcXm.getQllx(), (CharSequence)"18") || CommonUtil.indexOfStrs((String[])Constants.SQLX_PL_ONEZMS, (String)bdcXm.getSqlx())) && CollectionUtils.isNotEmpty(bdcXmList) && bdcXmList.size() > 1 && StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            bdcdyh = bdcdyh + "\u7b49" + bdcXmList.size() + "\u4e2a";
        }
        return bdcdyh;
    }

    public String getZlByProid(String proid) {
        String zl = "";
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        BdcSpxx bdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(proid);
        if (bdcSpxx != null) {
            zl = bdcSpxx.getZl();
        }
        List bdcXmList = new ArrayList();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getWiid())) {
            bdcXmList = this.bdcXmService.getBdcXmListByWiid(bdcXm.getWiid());
        }
        bdcXmList = this.initBdcXmList(bdcXmList, bdcXm.getSqlx());
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getDjlx()) && (StringUtils.equals((CharSequence)bdcXm.getDjlx(), (CharSequence)"100") && !StringUtils.equals((CharSequence)bdcXm.getQllx(), (CharSequence)"18") || CommonUtil.indexOfStrs((String[])Constants.SQLX_PL_ONEZMS, (String)bdcXm.getSqlx())) && CollectionUtils.isNotEmpty(bdcXmList) && bdcXmList.size() > 1 && StringUtils.isNotBlank((CharSequence)zl)) {
            zl = zl + "\u7b49" + bdcXmList.size() + "\u5957";
        }
        return zl;
    }

    private List<BdcXm> initBdcXmList(List<BdcXm> bdcXmList, String sqlx) {
        ArrayList<BdcXm> list = new ArrayList<BdcXm>();
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                if (!StringUtils.equals((CharSequence)bdcXm.getSqlx(), (CharSequence)sqlx)) continue;
                list.add(bdcXm);
            }
        }
        return list;
    }

    public String getBdcqzhForSc(String proid) {
        List bdcZsList;
        String cqzh = "";
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        List bdcXmList = new ArrayList();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getWiid())) {
            bdcXmList = this.bdcXmService.getBdcXmListByWiid(bdcXm.getWiid());
        }
        if (CollectionUtils.isNotEmpty((Collection)(bdcZsList = this.bdcZsService.queryBdcZsByProid(proid)))) {
            for (BdcZs bdcZs : bdcZsList) {
                if (StringUtils.isNotBlank((CharSequence)cqzh)) {
                    cqzh = cqzh + "/" + bdcZs.getBdcqzh();
                    continue;
                }
                cqzh = bdcZs.getBdcqzh();
            }
        }
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getDjlx()) && (StringUtils.equals((CharSequence)bdcXm.getDjlx(), (CharSequence)"100") && !StringUtils.equals((CharSequence)bdcXm.getQllx(), (CharSequence)"18") || CommonUtil.indexOfStrs((String[])Constants.SQLX_PL_ONEZMS, (String)bdcXm.getSqlx())) && CollectionUtils.isNotEmpty(bdcXmList) && bdcXmList.size() > 1 && StringUtils.isNotBlank((CharSequence)cqzh)) {
            cqzh = cqzh + "\u7b49" + bdcXmList.size() + "\u672c";
        }
        return cqzh;
    }

    public BdcJjd getBdcJjdByJjdid(String jjdid) {
        if (StringUtils.isNotBlank((CharSequence)jjdid)) {
            Example example = new Example(BdcJjd.class);
            example.createCriteria().andEqualTo("jjdid", (Object)jjdid);
            List bdcJjdList = this.entityMapper.selectByExample(BdcJjd.class, (Object)example);
            if (CollectionUtils.isNotEmpty((Collection)bdcJjdList)) {
                return (BdcJjd)bdcJjdList.get(0);
            }
        }
        return null;
    }
}

