/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcGdxx;
import cn.gtmap.estateplat.server.core.mapper.BdcGdxxMapper;
import cn.gtmap.estateplat.server.core.service.BdcGdxxService;
import com.gtis.common.util.UUIDGenerator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcGdxxServiceImpl
implements BdcGdxxService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcGdxxMapper bdcGdxxMapper;

    @Transactional
    public void insertBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null) {
            if (StringUtils.isBlank((CharSequence)bdcGdxx.getGdxxid())) {
                bdcGdxx.setGdxxid(UUIDGenerator.generate18());
            }
            this.entityMapper.saveOrUpdate((Object)bdcGdxx, (Object)bdcGdxx.getGdxxid());
        }
    }

    @Transactional
    public void updateBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null && StringUtils.isNotBlank((CharSequence)bdcGdxx.getGdxxid())) {
            this.entityMapper.updateByPrimaryKeySelective((Object)bdcGdxx);
        }
    }

    public BdcGdxx initBdcGdxx(BdcGdxx bdcGdxx, String gdxml) {
        try {
            Document document;
            Node archiveNode;
            if (StringUtils.isNotBlank((CharSequence)gdxml) && (archiveNode = (document = DocumentHelper.parseText((String)gdxml)).selectSingleNode("//list/archive")) != null) {
                Element archiveElement;
                if (bdcGdxx == null) {
                    bdcGdxx = new BdcGdxx();
                    bdcGdxx.setGdxxid(UUIDGenerator.generate18());
                }
                if (StringUtils.isNotBlank((CharSequence)(archiveElement = (Element)archiveNode).attributeValue("result"))) {
                    if (archiveElement.attributeValue("result").equals("succeed")) {
                        List fieldList = archiveNode.selectNodes("field");
                        if (fieldList != null && fieldList.size() > 0) {
                            for (Node field : fieldList) {
                                Element fieldElement = (Element)field;
                                String name = fieldElement.attributeValue("name");
                                if (name != null && name.equals("id")) {
                                    bdcGdxx.setDaid(field.getText());
                                }
                                if (name != null && name.equals("ajh")) {
                                    bdcGdxx.setAjh(field.getText());
                                }
                                if (name == null || !name.equals("mlh")) continue;
                                bdcGdxx.setMlh(field.getText());
                            }
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)archiveElement.attributeValue("msg"))) {
                        bdcGdxx.setGdxx(archiveElement.attributeValue("msg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bdcGdxx;
    }

    public boolean checkIsGd(String proid) {
        int count = 0;
        count = this.bdcGdxxMapper.countXmid(proid);
        return count <= 0;
    }
}

