/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdQlDyhRel;
import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.server.core.mapper.GdFwMapper;
import cn.gtmap.estateplat.server.core.mapper.GdTdMapper;
import cn.gtmap.estateplat.server.core.service.BdcGdDyhRelService;
import cn.gtmap.estateplat.server.core.service.GdBdcQlRelService;
import cn.gtmap.estateplat.server.core.service.GdFwService;
import cn.gtmap.estateplat.server.core.service.GdTdService;
import cn.gtmap.estateplat.server.core.service.impl.BdcXmRelServiceImpl;
import cn.gtmap.estateplat.server.core.service.impl.GdXmServiceImpl;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcGdDyhRelServiceImpl
implements BdcGdDyhRelService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdBdcQlRelService gdBdcQlRelService;
    @Autowired
    private BdcXmRelServiceImpl bdcXmRelService;
    @Autowired
    private GdXmServiceImpl gdXmService;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    GdFwMapper gdFwMapper;
    @Autowired
    GdTdMapper gdTdMapper;

    @Transactional(readOnly=true)
    public void addGdDyhRel(BdcGdDyhRel bdcGdDyhRel) {
        if (bdcGdDyhRel != null) {
            List bdcGdDyhRelList = this.getGdDyhRel("", bdcGdDyhRel.getGdid());
            if (CollectionUtils.isNotEmpty((Collection)bdcGdDyhRelList)) {
                for (BdcGdDyhRel bdcGdDyhRel1 : bdcGdDyhRelList) {
                    bdcGdDyhRel1.setBdcdyh(bdcGdDyhRel.getBdcdyh());
                    bdcGdDyhRel1.setGdid(bdcGdDyhRel.getGdid());
                    bdcGdDyhRel1.setTdid(bdcGdDyhRel.getTdid());
                    bdcGdDyhRel1.setDjid(bdcGdDyhRel.getDjid());
                    this.entityMapper.saveOrUpdate((Object)bdcGdDyhRel1, (Object)bdcGdDyhRel1.getRelid());
                }
            } else {
                bdcGdDyhRel.setRelid(UUIDGenerator.generate());
                this.entityMapper.saveOrUpdate((Object)bdcGdDyhRel, (Object)bdcGdDyhRel.getRelid());
            }
        }
    }

    public void addGdQlDyhRel(GdQlDyhRel gdQlDyhRel) {
        StringBuilder djids = new StringBuilder();
        StringBuilder tdqlids = new StringBuilder();
        StringBuilder bdcdyhs = new StringBuilder();
        String fwZslx = "";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("qlid", gdQlDyhRel.getQlid());
        List fwMapList = this.gdFwMapper.getGdFwQl(queryMap);
        if (CollectionUtils.isNotEmpty((Collection)fwMapList)) {
            String string = fwZslx = ((HashMap)fwMapList.get(0)).get("QLLX") == null ? "" : ((HashMap)fwMapList.get(0)).get("QLLX").toString();
        }
        if (gdQlDyhRel != null) {
            List gdQlDyhRelList = this.getGdQlDyhRel("", gdQlDyhRel.getQlid(), "");
            if (CollectionUtils.isNotEmpty((Collection)gdQlDyhRelList)) {
                for (GdQlDyhRel gdQlDyhRel1 : gdQlDyhRelList) {
                    gdQlDyhRel1.setBdcdyh(gdQlDyhRel.getBdcdyh());
                    gdQlDyhRel1.setQlid(gdQlDyhRel.getQlid());
                    if (StringUtils.isNotBlank((CharSequence)gdQlDyhRel.getTdqlid())) {
                        gdQlDyhRel1.setTdqlid(gdQlDyhRel.getTdqlid());
                    }
                    gdQlDyhRel1.setDjid(gdQlDyhRel.getDjid());
                    List gdBdcQlRelListtemp = this.gdBdcQlRelService.queryGdBdcQlListByQlid(gdQlDyhRel.getQlid());
                    if (CollectionUtils.isNotEmpty((Collection)gdBdcQlRelListtemp)) {
                        for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelListtemp) {
                            List gdDyhRelList = this.getGdDyhRelByGdId(gdBdcQlRel.getBdcid());
                            if (!CollectionUtils.isNotEmpty((Collection)gdDyhRelList)) continue;
                            String tempTdid = ((BdcGdDyhRel)gdDyhRelList.get(0)).getTdid();
                            String tempTdqlid = "";
                            if (StringUtils.isNotBlank((CharSequence)tempTdid)) {
                                String[] tempTdidArr;
                                for (String tdid : tempTdidArr = tempTdid.split(",")) {
                                    HashMap<String, String> tdQueryMap = new HashMap<String, String>();
                                    tdQueryMap.put("zslx", fwZslx);
                                    tdQueryMap.put("tdid", tdid);
                                    List gdtdMapList = this.gdTdMapper.getGdTdQl(tdQueryMap);
                                    if (!CollectionUtils.isNotEmpty((Collection)gdtdMapList)) continue;
                                    tempTdqlid = ((HashMap)gdtdMapList.get(0)).get("QLID") == null ? "" : ((HashMap)gdtdMapList.get(0)).get("QLID").toString() + ",";
                                }
                                if (StringUtils.isNotBlank((CharSequence)tempTdqlid) && tempTdqlid.endsWith(",")) {
                                    tempTdqlid = tempTdqlid.substring(0, tempTdqlid.length() - 1);
                                }
                            }
                            if (StringUtils.isBlank((CharSequence)djids)) {
                                djids = djids.append(((BdcGdDyhRel)gdDyhRelList.get(0)).getDjid());
                                bdcdyhs = djids.append(((BdcGdDyhRel)gdDyhRelList.get(0)).getBdcdyh());
                                tdqlids = tdqlids.append(tempTdqlid);
                                gdQlDyhRel1.setDjid(djids.toString());
                                if (StringUtils.isNotBlank((CharSequence)tempTdqlid)) {
                                    gdQlDyhRel1.setTdqlid(tdqlids.toString());
                                }
                                gdQlDyhRel1.setBdcdyh(bdcdyhs.toString());
                                continue;
                            }
                            if (StringUtils.equals((CharSequence)djids, (CharSequence)((BdcGdDyhRel)gdDyhRelList.get(0)).getDjid())) continue;
                            djids = djids.append(",").append(((BdcGdDyhRel)gdDyhRelList.get(0)).getDjid());
                            bdcdyhs = bdcdyhs.append(",").append(((BdcGdDyhRel)gdDyhRelList.get(0)).getBdcdyh());
                            if (StringUtils.isNotBlank((CharSequence)tempTdqlid)) {
                                tdqlids = tdqlids.append(",").append(tempTdqlid);
                            }
                            gdQlDyhRel1.setTdqlid(tdqlids.toString());
                            gdQlDyhRel1.setDjid(djids.toString());
                            gdQlDyhRel1.setBdcdyh(bdcdyhs.toString());
                        }
                    }
                    gdQlDyhRel1.setBdclx(gdQlDyhRel1.getBdclx());
                    if (gdQlDyhRel1.getTdqlid() == null) {
                        gdQlDyhRel1.setTdqlid("");
                    }
                    this.entityMapper.saveOrUpdate((Object)gdQlDyhRel1, (Object)gdQlDyhRel1.getRelid());
                }
            } else {
                gdQlDyhRel.setRelid(UUIDGenerator.generate());
                this.entityMapper.saveOrUpdate((Object)gdQlDyhRel, (Object)gdQlDyhRel.getRelid());
            }
        }
    }

    @Transactional(readOnly=true)
    public List<BdcGdDyhRel> getGdDyhRel(String dyh, String gdid) {
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gdid})) {
            criteria.andEqualTo("gdid", (Object)gdid);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dyh})) {
            criteria.andEqualTo("bdcdyh", (Object)dyh);
        }
        return this.entityMapper.selectByExample(BdcGdDyhRel.class, (Object)example);
    }

    @Transactional(readOnly=true)
    public List<BdcGdDyhRel> getGdDyhRelByDjid(String dyh, String djid, String gdid) {
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gdid})) {
            criteria.andEqualTo("gdid", (Object)gdid);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dyh})) {
            criteria.andEqualTo("bdcdyh", (Object)dyh);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{djid})) {
            criteria.andEqualTo("djid", (Object)djid);
        }
        return this.entityMapper.selectByExample(BdcGdDyhRel.class, (Object)example);
    }

    public List<GdQlDyhRel> getGdQlDyhRel(String dyh, String qlid, String tdqlid) {
        Example example = new Example(GdQlDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlid})) {
            criteria.andEqualTo("qlid", (Object)qlid);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tdqlid})) {
            criteria.andEqualTo("tdqlid", (Object)tdqlid);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dyh})) {
            criteria.andEqualTo("bdcdyh", (Object)dyh);
        }
        return this.entityMapper.selectByExample(GdQlDyhRel.class, (Object)example);
    }

    @Transactional(readOnly=true)
    public List<BdcGdDyhRel> getGdDyhRelByGdId(String gdid) {
        List bdcGdDyhRelList = null;
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)gdid)) {
            criteria.andEqualTo("gdid", (Object)gdid);
            bdcGdDyhRelList = this.entityMapper.selectByExample(BdcGdDyhRel.class, (Object)example);
        }
        return bdcGdDyhRelList;
    }

    public List<BdcGdDyhRel> getGdDyhRelList(String gdproids) {
        ArrayList<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if (StringUtils.isNotBlank((CharSequence)gdproids)) {
            String[] gdproidarr;
            for (String gdproid : gdproidarr = gdproids.split(",")) {
                List bdcGdDyhRelListTemp = this.getGdDyhRelByGdId(gdproid);
                if (!CollectionUtils.isNotEmpty((Collection)bdcGdDyhRelListTemp)) continue;
                bdcGdDyhRelList.addAll(bdcGdDyhRelListTemp);
            }
        }
        return bdcGdDyhRelList;
    }

    public String getGdDyhRelQlidsByDjids(String djid, String qlids) {
        String[] qlidArr;
        ArrayList gdQlDyhRelList = new ArrayList();
        for (String qlid : qlidArr = qlids.split(",")) {
            Example example = new Example(GdQlDyhRel.class);
            Example.Criteria criteria = example.createCriteria();
            if (!StringUtils.isNotBlank((CharSequence)qlid)) continue;
            criteria.andEqualTo("qlid", (Object)qlid);
            List gdQlDyhReltempList = this.entityMapper.selectByExample(GdQlDyhRel.class, (Object)example);
            if (!CollectionUtils.isNotEmpty((Collection)gdQlDyhReltempList)) continue;
            gdQlDyhRelList.addAll(gdQlDyhReltempList);
        }
        ArrayList<String> qlidlist = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(gdQlDyhRelList)) {
            for (GdQlDyhRel gdQlDyhRel : gdQlDyhRelList) {
                String[] djidArr;
                List<String> tempList;
                if (!StringUtils.isNotBlank((CharSequence)gdQlDyhRel.getDjid()) || !(tempList = Arrays.asList(djidArr = gdQlDyhRel.getDjid().split(","))).contains(djid)) continue;
                qlidlist.add(gdQlDyhRel.getQlid());
            }
        }
        StringBuilder returnqlids = new StringBuilder();
        if (CollectionUtils.isNotEmpty(qlidlist)) {
            for (String qlid : qlidlist) {
                if (StringUtils.isBlank((CharSequence)returnqlids)) {
                    returnqlids = returnqlids.append(qlid);
                    continue;
                }
                returnqlids = returnqlids.append(",").append(qlid);
            }
        }
        return returnqlids.toString();
    }

    public List<BdcGdDyhRel> getTdDyhRelBytdids(String tdids) {
        ArrayList<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if (tdids != null && tdids.length() > 0) {
            String[] tdidTemp;
            for (String tdid : tdidTemp = tdids.split(",")) {
                List bdcGdDyhRel = this.getGdDyhRelByGdId(tdid);
                if (!CollectionUtils.isNotEmpty((Collection)bdcGdDyhRel)) continue;
                ((BdcGdDyhRel)bdcGdDyhRel.get(0)).setGdid(tdid);
                bdcGdDyhRelList.add((BdcGdDyhRel)bdcGdDyhRel.get(0));
            }
        }
        return bdcGdDyhRelList;
    }

    @Transactional(readOnly=true)
    public List<BdcGdDyhRel> getGdDyhRel(String tdid) {
        List bdcGdDyhRelList = null;
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)tdid)) {
            criteria.andEqualTo("tdid", (Object)tdid);
            bdcGdDyhRelList = this.entityMapper.selectByExample(BdcGdDyhRel.class, (Object)example);
        }
        return bdcGdDyhRelList;
    }

    public void updateGdDyhRelByProidAndBdcdyh(String proid, String bdcdyh) {
        List bdcXmRelList;
        if (StringUtils.isNotBlank((CharSequence)proid) && CollectionUtils.isNotEmpty((Collection)(bdcXmRelList = this.bdcXmRelService.queryBdcXmRelByProid(proid)))) {
            for (BdcXmRel bdcXmRel : bdcXmRelList) {
                if (!StringUtils.isNotBlank((CharSequence)bdcXmRel.getYproid())) continue;
                String bdcid = "";
                List bdcidList = this.gdXmService.getGdBdcidByProid(bdcXmRel.getYproid());
                if (CollectionUtils.isNotEmpty((Collection)bdcidList)) {
                    bdcid = (String)bdcidList.get(0);
                }
                List gdDyhRelList = null;
                if (StringUtils.isNotBlank((CharSequence)bdcid)) {
                    gdDyhRelList = this.getGdDyhRel(null, bdcid);
                }
                if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
                    for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                        gdDyhRel.setBdcdyh(bdcdyh);
                        this.entityMapper.saveOrUpdate((Object)gdDyhRel, (Object)gdDyhRel.getRelid());
                    }
                    continue;
                }
                BdcGdDyhRel bdcGdDyhRel = new BdcGdDyhRel();
                bdcGdDyhRel.setRelid(UUIDGenerator.generate());
                bdcGdDyhRel.setGdid(bdcid);
                if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
                    bdcGdDyhRel.setBdcdyh(bdcdyh);
                }
                this.entityMapper.saveOrUpdate((Object)bdcGdDyhRel, (Object)bdcGdDyhRel.getRelid());
            }
        }
    }

    public List<BdcGdDyhRel> getGdDyhRelByGdproid(String gdproid) {
        ArrayList<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if (StringUtils.isNotBlank((CharSequence)gdproid)) {
            List gdDyhRelList;
            List gdFwList = this.gdFwService.getGdFwByProid(gdproid, "");
            List gdTdList = this.gdTdService.getGdTdListByProid(gdproid, "");
            if (CollectionUtils.isNotEmpty((Collection)gdFwList)) {
                for (GdFw gdFw : gdFwList) {
                    gdDyhRelList = this.getGdDyhRel("", gdFw.getFwid());
                    if (!CollectionUtils.isNotEmpty((Collection)gdDyhRelList)) continue;
                    bdcGdDyhRelList.addAll(gdDyhRelList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)gdTdList)) {
                for (GdTd gdTd : gdTdList) {
                    gdDyhRelList = this.getGdDyhRel("", gdTd.getTdid());
                    if (!CollectionUtils.isNotEmpty((Collection)gdDyhRelList)) continue;
                    bdcGdDyhRelList.addAll(gdDyhRelList);
                }
            }
        }
        return bdcGdDyhRelList;
    }

    public void deleteGdPpgx(String qlid, String bdclx) {
        block5: {
            block6: {
                if (!StringUtils.isNotBlank((CharSequence)qlid)) break block5;
                Example example = new Example(GdQlDyhRel.class);
                Example.Criteria criteria = example.createCriteria();
                if (StringUtils.isNotBlank((CharSequence)bdclx)) {
                    criteria.andEqualTo("qlid", (Object)qlid).andEqualTo("bdclx", (Object)bdclx);
                }
                if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                    this.entityMapper.deleteByExample(GdQlDyhRel.class, (Object)example);
                }
                if (!StringUtils.equals((CharSequence)bdclx, (CharSequence)"TD")) break block6;
                List gdTdList = this.gdTdService.getGdTdListByQlid(qlid);
                if (!CollectionUtils.isNotEmpty((Collection)gdTdList)) break block5;
                for (GdTd gdTd : gdTdList) {
                    if (!StringUtils.isNotBlank((CharSequence)gdTd.getTdid())) continue;
                    Example tdExample = new Example(BdcGdDyhRel.class);
                    Example.Criteria tdCriteria = tdExample.createCriteria();
                    tdCriteria.andEqualTo("gdid", (Object)gdTd.getTdid());
                    this.entityMapper.deleteByExample(BdcGdDyhRel.class, (Object)tdExample);
                }
                break block5;
            }
            List gdFwList = this.gdFwService.getGdFwByQlid(qlid);
            if (CollectionUtils.isNotEmpty((Collection)gdFwList)) {
                for (GdFw gdFw : gdFwList) {
                    if (!StringUtils.isNotBlank((CharSequence)gdFw.getFwid())) continue;
                    Example fwExample = new Example(BdcGdDyhRel.class);
                    Example.Criteria fwCriteria = fwExample.createCriteria();
                    fwCriteria.andEqualTo("gdid", (Object)gdFw.getFwid());
                    this.entityMapper.deleteByExample(BdcGdDyhRel.class, (Object)fwExample);
                }
            }
        }
    }
}

