/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcDyaq;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.server.core.mapper.BdcDyaqMapper;
import cn.gtmap.estateplat.server.core.mapper.BdcXmMapper;
import cn.gtmap.estateplat.server.core.service.BdcDyaqService;
import cn.gtmap.estateplat.server.core.service.BdcSpxxService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcDyaqServiceImpl
implements BdcDyaqService {
    @Autowired
    BdcDyaqMapper bdcDyaqMapper;
    @Autowired
    private BdcXmMapper bdcXmMapper;
    @Autowired
    private QllxService qllxService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcSpxxService bdcSpxxService;

    @Transactional
    public void updateBdcDyaqForZxdj(BdcDyaq bdcDyaq) {
        if (bdcDyaq != null && StringUtils.isNotBlank((CharSequence)bdcDyaq.getQlid())) {
            this.bdcDyaqMapper.updateBdcDyaqForZxdj(bdcDyaq);
        }
    }

    public void updateBdcDyaqZxDbr(String proid, String userName) {
        BdcXm bdcXm = this.bdcXmMapper.getBdcXmByProid(proid);
        QllxVo qllxVo = this.qllxService.makeSureQllx(bdcXm);
        QllxVo qllxVotemp = null;
        if (qllxVo != null) {
            qllxVotemp = this.qllxService.queryQllxVo(qllxVo, proid);
        } else {
            qllxVo = this.qllxService.getQllxVoByProid(proid);
        }
        if (qllxVotemp != null) {
            if (qllxVotemp instanceof BdcDyaq) {
                BdcDyaq bdcDyaq = (BdcDyaq)qllxVotemp;
                bdcDyaq.setZxdbr(userName);
                this.updateBdcDyaqForZxdj(bdcDyaq);
            }
        } else if (qllxVo instanceof BdcDyaq) {
            BdcDyaq bdcDyaq = (BdcDyaq)qllxVo;
            bdcDyaq.setZxdbr(userName);
            this.updateBdcDyaqForZxdj(bdcDyaq);
        }
    }

    @Transactional(readOnly=true)
    public List<BdcDyaq> queryBdcDyaq(Map map) {
        return this.bdcDyaqMapper.queryBdcDyaq(map);
    }

    public List<BdcDyaq> queryYdyaqByProid(String proid, Integer qszt) {
        return this.bdcDyaqMapper.queryYdyaqByProid(proid, qszt);
    }

    public List<Map> queryBdcDyaqByPage(Map map) {
        return this.bdcDyaqMapper.queryBdcDyaqByPage(map);
    }

    public BdcDyaq queryBdcDyaqByFwid(HashMap map) {
        return this.bdcDyaqMapper.queryBdcDyaqByFwid(map);
    }

    public String saveDyaForMul(List<BdcXm> bdcXmList, String proid) {
        Example example = new Example(BdcDyaq.class);
        ArrayList<BdcDyaq> bdcDyaqTempList = new ArrayList<BdcDyaq>();
        example.createCriteria().andEqualTo("proid", (Object)proid);
        List bdcDyaqList = this.entityMapper.selectByExampleNotNull(example);
        BdcDyaq bdcDyaq = (BdcDyaq)bdcDyaqList.get(0);
        for (BdcXm bdcXm : bdcXmList) {
            if (!StringUtils.isNotBlank((CharSequence)bdcXm.getProid()) || StringUtils.equals((CharSequence)bdcXm.getProid(), (CharSequence)proid)) continue;
            example.clear();
            example.createCriteria().andEqualTo("proid", (Object)bdcXm.getProid());
            List bdcDyaqs = this.entityMapper.selectByExampleNotNull(example);
            BdcDyaq bdcDyaqTemp = (BdcDyaq)bdcDyaqs.get(0);
            bdcDyaqTemp.setZjgcdyfw(bdcDyaq.getZjgcdyfw() == null ? "" : bdcDyaq.getZjgcdyfw());
            bdcDyaqTemp.setZgzqqdse(bdcDyaq.getZgzqqdse());
            bdcDyaqTemp.setZwlxksqx(bdcDyaq.getZwlxksqx());
            bdcDyaqTemp.setZwlxjsqx(bdcDyaq.getZwlxjsqx());
            bdcDyaqTemp.setBdbzzqse(bdcDyaq.getBdbzzqse());
            bdcDyaqTempList.add(bdcDyaqTemp);
        }
        this.entityMapper.batchSaveSelective(bdcDyaqTempList);
        return "success";
    }

    public String saveDyaXxForEach(List<BdcXm> bdcXmList, String proid, String wiid, double dyjg, double bdcjg) {
        Example example = new Example(BdcDyaq.class);
        Example spxxExample = new Example(BdcSpxx.class);
        ArrayList<BdcDyaq> bdcDyaqTempList = new ArrayList<BdcDyaq>();
        example.createCriteria().andEqualTo("proid", (Object)proid);
        List bdcDyaqList = this.entityMapper.selectByExampleNotNull(example);
        BdcDyaq bdcDyaq = (BdcDyaq)bdcDyaqList.get(0);
        double zjzmj = this.bdcSpxxService.getAllBdcdyhMjByWiid(wiid);
        for (BdcXm bdcXm : bdcXmList) {
            example.clear();
            example.createCriteria().andEqualTo("proid", (Object)bdcXm.getProid());
            List bdcDyaqs = this.entityMapper.selectByExampleNotNull(example);
            spxxExample.clear();
            spxxExample.createCriteria().andEqualTo("proid", (Object)bdcXm.getProid());
            List bdcSpxxes = this.entityMapper.selectByExampleNotNull(spxxExample);
            double mj = ((BdcSpxx)bdcSpxxes.get(0)).getMj();
            double bdbzqse = mj * dyjg;
            double zgzqqdse = mj * bdcjg;
            BdcDyaq bdcDyaqTemp = (BdcDyaq)bdcDyaqs.get(0);
            bdcDyaqTemp.setZjgcdyfw(bdcDyaq.getZjgcdyfw() == null ? "" : bdcDyaq.getZjgcdyfw());
            bdcDyaqTemp.setZgzqqdse(bdcDyaq.getZgzqqdse());
            bdcDyaqTemp.setZwlxksqx(bdcDyaq.getZwlxksqx());
            bdcDyaqTemp.setZwlxjsqx(bdcDyaq.getZwlxjsqx());
            bdcDyaqTemp.setFwdyjg(Double.valueOf(dyjg));
            bdcDyaqTemp.setBdbzzqse(Double.valueOf(bdbzqse));
            bdcDyaqTemp.setZgzqqdse(Double.valueOf(zgzqqdse));
            bdcDyaqTempList.add(bdcDyaqTemp);
            this.entityMapper.saveOrUpdate((Object)bdcDyaqTemp, (Object)bdcDyaqTemp.getQlid());
        }
        return "success";
    }
}

