/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdCf;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.mapper.BdcCfMapper;
import cn.gtmap.estateplat.server.core.service.BdcCfService;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcSpxxService;
import cn.gtmap.estateplat.server.core.service.BdcXmRelService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.GdCfService;
import cn.gtmap.estateplat.server.core.service.GdFwService;
import cn.gtmap.estateplat.server.core.service.GdTdService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcCfServiceImpl
implements BdcCfService {
    @Autowired
    BdcCfMapper bdcCfMapper;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcSpxxService bdcSpxxService;
    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdTdService gdTdService;
    @Autowired
    GdCfService gdCfService;
    protected final Logger logger = LoggerFactory.getLogger(BdcCfService.class);

    @Transactional
    public void updateBdcCfForJfxx(BdcCf bdcCf) {
        if (bdcCf != null && StringUtils.isNotBlank((CharSequence)bdcCf.getQlid())) {
            this.bdcCfMapper.updateBdcCfForJfxx(bdcCf);
        }
    }

    @Transactional(readOnly=true)
    public List<BdcCf> queryLhcfByBdcdyh(Map map) {
        return this.bdcCfMapper.queryLhcfByBdcdyh(map);
    }

    @Transactional(readOnly=true)
    public BdcCf selectCfByProid(String proid) {
        return this.bdcCfMapper.selectCfByProid(proid);
    }

    @Transactional(readOnly=true)
    public List<BdcCf> queryJfLhcfByBdcdyh(Map map) {
        return this.bdcCfMapper.queryJfLhcfByBdcdyh(map);
    }

    public List<BdcCf> queryCfByBdcdyid(String bdcdyid) {
        return this.bdcCfMapper.getCfByBdcdyid(bdcdyid);
    }

    @Transactional(readOnly=true)
    public List<BdcCf> getXfByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.getXfByBdcdyh(bdcdyh);
    }

    @Transactional(readOnly=true)
    public List<BdcCf> getLhcfByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.getLhcfByBdcdyh(bdcdyh);
    }

    @Transactional
    public void changLhsx(String proid) {
        List bdcCfLists;
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        BdcBdcdy bdcBdcdy = this.bdcdyService.queryBdcdyById(bdcXm.getBdcdyid());
        if (bdcBdcdy != null && CollectionUtils.isNotEmpty((Collection)(bdcCfLists = this.getLhcfByBdcdyh(bdcBdcdy.getBdcdyh())))) {
            for (BdcCf cf : bdcCfLists) {
                if (cf.getLhsx() == null) continue;
                if (cf.getQszt() != null && cf.getQszt() == Constants.QLLX_QSZT_HR) {
                    cf.setLhsx(null);
                } else {
                    cf.setLhsx(Integer.valueOf(cf.getLhsx() - 1));
                }
                this.entityMapper.updateByPrimaryKeyNull((Object)cf);
            }
        }
    }

    @Transactional
    public void lhChangeCf(BdcXm bdcXm, String yProid, int qszt) {
        if (bdcXm != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            BdcCf jf = this.selectCfByProid(yProid);
            if (jf != null && StringUtils.equals((CharSequence)jf.getCflx(), (CharSequence)"1")) {
                BdcBdcdy bdcBdcdy = this.bdcdyService.queryBdcdyById(bdcXm.getBdcdyid());
                if (bdcBdcdy != null) {
                    map.put("bdcdyh", bdcBdcdy.getBdcdyh());
                }
                map.put("yproid", bdcXm.getProid());
                List lhcfList = this.queryJfLhcfByBdcdyh(map);
                if (CollectionUtils.isNotEmpty((Collection)lhcfList)) {
                    BdcCf lhcf;
                    BdcCf yBdcCf = lhcf = (BdcCf)lhcfList.get(0);
                    yBdcCf.setQszt(Integer.valueOf(qszt));
                    yBdcCf.setLhsx(null);
                    this.entityMapper.updateByPrimaryKeyNull((Object)yBdcCf);
                    BdcXm bdcxm = this.bdcXmService.getBdcXmByProid(lhcf.getProid());
                    List bdcXmRelList = this.bdcXmRelService.queryBdcXmRelByProid(lhcf.getProid());
                    List bdcBdcdyList = this.bdcdyService.queryBdcBdcdy(bdcXm.getWiid());
                    List bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(lhcf.getProid());
                    List bdcYwrList = this.bdcQlrService.queryBdcYwrByProid(lhcf.getProid());
                    if (null != bdcxm) {
                        if (CollectionUtils.isNotEmpty((Collection)bdcBdcdyList) && CollectionUtils.isNotEmpty((Collection)bdcXmRelList)) {
                            bdcxm.setBdcdyid(UUIDGenerator.generate18());
                            bdcxm.setProid(UUIDGenerator.generate18());
                            bdcxm.setBh(CalendarUtil.getTimeMs());
                            bdcxm.setCjr(jf.getJfdbr());
                            bdcxm.setCjsj(jf.getJfsj());
                            bdcxm.setCjsj(jf.getJfsj());
                            bdcxm.setSqlx("801");
                            this.entityMapper.saveOrUpdate((Object)bdcxm, (Object)bdcxm.getProid());
                            BdcXmRel bdcXmRel = (BdcXmRel)bdcXmRelList.get(0);
                            bdcXmRel.setRelid(UUIDGenerator.generate18());
                            bdcXmRel.setProid(bdcxm.getProid());
                            this.entityMapper.saveOrUpdate((Object)bdcXmRel, (Object)bdcXmRel.getRelid());
                            bdcBdcdy = (BdcBdcdy)bdcBdcdyList.get(0);
                            bdcBdcdy.setBdcdyid(bdcxm.getBdcdyid());
                            this.entityMapper.saveOrUpdate((Object)bdcBdcdy, (Object)bdcBdcdy.getBdcdyid());
                            if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
                                for (BdcQlr bdcQlr : bdcQlrList) {
                                    bdcQlr.setProid(bdcxm.getProid());
                                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                                    this.entityMapper.saveOrUpdate((Object)bdcQlr, (Object)bdcQlr.getQlrid());
                                }
                            }
                            if (CollectionUtils.isNotEmpty((Collection)bdcYwrList)) {
                                for (BdcQlr bdcQlr : bdcYwrList) {
                                    bdcQlr.setProid(bdcxm.getProid());
                                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                                    this.entityMapper.saveOrUpdate((Object)bdcQlr, (Object)bdcQlr.getQlrid());
                                }
                            }
                        }
                        Date jfdjsj = jf.getJfdjsj();
                        if (lhcf.getCfksqx() != null && lhcf.getCfjsqx() != null) {
                            Long days = CommonUtil.getDaySub((Date)lhcf.getCfksqx(), (Date)lhcf.getCfjsqx());
                            int daysI = new Long(days).intValue() - 1;
                            if (jfdjsj != null) {
                                String jsqx = CalendarUtil.addDay((String)CalendarUtil.formatDateTime((Date)jfdjsj), (int)daysI);
                                lhcf.setCfjsqx(CalendarUtil.formatDate((String)jsqx));
                            } else {
                                Date jsqx = CommonUtil.plusDay((Date)new Date(), (int)daysI);
                                lhcf.setCfjsqx(jsqx);
                            }
                        }
                        BdcCf cf = lhcf;
                        cf.setProid(bdcxm.getProid());
                        if (null != bdcBdcdy) {
                            cf.setBdcdyid(bdcBdcdy.getBdcdyid());
                        }
                        cf.setQlid(UUIDGenerator.generate18());
                        if (jfdjsj != null) {
                            cf.setCfksqx(jfdjsj);
                        } else {
                            cf.setCfksqx(new Date());
                        }
                        cf.setCflx("1");
                        cf.setJfywh("");
                        cf.setLhcfqx("");
                        cf.setLhsx(null);
                        cf.setYwh(CalendarUtil.getTimeMs());
                        cf.setDjsj(jfdjsj);
                        cf.setDbr(jf.getJfdbr());
                        if (jf.getJfdjsj() != null) {
                            cf.setFj(CalendarUtil.formateToStrChinaYMDDate((Date)jfdjsj) + "\u8f6e\u5019\u67e5\u5c01\u8f6c\u67e5\u5c01");
                        } else {
                            cf.setFj(CalendarUtil.getCurChinaYMDStrDate() + "\u8f6e\u5019\u67e5\u5c01\u8f6c\u67e5\u5c01");
                        }
                        cf.setQszt(Constants.QLLX_QSZT_XS);
                        this.entityMapper.saveOrUpdate((Object)cf, (Object)cf.getQlid());
                        this.changLhsx(bdcxm.getProid());
                    }
                }
            }
        }
    }

    @Transactional(readOnly=true)
    public List<BdcCf> getYcfByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.getYcfByBdcdyh(bdcdyh);
    }

    @Transactional
    public void ycfChangeCf(BdcXm xbdcXm, BdcCf ybdcCf) {
        if (xbdcXm != null && StringUtils.isNotBlank((CharSequence)xbdcXm.getProid())) {
            BdcSpxx ybdcSpxx = null;
            String fj = "";
            if (ybdcCf != null && StringUtils.isNotBlank((CharSequence)ybdcCf.getProid())) {
                ybdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(ybdcCf.getProid());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("proid", xbdcXm.getProid());
            List ybdcQlrList = null;
            ybdcQlrList = this.bdcQlrService.queryBdcQlrList(hashMap);
            if (ybdcCf != null) {
                ybdcCf.setQszt(Constants.QLLX_QSZT_HR);
                String sj = CalendarUtil.formatDateToString((Date)new Date());
                fj = ybdcCf.getFj();
                if (StringUtils.isBlank((CharSequence)fj)) {
                    fj = "";
                }
                ybdcCf.setFj(fj + sj + "\u9884\u67e5\u5c01\u8f6c\u67e5\u5c01");
                this.entityMapper.saveOrUpdate((Object)ybdcCf, (Object)ybdcCf.getQlid());
            }
            BdcXmRel bdcXmRel = new BdcXmRel();
            bdcXmRel.setYproid(xbdcXm.getProid());
            BdcXm bdcXm = xbdcXm;
            bdcXm.setProid(UUIDGenerator.generate18());
            bdcXm.setSqlx("801");
            bdcXm.setQllx("21");
            bdcXm.setDjlx("800");
            bdcXm.setXmzt("1");
            bdcXm.setBh(CalendarUtil.getTimeMs());
            this.entityMapper.saveOrUpdate((Object)bdcXm, (Object)bdcXm.getProid());
            bdcXmRel.setRelid(UUIDGenerator.generate18());
            bdcXmRel.setProid(bdcXm.getProid());
            this.entityMapper.saveOrUpdate((Object)bdcXmRel, (Object)bdcXmRel.getRelid());
            BdcSpxx bdcSpxx = ybdcSpxx;
            if (null != bdcSpxx) {
                bdcSpxx.setProid(xbdcXm.getProid());
                bdcSpxx.setSpxxid(UUIDGenerator.generate());
                this.entityMapper.saveOrUpdate((Object)bdcSpxx, (Object)bdcSpxx.getSpxxid());
            }
            List bdcQlrList = null;
            bdcQlrList = ybdcQlrList;
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                    bdcQlr.setProid(bdcXm.getProid());
                    this.entityMapper.saveOrUpdate((Object)bdcQlr, (Object)bdcQlr.getQlrid());
                }
            }
            if (ybdcCf != null) {
                BdcCf bdcCf = ybdcCf;
                bdcCf.setFj(fj);
                bdcCf.setQlid(UUIDGenerator.generate18());
                bdcCf.setProid(bdcXm.getProid());
                bdcCf.setDjsj(new Date());
                bdcCf.setCflx("1");
                bdcCf.setQszt(Constants.QLLX_QSZT_XS);
                this.entityMapper.saveOrUpdate((Object)bdcCf, (Object)bdcCf.getQlid());
            }
        }
    }

    @Transactional(readOnly=true)
    public List<BdcCf> queryYcfByBdcdyh(String bdcdyh) {
        return this.bdcCfMapper.queryYcfByBdcdyh(bdcdyh);
    }

    @Transactional(readOnly=true)
    public List<String> getBdcCflxMc() {
        return this.bdcCfMapper.getBdcCflxMc();
    }

    @Transactional(readOnly=true)
    public List<Map> queryBdcCfByPage(Map map) {
        return this.bdcCfMapper.queryBdcCfByPage(map);
    }

    @Transactional(readOnly=true)
    public List<Map> queryBdcGdCfByPage(Map map) {
        return this.bdcCfMapper.queryBdcGdCf(map);
    }

    public String getBdcCflxMcByDm(String cflx) {
        return this.bdcCfMapper.getBdcCflxMcByDm(cflx);
    }

    @Transactional(readOnly=false)
    public void updateLhsxToNull(String qlid) {
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            this.bdcCfMapper.updateLhsxToNull(qlid);
        }
    }

    @Transactional
    public void turnLhcfToCf(BdcCf bdcCf, String bdcdyid) {
        if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
            List bdcCfListTemp = this.getBdcCfList(bdcdyid, "1", Constants.QLLX_QSZT_XS, null);
            List bdcLhCfList = this.getBdcCfList(bdcdyid, "2", Constants.QLLX_QSZT_XS, "to_number(lhsx)");
            if (CollectionUtils.isEmpty((Collection)bdcCfListTemp) && CollectionUtils.isNotEmpty((Collection)bdcLhCfList)) {
                int i = 0;
                for (BdcCf bdcCfTemp : bdcLhCfList) {
                    if (i == 0) {
                        this.saveLhcfToCf(bdcCfTemp, bdcCf);
                    } else {
                        this.changeLhSx(bdcCfTemp);
                    }
                    ++i;
                }
            }
        }
    }

    public List<BdcCf> getBdcCfList(String bdcdyid, String cflx, Integer qszt, String orderByClause) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bdcdyid", bdcdyid);
        map.put("cflx", cflx);
        map.put("qszt", qszt);
        return this.andEqualQueryCf(map, orderByClause);
    }

    private void changeLhSx(BdcCf bdcCfTemp) {
        Integer lhsx = bdcCfTemp.getLhsx() - 1;
        bdcCfTemp.setLhsx(lhsx);
        this.entityMapper.updateByPrimaryKeySelective((Object)bdcCfTemp);
    }

    private void saveLhcfToCf(BdcCf bdcLhCf, BdcCf bdcCf) {
        BdcCf bdcYlhcf = this.cloneBdcCf(bdcLhCf);
        BdcXm ybdcXm = this.bdcXmService.getBdcXmByProid(bdcLhCf.getProid());
        String proid = UUIDGenerator.generate();
        String ywh = CommonUtil.getCurrentTimeMillisId();
        if (ybdcXm != null) {
            this.saveBdcSpxx(proid, ybdcXm);
            this.saveBdcQlr(proid, ybdcXm);
            this.saveBdcXm(proid, ywh, ybdcXm);
        }
        BdcCf newCf = this.saveNewCf(proid, ywh, bdcLhCf, bdcCf);
        bdcYlhcf.setQszt(Constants.QLLX_QSZT_HR);
        bdcYlhcf.setJfdjsj(newCf.getDjsj());
        bdcYlhcf.setJfdbr(newCf.getDbr());
        bdcYlhcf.setJfywh(newCf.getYwh());
        this.entityMapper.saveOrUpdate((Object)bdcYlhcf, (Object)bdcYlhcf.getQlid());
    }

    private BdcCf saveNewCf(String proid, String ywh, BdcCf bdcLhCf, BdcCf bdcCf) {
        Date cfksqx = bdcLhCf.getCfksqx();
        Date cfjsqx = bdcLhCf.getCfjsqx();
        BdcCf newCf = bdcLhCf;
        if (cfksqx != null && cfjsqx != null) {
            Long days = CommonUtil.getDaySub((Date)cfksqx, (Date)cfjsqx);
            int daysI = new Long(days).intValue() - 1;
            if (bdcCf != null && bdcCf.getJfdjsj() != null) {
                String jsqx = CalendarUtil.addDay((String)CalendarUtil.formatDateTime((Date)bdcCf.getJfdjsj()), (int)daysI);
                newCf.setCfjsqx(CalendarUtil.formatDate((String)jsqx));
            } else {
                Date jsqx = CommonUtil.plusDay((Date)new Date(), (int)daysI);
                newCf.setCfjsqx(jsqx);
            }
        }
        newCf.setYwh(ywh);
        newCf.setProid(proid);
        newCf.setQlid(UUIDGenerator.generate());
        if (bdcCf != null) {
            newCf.setCfksqx(bdcCf.getJfdjsj());
            newCf.setDjsj(bdcCf.getJfdjsj());
            newCf.setDbr(bdcCf.getJfdbr());
        }
        newCf.setCflx("1");
        newCf.setQszt(Constants.QLLX_QSZT_XS);
        newCf.setLhsx(null);
        newCf.setFj(CalendarUtil.getCurChinaYMDStrDate() + "\u8f6e\u5019\u67e5\u5c01\u8f6c\u67e5\u5c01");
        this.entityMapper.insertSelective((Object)newCf);
        return newCf;
    }

    private void saveBdcQlr(String proid, BdcXm ybdcXm) {
        List bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(ybdcXm.getProid());
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
            for (int j = 0; j < bdcQlrList.size(); ++j) {
                BdcQlr bdcQlr = (BdcQlr)bdcQlrList.get(j);
                bdcQlr.setProid(proid);
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                this.entityMapper.insertSelective((Object)bdcQlr);
            }
        }
    }

    private void saveBdcSpxx(String proid, BdcXm ybdcXm) {
        BdcSpxx bdcSpxx = this.bdcSpxxService.queryBdcSpxxByProid(ybdcXm.getProid());
        if (bdcSpxx != null) {
            BdcSpxx newBdcSpxx = bdcSpxx;
            newBdcSpxx.setSpxxid(UUIDGenerator.generate18());
            newBdcSpxx.setProid(proid);
            this.entityMapper.saveOrUpdate((Object)newBdcSpxx, (Object)newBdcSpxx.getSpxxid());
        }
    }

    private void saveBdcXm(String proid, String ywh, BdcXm ybdcXm) {
        String yYwh = ybdcXm.getYbh();
        BdcXm newXm = ybdcXm;
        newXm.setProid(proid);
        newXm.setBh(ywh);
        newXm.setDjzx("1202");
        newXm.setYbh(yYwh);
        this.entityMapper.saveOrUpdate((Object)newXm, (Object)newXm.getProid());
    }

    private BdcCf cloneBdcCf(BdcCf bdcCf) {
        BdcCf cloneBdcCf = new BdcCf();
        try {
            cloneBdcCf = (BdcCf)BeanUtils.cloneBean((Object)bdcCf);
        }
        catch (IllegalAccessException e) {
            this.logger.info("BdcCf\u5bf9\u8c61\u514b\u9686\u65f6\u975e\u6cd5\u8bbf\u95ee\u5f02\u5e38\uff01");
        }
        catch (InstantiationException e) {
            this.logger.info("BdcCf\u5bf9\u8c61\u514b\u9686\u65f6\u5b9e\u4f8b\u5316\u5f02\u5e38\uff01");
        }
        catch (InvocationTargetException e) {
            this.logger.info("BdcCf\u5bf9\u8c61\u514b\u9686\u65f6\u65b9\u6cd5\u5f02\u5e38\u7684\u53d7\u67e5\u5f02\u5e38\uff01");
        }
        catch (NoSuchMethodException e) {
            this.logger.info("BdcCf\u5bf9\u8c61\u514b\u9686\u7f3a\u5c11\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        return cloneBdcCf;
    }

    public List<BdcCf> andEqualQueryCf(Map map, String orderByClause) {
        List list = null;
        if (map != null) {
            Example qllxTemp = new Example(BdcCf.class);
            if (StringUtils.isNotBlank((CharSequence)orderByClause)) {
                qllxTemp.setOrderByClause(orderByClause);
            }
            if (CollectionUtils.isNotEmpty(map.entrySet())) {
                Iterator iter = map.entrySet().iterator();
                Example.Criteria criteria = qllxTemp.createCriteria();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (val == null) continue;
                    criteria.andEqualTo(key.toString(), val);
                }
            }
            list = this.entityMapper.selectByExample(BdcCf.class, (Object)qllxTemp);
        }
        return list;
    }

    public List<BdcCf> getCfByBdcdyid(String bdcdyid) {
        ArrayList<BdcCf> bdcCfList = new ArrayList<BdcCf>();
        if (StringUtils.isNotBlank((CharSequence)bdcdyid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bdcdyid", bdcdyid);
            List cfList = this.andEqualQueryCf(map, "");
            if (CollectionUtils.isNotEmpty((Collection)cfList)) {
                for (BdcCf bdcCf : cfList) {
                    if (bdcCf.getQszt() != null && bdcCf.getQszt() != 0 && bdcCf.getQszt() != 1) continue;
                    bdcCfList.add(bdcCf);
                }
            }
        }
        return bdcCfList;
    }

    public List<BdcCf> getXsCfByBdcdyh(String bdcdyh) {
        List bdcCfList = null;
        if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("bdcdyh", bdcdyh);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS);
            hashMap.put("cflx", "1");
            bdcCfList = this.bdcCfMapper.getCfByMap(hashMap);
        }
        return bdcCfList;
    }

    public String getCfDjzx(Project project, BdcXm yBdcXm) {
        String djzx = "";
        List bdcCfList = null;
        List gdCfList = null;
        djzx = "1202";
        String sjppType = AppConfig.getProperty((String)"sjpp.type");
        if (StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"803") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"807") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"804") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"809") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"811") || StringUtils.equals((CharSequence)project.getSqlx(), (CharSequence)"813")) {
            djzx = "";
        } else if (StringUtils.equals((CharSequence)project.getXmly(), (CharSequence)"1")) {
            if (StringUtils.isNotBlank((CharSequence)project.getDjId())) {
                djzx = "1201";
            } else if (yBdcXm != null) {
                if (StringUtils.equals((CharSequence)yBdcXm.getQllx(), (CharSequence)"21")) {
                    djzx = "1204";
                } else if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh()) && CollectionUtils.isNotEmpty((Collection)(bdcCfList = this.getXsCfByBdcdyh(project.getBdcdyh())))) {
                    djzx = "1203";
                }
            }
        } else if (StringUtils.equals((CharSequence)sjppType, (CharSequence)"cg")) {
            GdFwsyq gdFwsyq = null;
            GdTdsyq gdTdsyq = null;
            if (StringUtils.isNotBlank((CharSequence)project.getYqlid())) {
                if (StringUtils.equals((CharSequence)project.getBdclx(), (CharSequence)"TDFW")) {
                    gdFwsyq = this.gdFwService.getGdFwsyqByQlid(project.getYqlid());
                } else {
                    gdTdsyq = this.gdTdService.getGdTdsyqByQlid(project.getYqlid());
                }
                if (gdFwsyq != null || gdTdsyq != null) {
                    gdCfList = this.gdCfService.getGdCfListByQlid(project.getYqlid(), Integer.valueOf(0));
                    if (StringUtils.isNotBlank((CharSequence)project.getBdcdyh())) {
                        bdcCfList = this.getXsCfByBdcdyh(project.getBdcdyh());
                    }
                    djzx = CollectionUtils.isNotEmpty((Collection)bdcCfList) || CollectionUtils.isNotEmpty((Collection)gdCfList) ? "1203" : "1202";
                } else {
                    djzx = "1204";
                }
            }
        } else {
            GdCf gdCf = this.gdFwService.getGdCfByCfid(project.getYqlid(), Integer.valueOf(0));
            if (gdCf != null) {
                if (StringUtils.isBlank((CharSequence)gdCf.getCflx()) || StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u67e5\u5c01")) {
                    djzx = "1202";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u8f6e\u5019\u67e5\u5c01")) {
                    djzx = "1203";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u7eed\u5c01")) {
                    djzx = "1204";
                } else if (StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u9884\u67e5\u5c01") || StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u8f6e\u5019\u9884\u67e5\u5c01")) {
                    djzx = "1201";
                }
            }
        }
        return djzx;
    }

    public List<Map<String, String>> getDjzxByBdcdyh(String bdcdyh) {
        List bdcMap = null;
        if (StringUtils.isNotBlank((CharSequence)bdcdyh)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("bdcdyh", bdcdyh);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS);
            hashMap.put("cflx", "1");
            bdcMap = this.bdcCfMapper.getDjzxByBdcdyh(hashMap);
        }
        return bdcMap;
    }

    public List<BdcXm> getCfXmByBdcdyh(String bdcdyid) {
        return this.bdcCfMapper.getCfXmByBdcdyh(bdcdyid);
    }

    public List<BdcCf> queryBdcCfByGdBdcid(String fwid) {
        if (StringUtils.isNotBlank((CharSequence)fwid)) {
            return this.bdcCfMapper.queryBdcCfByGdBdcid(fwid);
        }
        return new ArrayList<BdcCf>();
    }

    public boolean xfjf(BdcXmRel bdcXmRel) {
        GdCf gdCf;
        BdcXm cfXm;
        return StringUtils.equals((CharSequence)bdcXmRel.getYdjxmly(), (CharSequence)"1") ? null != (cfXm = this.bdcXmService.getBdcXmByProid(bdcXmRel.getYproid())) && StringUtils.equals((CharSequence)cfXm.getDjzx(), (CharSequence)"1204") : null != (gdCf = this.gdFwService.getGdCfByCfid(bdcXmRel.getYqlid(), Integer.valueOf(0))) && StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u7eed\u5c01");
    }

    public void changeXfQszt(BdcXm bdcXm, BdcXmRel bdcXmRel, Integer qszt, String userId) {
        String userName = PlatformUtil.getCurrentUserName((String)userId);
        if (Constants.QLLX_QSZT_HR == qszt) {
            this.changeXfQsztHr(bdcXm, bdcXmRel, userName);
        } else if (Constants.QLLX_QSZT_XS == qszt) {
            this.backXfQsztXs(bdcXm, bdcXmRel);
        }
    }

    private void backXfQsztXs(BdcXm bdcXm, BdcXmRel bdcXmRel) {
        if (CommonUtil.indexOfStrs((String[])Constants.SQLX_NOPP_GDJF_DM, (String)bdcXm.getSqlx())) {
            this.backGdXfXsNopp(bdcXmRel);
        } else if (StringUtils.isNotBlank((CharSequence)bdcXm.getBdcdyid())) {
            List bdcGdCfList;
            List bdcCfList = this.getBdcCfList(bdcXm.getBdcdyid(), Constants.QLLX_QSZT_HR);
            if (CollectionUtils.isNotEmpty((Collection)bdcCfList)) {
                for (BdcCf bdcCf : bdcCfList) {
                    bdcCf.setQszt(Constants.QLLX_QSZT_XS);
                    bdcCf.setJfdbr(" ");
                    bdcCf.setJfdjsj(null);
                    bdcCf.setJfywh(" ");
                    this.entityMapper.saveOrUpdate((Object)bdcCf, (Object)bdcCf.getQlid());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdcGdCfList = this.getBdcGdCfList(bdcXm.getBdcdyid(), 1)))) {
                for (GdCf gdCf : bdcGdCfList) {
                    gdCf.setIsjf(Integer.valueOf(0));
                    gdCf.setJfdbr(" ");
                    gdCf.setJfdbsj(null);
                    gdCf.setJfywh(" ");
                    this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
                }
            }
        }
    }

    private void backGdXfXsNopp(BdcXmRel bdcXmRel) {
        List gdCfList;
        if (StringUtils.isNotBlank((CharSequence)bdcXmRel.getYqlid()) && CollectionUtils.isNotEmpty((Collection)(gdCfList = this.getGdCfList(bdcXmRel.getYqlid(), 1)))) {
            for (GdCf gdCf : gdCfList) {
                gdCf.setIsjf(Integer.valueOf(0));
                gdCf.setJfdbr(" ");
                gdCf.setJfdbsj(null);
                gdCf.setJfywh("");
                this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
            }
        }
    }

    private void changeXfQsztHr(BdcXm bdcXm, BdcXmRel bdcXmRel, String userName) {
        if (CommonUtil.indexOfStrs((String[])Constants.SQLX_NOPP_GDJF_DM, (String)bdcXm.getSqlx())) {
            this.gdXfJfNopp(bdcXm, bdcXmRel, 1, userName);
        } else if (StringUtils.isNotBlank((CharSequence)bdcXm.getBdcdyid())) {
            List bdcGdCfList;
            List bdcCfList = this.getBdcCfList(bdcXm.getBdcdyid(), Constants.QLLX_QSZT_XS);
            if (CollectionUtils.isNotEmpty((Collection)bdcCfList)) {
                for (BdcCf bdcCf : bdcCfList) {
                    bdcCf.setQszt(Constants.QLLX_QSZT_HR);
                    bdcCf.setJfdbr(userName);
                    bdcCf.setJfdjsj(new Date());
                    bdcCf.setJfywh(bdcXm.getBh());
                    this.entityMapper.saveOrUpdate((Object)bdcCf, (Object)bdcCf.getQlid());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdcGdCfList = this.getBdcGdCfList(bdcXm.getBdcdyid(), 0)))) {
                for (GdCf gdCf : bdcGdCfList) {
                    gdCf.setIsjf(Integer.valueOf(1));
                    gdCf.setJfdbr(userName);
                    gdCf.setJfdbsj(new Date());
                    gdCf.setJfywh(bdcXm.getBh());
                    this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
                }
            }
        }
    }

    private void gdXfJfNopp(BdcXm bdcXm, BdcXmRel bdcXmRel, int iszx, String userName) {
        List gdCfList;
        if (StringUtils.isNotBlank((CharSequence)bdcXmRel.getYqlid()) && CollectionUtils.isNotEmpty((Collection)(gdCfList = this.getGdCfList(bdcXmRel.getYqlid(), 0)))) {
            for (GdCf gdCf : gdCfList) {
                gdCf.setIsjf(Integer.valueOf(iszx));
                gdCf.setJfdbr(userName);
                gdCf.setJfdbsj(new Date());
                gdCf.setJfywh(bdcXm.getBh());
                this.entityMapper.saveOrUpdate((Object)gdCf, (Object)gdCf.getCfid());
            }
        }
    }

    private List<GdCf> getBdcGdCfList(String bdcdyid, int qszt) {
        ArrayList<GdCf> bdcGdCfList = new ArrayList<GdCf>();
        List gdCfList = null;
        BdcBdcdy bdcBdcdy = this.bdcdyService.queryBdcdyById(bdcdyid);
        if (null != bdcBdcdy) {
            if (qszt == 0) {
                gdCfList = this.gdCfService.getGdCfListByBdcdyh(bdcBdcdy.getBdcdyh());
            }
            if (qszt == 1) {
                gdCfList = this.gdCfService.getGdZxCfListByBdcdyh(bdcBdcdy.getBdcdyh());
            }
        }
        if (CollectionUtils.isNotEmpty(gdCfList)) {
            for (GdCf gdCf : gdCfList) {
                if (!StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u7eed\u5c01") && !StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u67e5\u5c01")) continue;
                bdcGdCfList.add(gdCf);
            }
        }
        return bdcGdCfList;
    }

    private List<GdCf> getGdCfList(String qlid, int qszt) {
        ArrayList<GdCf> gdCfList = new ArrayList<GdCf>();
        List gdBdcQlRelList = this.gdFwService.getGdBdcQlRelByBdcidOrQlid(null, qlid);
        if (CollectionUtils.isNotEmpty((Collection)gdBdcQlRelList)) {
            for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                List gdBdcQlRels = this.gdFwService.getGdBdcQlRelByBdcidOrQlid(gdBdcQlRel.getBdcid(), null);
                if (!CollectionUtils.isNotEmpty((Collection)gdBdcQlRels)) continue;
                for (GdBdcQlRel gdQlRel : gdBdcQlRels) {
                    GdCf gdCf = this.gdFwService.getGdCfByCfid(gdQlRel.getQlid(), Integer.valueOf(qszt));
                    if (null == gdCf || !StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u7eed\u5c01") && !StringUtils.equals((CharSequence)gdCf.getCflx(), (CharSequence)"\u67e5\u5c01")) continue;
                    gdCfList.add(gdCf);
                }
            }
        }
        return gdCfList;
    }

    private List<BdcCf> getBdcCfList(String bdcdyid, Integer qszt) {
        ArrayList<BdcCf> bdcCfs = new ArrayList<BdcCf>();
        List bdcCfList = this.getBdcCfList(bdcdyid, "1", qszt, null);
        List bdcXfCfList = this.getBdcCfList(bdcdyid, "5", qszt, null);
        if (CollectionUtils.isNotEmpty((Collection)bdcCfList)) {
            bdcCfs.addAll(bdcCfList);
        }
        if (CollectionUtils.isNotEmpty((Collection)bdcXfCfList)) {
            bdcCfs.addAll(bdcXfCfList);
        }
        return bdcCfs;
    }
}

