<@com.html title="归档信息" import="ace">
<style>
    .new-modal {
        width: 600px;
    }

    .modal-dialog {
        width: 650px;
        margin: 30px auto;
    }

    .bootbox {
        overflow: auto;
    }

    /*高级搜索的样式修改*/
    .btn01:hover {
        background-color: #c7c7c7;
        text-decoration: none;
        color: #333;
    }

    .btn01 {
        display: inline-block;
        padding: 4px 12px;
        margin-bottom: 0;
        font-size: 14px;
        color: #333333;
        text-align: center;
        vertical-align: middle;
        cursor: pointer;
        background-color: #f2f2f2;
        border: 1px solid #aaa;
        webkit-border-radius: 0px !important;
        -moz-border-radius: 0px !important;
        border-radius: 0px !important;
    }

    /*移动modal样式*/
    #gjSearchPop .modal-dialog {
        width: 650px;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }

    /*表单样式重写*/
    form input[type='text'], select, textarea {
        border-radius: 4px !important;
        width;
        100% !important;
    }

    .modelFooter {
        background: none;
        border-top: 1px solid #e5e5e5;
        padding: 10px;
        text-align: center;
    }

    .form .row {
        margin: 10px 0px 10px 0px;
    }

    .form .row .col-xs-2 {
        padding-left: 0px;
        padding-right: 4px;
        text-align: right;
    }

    .form .row .col-xs-4 {
        padding-left: 0px;
        padding-right: 0px;
    }

    label {
        font-weight: bold;
    }
</style>
<script>
    $(function () {
        //生成表格
        accessTableGrid();
        $("#getResult").click(function () {
            var ids = $('#access-grid-table').jqGrid('getGridParam', 'selarrrow');
            if (ids.length == 0) {
                bootbox.dialog({
                    message: "<h3><b>请选择至少一条数据!</b></h3>",
                    title: "",
                    buttons: {
                        main: {
                            label: "关闭",
                            className: "btn-primary",
                        }
                    }
                });
                return;
            } else if (ids.length == 1) {
                $.blockUI({message: "请稍等……"});
                bootbox.dialog({
                    message: "<h3><b>您所选归档信息包含归档内容，是否继续归档？</b></h3>",
                    title: "",
                    closeButton: false,
                    buttons: {
                        success: {
                            label: "确定",
                            className: "btn-success",
                            callback: function () {
                                setTimeout($.unblockUI, 10);
                                //单个归档
                                gdOne(ids);
                            }
                        },
                        main: {
                            label: "取消",
                            className: "btn-primary",
                            callback: function () {
                                setTimeout($.unblockUI, 10);
                            }
                        }
                    }
                });
                return;
            } else if (ids.length > 1) {
                $.blockUI({message: "请稍等……"});
                bootbox.dialog({
                    message: "<h3><b>您所选归档信息用包含归档内容，是否继续归档？</b></h3>",
                    title: "",
                    closeButton: false,
                    buttons: {
                        success: {
                            label: "确定",
                            className: "btn-success",
                            callback: function () {
                                setTimeout($.unblockUI, 10);
                                //归档
                                gd(ids);
                            }
                        },
                        main: {
                            label: "取消",
                            className: "btn-primary",
                            callback: function () {
                                setTimeout($.unblockUI, 10);
                            }
                        }
                    }
                });
            }
        })

        //resize to fit page size
        $(window).on('resize.jqGrid', function () {
            var contentWidth;
            if ($("#accessContent").width() > 0) {
                contentWidth = $("#accessContent").width();
            }
            $("#access-grid-table").jqGrid('setGridWidth', contentWidth);
        });
        /*判断浏览器是否是ie8  解决ie8弹出框居中问题*/
        var ua = navigator.userAgent.toLowerCase();
        if (window.ActiveXObject) {
            if (ua.match(/msie ([\d.]+)/)[1] == '8.0') {
                $(window).resize(function () {
                    $.each($(".moveModel > .modal-dialog"), function () {
                        $(this).css("left", ($(window).width() - $(this).width()) / 2);
                        $(this).css("top", "40px");
                    })
                })
            }
        }

        /*   文字水印  */
        $(".watermarkText").watermark();

        //拖拽功能
        $(".modal-header").mouseover(function () {
            $(this).css("cursor", "move");//改变鼠标指针的形状
        })
        $(".modal-header").mouseout(function () {
            $(this).css("cursor", "default");
        })
        $(".gjSearchPop-modal").draggable({opacity: 0.7, handle: 'div.modal-header'});

        //项目表搜索事件
        $("#searchBtn").click(function () {
            var search = $("#search").val();
            $("#gjSearchForm")[0].reset();
            var Url = "${bdcdjUrl}/BdcGdxx/getGdxxPagesJson?" + $("#gjSearchForm").serialize();
            tableReload("access-grid-table", Url, {searchText: search});
        })
        //项目表高级查询的搜索按钮事件
        $("#gjSearchBtn").click(function () {
            var Url = "${bdcdjUrl}/BdcGdxx/getGdxxPagesJson?" + $("#gjSearchForm").serialize();
            tableReload("access-grid-table", Url, {searchText: ""});
        })
        //项目高级查询按钮点击事件
        $("#show").click(function () {
            $("#gjSearchPop").show();
        });
        //项目高级搜索关闭事件
        $("#proHide").click(function () {
            $("#gjSearchPop").hide();
            $("#gjSearchForm")[0].reset();
        });
    })

    //归档功能
    function gd(ids) {
        $.blockUI({message: "归档中，请稍等…"});
        var options = {
            url: '${bdcdjUrl}/BdcGdxx/bdcXmGd?proids=' + ids,
            type: 'get',
            dataType: 'json',
            success: function (result) {
                if (result != '') {
                    tipInfo(result);
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                } else {
                    tipInfo("归档失败，请检查档案系统并重试");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            },
            error: function (result) {
                if (result.status == 200) {
                    if (result.responseText != '') {
                        tipInfo(result.responseText);
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    } else {
                        tipInfo("归档失败，请检查档案系统并重试");
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    }
                } else {
                    tipInfo("归档失败，请重试");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            }
        };
        $.ajax(options);
    }

    var isGd = true;

    //判断是否已经归档
    function checkIsGd(ids) {
        var options = {
            url: '${bdcdjUrl}/BdcGdxx/checkBdcXmIsGd?proid=' + ids,
            type: 'get',
            dataType: 'json',
            success: function (result) {
                if (result != '') {
                    tipInfo(result);
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                } else {
                    isGd = false;
                }
            },
            error: function (result) {
                if (result.status == 200) {
                    if (result.responseText != '') {
                        tipInfo(result.responseText);
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    } else {
                        tipInfo("网络出现问题");
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    }
                } else {
                    tipInfo("网络出现问题");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            }
        };
        $.ajax(options);
    }


    //归档功能(单个归档)
    function gdOne(ids) {
        $.blockUI({message: "归档中，请稍等…"});
        var options = {
            url: '${bdcdjUrl}/BdcGdxx/bdcXmGdOne?wiid=' + ids,
            type: 'get',
            dataType: 'json',
            success: function (result) {
                if (result != '') {
                    tipInfo(result);
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                } else {
                    tipInfo("归档失败，请检查档案系统并重试");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            },
            error: function (result) {
                if (result.status == 200) {
                    if (result.responseText != '') {
                        tipInfo(result.responseText);
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    } else {
                        tipInfo("归档失败，请检查档案系统并重试");
                        $('#access-grid-table').trigger("reloadGrid");
                        setTimeout($.unblockUI, 10);
                    }
                } else {
                    tipInfo("归档失败，请重试");
                    $('#access-grid-table').trigger("reloadGrid");
                    setTimeout($.unblockUI, 10);
                }
            }
        };
        $.ajax(options);
    }

    function tableReload(table, Url, data) {
        var jqgrid = $("#" + table);
        jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
        jqgrid.trigger("reloadGrid");//重新加载JqGrid
    }

    function tipInfo(msg) {
        bootbox.dialog({
            message: "<h3><b>" + msg + "</b></h3>",
            title: "",
            buttons: {
                main: {
                    label: "关闭",
                    className: "btn-primary"
                }
            }
        });
        return;
    }

    //auth表格初始化
    function accessTableGrid() {
        var grid_selector = "#access-grid-table";
        var pager_selector = "#access-grid-pager";
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        jQuery(grid_selector).jqGrid({
            url: "${bdcdjUrl}/BdcGdxx/getGdxxPagesJson",
            datatype: "json",
            height: 'auto',
            jsonReader: {id: 'WIID'},
            colNames: ['编号', '不动产权证号', '不动产单元号', '坐落', '归档人', '归档日期', '归档状态', '档案ID'],
            colModel: [
                {name: 'BH', index: 'BH', width: '14%', sortable: false},
                {name: 'BDCQZH', index: 'BDCQZH', width: '20%', sortable: false},
                {name: 'BDCDYH', index: 'BDCDYH', width: '18%', sortable: false},
                {name: 'ZL', index: 'ZL', width: '18%', sortable: false},
                {name: 'GDR', index: 'GDR', width: '10%', sortable: false},
                {
                    name: 'GDRQ',
                    index: 'GDRQ',
                    width: '10%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        if (!cellvalue) {
                            return "";
                        }
                        var value = cellvalue;
                        var data = new Date(value).Format("yyyy-MM-dd");
                        return data;
                    }
                },
                {
                    name: '',
                    index: '',
                    width: '8%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        var gdr=rowObject.GDR;
                        var gdrq=rowObject.GDRQ;
                        if ((gdr!=undefined && gdr !='')||(gdrq !=undefined && gdrq!='')) {
                            return '<span class="label label-success">已归档</span>';
                        } else {
                            return '<span class="label label-warning">归档失败</span>';
                        }
                    }
                },
                {name: 'WIID', index: 'WIID', width: '0%',hidden:true,sortable: false}
            ],
            viewrecords: true,
            rowNum: 10,
            rowList: [10, 20, 30],
            pagerpos: "left",
            pager: pager_selector,
            altRows: false,
            multiboxonly: true,
            multiselect: true,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    //resize
                    $(grid_selector).jqGrid('setGridWidth', $("#accessContent").width());
                }, 0);
                var jqData = $(grid_selector).jqGrid("getRowData");
                $.each(jqData, function (index, data) {
                    getGdxx(data.WIID, $(grid_selector), data.WIID);
                })
            },
            ondblClickRow: function (rowid) {
            },
            caption: "",
            autowidth: true
        });
        Date.prototype.Format = function (fmt) {
            var o = {
                "M+": this.getMonth() + 1, //月份
                "d+": this.getDate(), //日
                "h+": this.getHours(), //小时
                "m+": this.getMinutes(), //分
                "s+": this.getSeconds(), //秒
                "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                "S": this.getMilliseconds()             //毫秒
            };
            if (/(y+)/.test(fmt))
                fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o)
                if (new RegExp("(" + k + ")").test(fmt))
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            return fmt;
        }
    }

    //replace icons with FontAwesome icons like above
    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    //xiejianan 获取不动产单元的不动产类型，权利人，坐落，权利状态信息
    function getGdxx(rowid, table, wiid) {
        $.ajax({
            type: "GET",
            url: "${bdcdjUrl}/BdcGdxx/getGdxx?wiid=" + wiid,
            dataType: "json",
            success: function (result) {
                table.setCell(rowid, "BDCQZH", result.bdcqzh);
                table.setCell(rowid, "BDCDYH", result.bdcdyh);
                table.setCell(rowid, "ZL", result.zl);
            }
        });
    }

</script>
<div class="space-6"></div>
<div class="main-container">
    <div class="page-content" id="accessContent">
        <div class="simpleSearch">
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <input type="text" class="SSinput watermarkText" id="search" data-watermark="请输入编号">
                    </td>
                    <td class="Search">
                        <a href="#" id="searchBtn">
                            搜索
                            <i class="ace-icon fa fa-search bigger-130"></i>
                        </a>
                    </td>
                    <td style="border: 0px">&nbsp;</td>
                    <td>
                        <button type="button" class="btn01 AdvancedButton" id="show">高级搜索</button>
                    </td>
                </tr>
            </table>
        </div>
        <div class="tableHeader">
            <ul>
                <li>
                    <button type="button" id="getResult">
                        <i class="ace-icon fa fa-file"></i>
                        <span>归档</span>
                    </button>
                </li>
            </ul>
        </div>
        <table id="access-grid-table"></table>

        <div id="access-grid-pager"></div>

    </div>
</div>
<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
<!--高级搜索-->
<div class="Pop-upBox moveModel" style="display: none;" id="gjSearchPop">
    <div class="modal-dialog gjSearchPop-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ace-icon fa fa-search bigger-110"></i>高级查询</h4>
                <button type="button" id="proHide" class="proHide"><i class="ace-icon glyphicon glyphicon-remove"></i>
                </button>
            </div>
            <div class="bootbox-body" style="background: #fafafa;">
                <form class="form advancedSearchTable" id="gjSearchForm">
                <#--<div class="row">-->
                <#--<div class="rowLabel col-xs-2">-->
                <#--<label>项目名称：</label>-->
                <#--</div>-->
                <#--<div class="rowContent col-xs-4">-->
                <#--<input type="text" name="xmmc" class="form-control">-->
                <#--</div>-->
                <#--<div class="rowLabel col-xs-2">-->
                <#--<label>坐落：</label>-->
                <#--</div>-->
                <#--<div class="rowContent col-xs-4">-->
                <#--<input type="text" name="zl" class="form-control">-->
                <#--</div>-->
                <#--</div>-->
                        <#list gdxxGjssOrderList as gdxxGjss>
                            <#if gdxxGjss == 'bdcdyh'>
                                <#if (gdxxGjss_index + 1) % 2 != 0>
                                <div class="row">
                                </#if>
                                <div class="rowLabel col-xs-2">
                                    <label>不动产单元号：</label>
                                </div>
                                <div class="rowContent col-xs-4">
                                    <input type="text" name="bdcdyh" class="form-control">
                                </div>
                                <#if (gdxxGjss_index + 1) % 2 == 0>
                                </div>
                                </#if>

                            <#elseif   gdxxGjss=='bdcqzh'>
                                <#if (gdxxGjss_index + 1) % 2 != 0>
                                <div class="row">
                                </#if>
                                <div class="rowLabel col-xs-2">
                                    <label>不动产权证号：</label>
                                </div>
                                <div class="rowContent col-xs-4">
                                    <input type="text" name="bdcqzh" class="form-control">
                                </div>
                                <#if (gdxxGjss_index + 1) % 2 == 0>
                                </div>
                                </#if>

                            <#elseif   gdxxGjss=='gdjg'>
                                <#if (gdxxGjss_index + 1) % 2 != 0>
                                <div class="row">
                                </#if>
                                <div class="rowLabel col-xs-2">
                                    <label>归档结果：</label>
                                </div>
                                <div class="rowContent col-xs-4">
                                    <select name="isgd" class="form-control">
                                        <option value="" selected>请选择</option>
                                        <option value="a">未归档</option>
                                        <option value="b">已归档</option>
                                    </select>
                                </div>
                                <#if (gdxxGjss_index + 1) % 2 == 0>
                                </div>
                                </#if>

                            <#elseif   gdxxGjss=='zl'>
                                <#if (gdxxGjss_index + 1) % 2 != 0>
                                <div class="row">
                                </#if>
                                <div class="rowLabel col-xs-2">
                                    <label>坐落：</label>
                                </div>
                                <div class="rowContent col-xs-4">
                                    <input type="text" name="zl" class="form-control">
                                </div>
                                <#if (gdxxGjss_index + 1) % 2 == 0>
                                </div>
                                </#if>
                            </#if>
                        </#list>


                <#--
                <div class="row">
                    <div class="rowLabel col-xs-2">
                        <label>起始日期：</label>
                    </div>
                    <div class="rowContent col-xs-4">
                    <span class="input-icon">
                         <input type="text" class="date-picker form-control" name="qsrq"
                                data-date-format="yyyy-mm-dd">
                        <i class="ace-icon fa fa-calendar"></i>
                    </span>
                    </div>
                    <div class="rowLabel col-xs-2">
                        <label>结束日期：</label>
                    </div>
                    <div class="rowContent col-xs-4">
                    <span class="input-icon">
                         <input type="text" class="date-picker form-control" name="jsrq"
                                data-date-format="yyyy-mm-dd">
                        <i class="ace-icon fa fa-calendar"></i>
                    </span>
                    </div>
                </div>-->
                        <#if dwdmFlag == 'true'>
                            <div class="row">
                                <div class="col-xs-2">
                                    <label>区县：</label>
                                </div>
                                <div class="col-xs-4">
                                    <select name="djzqmc" class="form-control">
                                        <option></option>
                                        <#list djzqmc as djzq>
                                            <option value="${djzq}">${djzq}</option>
                                        </#list>
                                    </select>
                                </div>
                            </div>
                        </#if>
                </form>
            </div>
            <div class="modelFooter">
                <button type="button" class="btn btn-sm btn-primary" id="gjSearchBtn">搜索</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade in Pop" style="display:none;" id="modal-backdrop-pop"></div>
</@com.html>