<@com.html title="不动产电子证照管理" import="ace,public">
    <style>
        /*新建弹出框的样式修改及ie8居中问题*/
        #myModal .modal-dialog {
            width: 1000px;
            margin: 30px auto;
        }

        #myModal .bootbox-body {
            height: 580px;
            padding: 0px;
        }

        .step-content .step-pane {
            min-height: 50px;
            padding: 0px 10px 0px 5px;
        }

        .profile-user-info-striped .profile-info-name {
            color: #fff;
            background-color: #408fc6;
            border-top: 1px solid #408fc6;
            width: 130px;
        }

        .profile-info-value > input {
            width: 200px;
        }

        /*表单样式重写*/
        form input[type='text'], select, textarea {
            border-radius: 4px !important;
            width;
            100% !important;
        }


        .form .row {
            margin: 10px 0px 10px 0px;
        }

        .form .row .col-xs-1 {
            padding-left: 0px;
            padding-right: 4px;
            text-align: right;
            width: 170px;
            height: 30px;
        }


        label {
            font-weight: bold;
        }
    </style>
    <script>
        $(function () {
            //多选数据
            $mulData = new Array();
            $mulRowid = new Array();
            //下拉框  含搜索的
            $('.chosen-select').chosen({allow_single_deselect: true, no_results_text: "无匹配数据", width: "100%"});
            //resize the chosen on window resize
            $(window).on('resize.chosen', function () {
                $.each($('.chosen-select'), function (index, obj) {
                    $(obj).next().css("width", 0);
                    var w = $(obj).parent().width();
                    $(obj).next().css("width", w);
                })
                $.each($('.chosen-single-select'), function (index, obj) {
                    $(obj).next().css("width", 0);
                    var e = $(obj).parent().width();
                    $(obj).next().css("width", e);
                })
            }).trigger('resize.chosen');

            /*   文字水印  */
            $(".watermarkText").watermark();

            //绑定回车键
            $(document).keydown(function (event) {
                if (event.keyCode == 13) {
                    $("#search").trigger("click");
                }
            });

            var height = $(document).height() - 150;
            $(".bootbox-body").css("height", height);

            //生成表格
            tableGrid();

            //resize to fit page size
            $(window).on('resize.jqGrid', function () {
                var contentWidth;
                if ($("#mainContent").width() > 0) {
                    contentWidth = $("#mainContent").width();
                }
                $("#table-grid-table").jqGrid('setGridWidth', contentWidth);
            });

            //生成电子证照
            $("#createDzzz").click(function () {
                if ($mulData.length == 0) {
                    alert("请至少选择一条数据！");
                    return;
                }

                var zsids = "";
                for (var i = 0; i < $mulData.length; i++) {
                    if (zsids != null && zsids != "")
                        zsids = zsids + "," + $mulData[i].ZSID;
                    else
                        zsids = $mulData[i].ZSID;
                }
                createZz(zsids);

            });

            //查询
            $("#search").click(function () {
                $mulData = new Array();
                $mulRowid = new Array();
                var bh =  $("#bh").val();
                var zl =  $("#zl").val();
                var bdcqzh =  $("#bdcqzh").val();
                var exactQuery = $("#exactQueryywsj").get(0).checked ? "true" : "false";

                if((bh == "" || bh == null || bh == undefined) && (zl == "" || zl == null || zl == undefined)
                    && ((bdcqzh == "" || bdcqzh == null || bdcqzh == undefined))){
                    tipInfo("请输入编号/坐落/不动产权证号!");
                }else {
                    var Url = "${bdcdjUrl}/dzzz/getZsForDzzzPageJson";
                    tableReload("table-grid-table", Url, {bh: bh,bdcqzh:bdcqzh,zl:zl,exactQuery:exactQuery});
                }


            });

            //注销电子证照
            $("#zxDzzz").click(function () {
                if ($mulData.length == 0) {
                    alert("请至少选择一条数据！");
                    return;
                }
                var zsids = "";
                for (var i = 0; i < $mulData.length; i++) {
                    if (zsids != null && zsids != "")
                        zsids = zsids + "," + $mulData[i].ZSID;
                    else
                        zsids = $mulData[i].ZSID;
                }
                zxZz(zsids);
            });


        });

        function tableReload(table, Url, data) {
            var jqgrid = $("#" + table);
            jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
            jqgrid.trigger("reloadGrid");//重新加载JqGrid
        }

        function viewDzzz(zsid) {
            var url = "${bdcdjUrl}/dzzz/viewDzzz?zsid=" + zsid;
            var w_width = screen.availWidth - 10;
            var w_height = screen.availHeight - 32;
            window.open(url, "不动产电子证照", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");

        }

        function downloadDzzz(zsid) {
            $.blockUI({message: "请稍等……"});
            $.ajax({
                type: "POST",
                url: "${bdcdjUrl}/dzzz/xzDzzz",
                data: {zsid: zsid},
                dataType: "json",
                success: function (result) {
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                    if (result.msg == "success") {
                        alert("下载电子证照成功！");
                    } else {
                        alert(result.msg);
                    }

                },
                error: function (data) {
                    setTimeout($.unblockUI, 10);
                    alert("失败，请联系管理员！");
                }
            });
        }

        //生成
        function createZz(zsids) {
            $.blockUI({message: "请稍等……"});
            $.ajax({
                type: "POST",
                url: "${bdcdjUrl}/dzzz/createDzzzByZsids",
                data: {zsids: zsids},
                dataType: "json",
                success: function (result) {
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                    if (result.msg == "success") {
                        alert("生成电子证照成功！");
                    } else {
                        alert(result.msg);
                    }

                },
                error: function (data) {
                    setTimeout($.unblockUI, 10);
                    alert("失败，请联系管理员！");
                }
            });
        }

        //注销
        function zxZz(zsids) {
            $.blockUI({message: "请稍等……"});
            $.ajax({
                type: "POST",
                url: "${bdcdjUrl}/dzzz/zxDzzz",
                data: {zsids: zsids},
                dataType: "json",
                success: function (result) {
                    //去掉遮罩
                    setTimeout($.unblockUI, 10);
                    if (result.msg == "success") {
                        alert("注销电子证照成功！");
                    } else {
                        alert(result.msg);
                    }

                },
                error: function (data) {
                    setTimeout($.unblockUI, 10);
                    alert("失败，请联系管理员！");
                }
            });
        }

        //auth表格初始化
        function tableGrid() {
            var grid_selector = "#table-grid-table";
            var pager_selector = "#table-grid-pager";
            //resize on sidebar collapse/expand
            var parent_column = $(grid_selector).closest('[class*="col-"]');
            $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
                if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                    $(grid_selector).jqGrid('setGridWidth', parent_column.width());
                }
            });
            jQuery(grid_selector).jqGrid({
                url: "${bdcdjUrl}/dzzz/getZsForDzzzPageJson",
                datatype: "json",
                height: 'auto',
                jsonReader: {id: 'ZSID'},
                colNames: ['ZSID', '产权证号', '受理编号', '不动产单元号', '权利人', '义务人', '坐落','证照标识', 'PROID', "操作"],
                colModel: [
                    {name: 'ZSID', index: 'ZSID', width: '0%', sortable: false, hidden: true},
                    {name: 'BDCQZH', index: 'BDCQZH', width: '10%', sortable: false},
                    {name: 'BH', index: 'BH', width: '8%', sortable: false},
                    {
                        name: 'BDCDYH',
                        index: 'BDCDYH',
                        width: '10%',
                        sortable: false,
                        formatter: function (cellvalue, options, rowObject) {
                            var value = "";
                            if (cellvalue != null && cellvalue != "" && cellvalue != undefined) {
                                value = cellvalue.substr(0, 6) + " " + cellvalue.substr(6, 6) + " " + cellvalue.substr(12, 7) + " " + cellvalue.substr(19);
                            }
                            return value;
                        }
                    },
                    {name: 'QLR', index: 'QLR', width: '8%', sortable: false},
                    {name: 'YWR', index: 'YWR', width: '8%', sortable: false},
                    {name: 'ZL', index: 'ZL', width: '10%', sortable: false},
                    {name: 'ZZBS', index: 'ZZBS', width: '10%', sortable: false},
                    {name: 'PROID', index: 'PROID', width: '0%', sortable: false, hidden: true},
                    {
                        name: 'CZ',
                        index: '',
                        width: '5%',
                        sortable: false,
                        formatter: function (cellvalue, options, rowObject) {
                            return '<div style="margin-left:8px;">' +
                                ' <div title="查看" style="float:left;cursor:pointer; margin-left: 8px;" class="ui-pg-div ui-inline-edit" id="" onclick="viewDzzz(\'' + rowObject.ZSID + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class="fa fa-search fa-lg blue "></span></div>'
                                +
                                ' <div title="下载" style="float:left;cursor:pointer; margin-left: 8px;" class="ui-pg-div ui-inline-edit" id="" onclick="downloadDzzz(\'' + rowObject.ZSID + '\')" onmouseover="jQuery(this).addClass(\'ui-state-hover\');" onmouseout="jQuery(this).removeClass(\'ui-state-hover\');"><span class="fa fa-download fa-lg blue "></span></div>' +
                                '</div>'
                        }
                    }
                ],
                viewrecords: true,
                rowNum: 10,
                rowList: [5, 10, 15],
                pagerpos: "left",
                pager: pager_selector,
                altRows: false,
                multiboxonly: true,
                multiselect: true,
                loadComplete: function () {
                    var table = this;
                    setTimeout(function () {
                        updatePagerIcons(table);
                        enableTooltips(table);
                        //qlrForTable("#table-grid-table");
                        //resize
                        $(grid_selector).jqGrid('setGridWidth', $("#mainContent").width());
                    }, 0);
                },
                onSelectAll: function (aRowids, status) {
                    var $myGrid = $(this);
                    $.each(aRowids, function (i, e) {
                        var cm = $myGrid.jqGrid('getRowData', e);
                        //判断是已选择界面还是原界面
                        if (cm.ZSID == e) {
                            var index = $.inArray(e, $mulRowid);
                            if (status && index < 0) {
                                $mulData.push(cm);
                                $mulRowid.push(e);
                            } else if (!status && index >= 0) {
                                $mulData.remove(index);
                                $mulRowid.remove(index);
                            }
                        }
                    })
                },
                onSelectRow: function (rowid, status) {
                    var $myGrid = $(this);
                    var cm = $myGrid.jqGrid('getRowData', rowid);
                    //判断是已选择界面还是原界面
                    if (cm.ZSID == rowid) {
                        var index = $.inArray(rowid, $mulRowid);
                        if (status && index < 0) {
                            $mulData.push(cm);
                            $mulRowid.push(rowid);
                        } else if (!status && index >= 0) {
                            $mulData.remove(index);
                            $mulRowid.remove(index);
                        }
                    }
                },
                caption: "",
                autowidth: true
            });

        }

        //replace icons with FontAwesome icons like above
        function updatePagerIcons(table) {
            var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
            $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
                var icon = $(this);
                var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

                if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
            })
        }

        function enableTooltips(table) {
            $('.navtable .ui-pg-button').tooltip({container: 'body'});
            $(table).find('.ui-pg-div').tooltip({container: 'body'});
        }

        //为表格添加权利人列数据
        /*function qlrForTable(grid_selector) {
            var jqData = $(grid_selector).jqGrid("getRowData");
            var rowIds = $(grid_selector).jqGrid('getDataIDs');
            $.each(jqData, function (index, data) {
                getQlrByZsid(data.ZSID, $(grid_selector), rowIds[index]);
            })
        }*/

        function getQlrByZsid(zsid, table, rowid) {
            $.ajax({
                type: "GET",
                url: "${bdcdjUrl}/dzzz/getQlrByZsid?zsid=" + zsid,
                success: function (result) {
                    var qlr = result.qlr;
                    var ywr = result.ywr;

                    if (qlr == null || qlr == "undefined")
                        qlr = "";
                    var cellValqlr = "";
                    cellValqlr += '<span>' + qlr + '</span>';
                    table.setCell(rowid, "QLR", cellValqlr);

                    if (ywr == null || ywr == "undefined")
                        ywr = "";
                    var cellValywr = "";
                    cellValywr += '<span>' + ywr + '</span>';
                    table.setCell(rowid, "YWR", cellValywr);
                }
            });
        }

    </script>
    <div class="main-container">
        <div class="space-10"></div>
        <div class="main-container">
            <div class="page-content">
                <form class="form advancedSearchTable">
                    <div class="row">
                        <div class="col-xs-1">
                            <label>受理编号：</label>
                        </div>
                        <div class="col-xs-1">
                            <input type="text" id="bh">
                        </div>
                        <div class="col-xs-1">
                            <label>坐落：</label>
                        </div>
                        <div class="col-xs-1">
                            <input type="text" id="zl">
                        </div>
                        <div class="col-xs-1">
                            <label>不动产权证号：</label>
                        </div>
                        <div class="col-xs-1">
                            <input type="text" id="bdcqzh">
                        </div>
                        <div class="col-xs-1" style="width: 270px;">
                            <button type="button" class="btn btn-sm btn-primary"
                                    id="search">查&nbsp;&nbsp;询
                                <i class="ace-icon fa fa-search bigger-130"></i>
                            </button>
                            <label><input type="checkbox" id="exactQueryywsj"/>精确查询</label>
                        </div>
                    </div>
                </form>
                <div class="tableHeader">
                    <ul>
                        <li>
                            <button type="button" id="createDzzz">
                                <i class="ace-icon fa fa-download"></i>
                                <span>生成</span>
                            </button>
                        </li>
                        <li>
                            <button type="button" id="zxDzzz">
                                <i class="ace-icon fa fa-pencil"></i>
                                <span>注销</span>
                            </button>
                        </li>
                    </ul>
                </div>
                <table id="table-grid-table"></table>
                <div id="table-grid-pager"></div>
            </div>
        </div>
    </div>
</@com.html>