/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.rest.hm;

import cn.gtmap.estateplat.server.core.exception.AppException;
import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.OpenApiResponse;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.BdcXmxxDTO;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.BdcxxDTO;
import cn.gtmap.estateplat.server.core.model.ycsl.qo.BdcdyQlxxQO;
import cn.gtmap.estateplat.server.enums.ApiResponseCodeEnum;
import cn.gtmap.estateplat.server.service.rest.OpenApiConvertService;
import cn.gtmap.estateplat.server.service.rest.OpenApiCreateBdcXmService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryCqxxService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryMediaService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryQlrxxService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryWorkflowService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestParamCheckService;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import cn.gtmap.estateplat.server.utils.HouMaYcslApiRequestParser;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GisqRealEstate-UnityPlatformQuery"})
public class HouMaYcslController {
    @Autowired
    private LocalValidatorFactoryBean validator;
    @Autowired
    private OpenApiQueryCqxxService openApiQueryCqxxService;
    @Autowired
    private OpenApiQueryQlrxxService openApiQueryQlrxxService;
    @Autowired
    private OpenApiResponseService openApiResponseService;
    @Autowired
    private OpenApiCreateBdcXmService openApiCreateBdcXmService;
    @Autowired
    private OpenApiRequestParamCheckService requestParamCheckService;
    @Autowired
    private OpenApiConvertService convertService;
    @Autowired
    private OpenApiQueryWorkflowService openApiQueryWorkflowService;
    @Autowired
    private OpenApiQueryMediaService openApiQueryMediaService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.validator);
    }

    @ResponseBody
    @RequestMapping(value={"/queryObligees"}, method={RequestMethod.POST})
    public String queryObligees(@RequestBody String jsonStr) {
        try {
            this.logger.info("GisqRealEstate-UnityPlatformQuery/queryObligees \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)jsonStr, (Object)new Date());
            String accurateParameters = "timestamp,qlbsms";
            ApiRequestParameter requestParameter = HouMaYcslApiRequestParser.parse((String)jsonStr, (String)accurateParameters, null);
            String res = this.openApiQueryQlrxxService.queryObligees(requestParameter);
            this.logger.info("GisqRealEstate-UnityPlatformQuery/queryObligees \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
            return res;
        }
        catch (AppException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/unityplatformquery/queryunit"}, method={RequestMethod.POST})
    public Object queryBdcdy(@Valid @NotNull @RequestBody String encryptParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/unityplatformquery/queryunit \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)encryptParam, (Object)new Date());
        List bdcdyQlxxBOList = null;
        BdcdyQlxxQO bdcdyQlxxQO = null;
        try {
            String decryptStr = HouMaYcslApiRequestParser.parse((String)encryptParam);
            if (StringUtils.isNotBlank((CharSequence)decryptStr)) {
                bdcdyQlxxQO = (BdcdyQlxxQO)JSON.parseObject((String)decryptStr, BdcdyQlxxQO.class);
            }
            bdcdyQlxxBOList = this.openApiQueryCqxxService.queryBdcdyQlxxList(bdcdyQlxxQO);
        }
        catch (Exception e) {
            throw new OpenApiException(e.getMessage());
        }
        String res = JSONObject.toJSONString((Object)this.openApiResponseService.response((Object)bdcdyQlxxBOList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        this.logger.info("GisqRealEstate-UnityPlatformQuery/unityplatformquery/queryunit \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/queryUnits"}, method={RequestMethod.POST})
    public Object queryBdcdyJcxx(@Valid @NotNull @RequestBody String encryptParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/queryUnits \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)encryptParam, (Object)new Date());
        JSONObject bdcdyJcxx = null;
        String dybm = null;
        ArrayList dybsmArray = null;
        try {
            String decryptStr = HouMaYcslApiRequestParser.parse((String)encryptParam);
            if (StringUtils.isNotBlank((CharSequence)decryptStr)) {
                bdcdyJcxx = JSON.parseObject((String)decryptStr);
            }
            if (bdcdyJcxx != null) {
                dybm = bdcdyJcxx.getString("dybm");
                dybsmArray = Lists.newArrayList((Iterable)bdcdyJcxx.getJSONArray("dybsms"));
            }
        }
        catch (Exception e) {
            throw new OpenApiException(e.getMessage());
        }
        Object resultList = this.openApiQueryCqxxService.queryBdcdyJbxxList(dybm, dybsmArray);
        String res = JSONObject.toJSONString((Object)this.openApiResponseService.response(resultList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        this.logger.info("GisqRealEstate-UnityPlatformQuery/queryUnits \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/queryRights"}, method={RequestMethod.POST})
    public String queryRights(@RequestBody String param) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/queryRights \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)param, (Object)new Date());
        try {
            String accurateParameters = "timestamp,qlbsms,qlbm";
            ApiRequestParameter requestParameter = HouMaYcslApiRequestParser.parse((String)param, (String)accurateParameters, null);
            String res = this.openApiQueryCqxxService.queryRights(requestParameter);
            this.logger.info("GisqRealEstate-UnityPlatformQuery/queryRights \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
            return res;
        }
        catch (AppException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/workFlow/startWork"}, method={RequestMethod.POST})
    public String createBdcXm(@RequestBody String bdcxx) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/workFlow/startWork \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)bdcxx, (Object)new Date());
        try {
            BdcxxDTO bdcxxDTO = HouMaYcslApiRequestParser.parseBdcxx((String)bdcxx);
            String accurateParameters = "lcdm,bdcycywh,xzq";
            this.requestParamCheckService.validateFiledIsNull((Object)bdcxxDTO, accurateParameters);
            BdcXmxxDTO bdcXmxxDTO = this.convertService.convertBdcxx(bdcxxDTO);
            this.requestParamCheckService.checkBdcxx(bdcXmxxDTO);
            String res = this.openApiCreateBdcXmService.createBdcXm(bdcXmxxDTO);
            this.logger.info("GisqRealEstate-UnityPlatformQuery/workFlow/startWork \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
            return JSON.toJSONString((Object)this.openApiResponseService.response((Object)res));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/queryBdcUnitNum"}, method={RequestMethod.POST})
    public String queryFwtc(@RequestBody String jsonParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/queryBdcUnitNum \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)jsonParam, (Object)new Date());
        try {
            String decryptParam = HouMaYcslApiRequestParser.parseByPrivateKey((String)jsonParam);
            return this.openApiQueryQlrxxService.queryFwtc(decryptParam);
        }
        catch (AppException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/getTaskOfProcess"}, method={RequestMethod.POST})
    public String queryBjjd(@RequestBody String jsonParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/getTaskOfProcess \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)jsonParam, (Object)new Date());
        try {
            String decryptParam = HouMaYcslApiRequestParser.parseByPrivateKey((String)jsonParam);
            List data = this.openApiQueryWorkflowService.queryBjjd(decryptParam);
            return JSON.toJSONString((Object)this.openApiResponseService.response((Object)data));
        }
        catch (AppException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/certiCheck"}, method={RequestMethod.POST})
    public String queryHasZs(@RequestBody String jsonParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/certiCheck \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)jsonParam, (Object)new Date());
        try {
            String accurateParameters = "zjh,qlrmc,fzbm";
            ApiRequestParameter apiRequestParameter = HouMaYcslApiRequestParser.parse((String)jsonParam, (String)accurateParameters, null);
            List data = this.openApiQueryCqxxService.queryHasZs(apiRequestParameter);
            String code = CollectionUtils.isNotEmpty((Collection)data) ? ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getDm() : ApiResponseCodeEnum.RESPONSE_CODE_ERROR.getDm();
            OpenApiResponse openApiResponse = new OpenApiResponse();
            openApiResponse.setCode(code);
            openApiResponse.setMsg(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getMc());
            return JSON.toJSONString((Object)openApiResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (AppException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/findLandMsg"}, method={RequestMethod.POST})
    public Object queryBdcTdxx(@Valid @NotNull @RequestBody String encryptParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/findLandMsg \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)encryptParam, (Object)new Date());
        String dybm = null;
        String bdcqzh = null;
        try {
            JSONObject tdParam = null;
            String decryptStr = HouMaYcslApiRequestParser.parse((String)encryptParam);
            if (StringUtils.isNotBlank((CharSequence)decryptStr)) {
                tdParam = JSON.parseObject((String)decryptStr);
            }
            if (tdParam != null) {
                dybm = tdParam.getString("zddm");
                bdcqzh = tdParam.getString("bdcqzh");
            }
        }
        catch (Exception e) {
            throw new OpenApiException(e.getMessage());
        }
        Object resultList = this.openApiQueryCqxxService.queryBdcTdjbxxAndQlxx(dybm, bdcqzh);
        return JSONObject.toJSONString((Object)this.openApiResponseService.response(resultList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
    }

    @ResponseBody
    @RequestMapping(value={"/queryZjAndSwZt"}, method={RequestMethod.GET})
    public Object queryZjAndSwZt(@Valid @NotNull @RequestParam String proid) {
        return this.openApiQueryWorkflowService.queryZjAndSwZt(proid);
    }

    @ResponseBody
    @RequestMapping(value={"/offlineTakeback"}, method={RequestMethod.POST})
    public String ycslQh(@Valid @NotNull @RequestBody String encryptParam) {
        String ycywh = null;
        try {
            JSONObject param = null;
            String decryptStr = HouMaYcslApiRequestParser.parse((String)encryptParam);
            if (StringUtils.isNotBlank((CharSequence)decryptStr)) {
                param = JSON.parseObject((String)decryptStr);
            }
            if (param != null) {
                ycywh = param.getString("ycywh");
            }
        }
        catch (Exception e) {
            throw new OpenApiException(e.getMessage());
        }
        String result = this.openApiQueryWorkflowService.ycslQh(ycywh);
        return JSONObject.toJSONString((Object)this.openApiResponseService.response((Object)result), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    @ResponseBody
    @RequestMapping(value={"/getBdcLastDatums"}, method={RequestMethod.POST})
    public Object queryFjxx(@Valid @NotNull @RequestBody String encryptParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/getBdcLastDatums \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)encryptParam, (Object)new Date());
        JSONObject param = null;
        String qlbm = null;
        ArrayList qlids = null;
        try {
            String decryptStr = HouMaYcslApiRequestParser.parse((String)encryptParam);
            if (StringUtils.isNotBlank((CharSequence)decryptStr)) {
                param = JSON.parseObject((String)decryptStr);
            }
            if (param != null) {
                qlbm = param.getString("qlbm");
                qlids = Lists.newArrayList((Iterable)param.getJSONArray("qlbsms"));
            }
        }
        catch (Exception e) {
            throw new OpenApiException(e.getMessage());
        }
        List resultList = this.openApiQueryMediaService.queryBdcFjxx(qlbm, qlids);
        String res = JSONObject.toJSONString((Object)this.openApiResponseService.response((Object)resultList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        this.logger.info("GisqRealEstate-UnityPlatformQuery/getBdcLastDatums \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
        return res;
    }

    @RequestMapping(value={"/swzj"}, method={RequestMethod.GET})
    public String swzj(@Valid @NotBlank String proid, Model model) {
        model.addAttribute("proid", (Object)proid);
        model.addAttribute("bdcdjUrl", (Object)AppConfig.getProperty((String)"bdcdj.url"));
        return "ycsl/hma/swzjxx";
    }

    @ResponseBody
    @RequestMapping(value={"/ObligeeBlackList"}, method={RequestMethod.POST})
    public Object cxhmd(@Valid @NotNull @RequestBody String encryptParam) {
        this.logger.info("GisqRealEstate-UnityPlatformQuery/ObligeeBlackList \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)encryptParam, (Object)new Date());
        String res = JSONObject.toJSONString((Object)this.openApiResponseService.response(null), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        this.logger.info("GisqRealEstate-UnityPlatformQuery/ObligeeBlackList \u63a5\u53e3\u54cd\u5e94\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u65f6\u95f4\uff1a{}", (Object)res, (Object)new Date());
        return res;
    }
}

