/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import cn.gtmap.estateplat.server.core.exception.ConfigNotFoundException;
import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.exception.ParameterNotFoundException;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.BdcxxDTO;
import cn.gtmap.estateplat.server.utils.HmaRsaUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gtis.config.AppConfig;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HouMaYcslApiRequestParser {
    private static final String REQUEST_TIME_OUT = AppConfig.getProperty((String)"hma.st.ycsl.request.time.out");
    private static final String API_RSA_PRIVATEKEY = AppConfig.getProperty((String)"hma.st.ycsl.private.key");
    private static final String PARAMETER_ISNULL = "\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String CALL_ADMIN = "\u7cfb\u7edf\u914d\u7f6e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458";

    private HouMaYcslApiRequestParser() {
    }

    public static ApiRequestParameter parse(String jsonStr, String accurateParameters, String likeParameters) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)API_RSA_PRIVATEKEY)) {
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        String encryptParam = HouMaYcslApiRequestParser.getEncryptParam((String)jsonStr);
        String params = HouMaYcslApiRequestParser.decryptParseByPrivateKey((String)API_RSA_PRIVATEKEY, (String)encryptParam);
        Map parameterMap = HouMaYcslApiRequestParser.convertToMap((String)params);
        HouMaYcslApiRequestParser.checkParameters((Map)parameterMap);
        ApiRequestParameter requestParameter = HouMaYcslApiRequestParser.parse((Map)parameterMap);
        if (StringUtils.isNotBlank((CharSequence)accurateParameters)) {
            requestParameter.setAccurateParameters(accurateParameters);
        }
        if (StringUtils.isNotBlank((CharSequence)likeParameters)) {
            requestParameter.setLikeParameters(likeParameters);
        }
        return requestParameter;
    }

    public static String parseByPrivateKey(String encryptPatameter) {
        if (StringUtils.isBlank((CharSequence)encryptPatameter)) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)API_RSA_PRIVATEKEY)) {
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        String encryptParam = HouMaYcslApiRequestParser.getEncryptParam((String)encryptPatameter);
        return HouMaYcslApiRequestParser.decryptParseByPrivateKey((String)API_RSA_PRIVATEKEY, (String)encryptParam);
    }

    public static String parse(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)API_RSA_PRIVATEKEY)) {
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        String encryptParam = HouMaYcslApiRequestParser.getEncryptParam((String)jsonStr);
        return HouMaYcslApiRequestParser.decryptParseByPrivateKey((String)API_RSA_PRIVATEKEY, (String)encryptParam);
    }

    public static void checkParameters(Map<String, Object> parameterMap) {
        long timeout;
        if (parameterMap == null || parameterMap.size() == 0 || !parameterMap.containsKey("timestamp")) {
            throw new OpenApiException("\u53c2\u6570\u975e\u6cd5\uff0c\u672a\u5305\u542btimestamp\u4fe1\u606f\uff01");
        }
        long timestamp = Long.parseLong(String.valueOf(parameterMap.get("timestamp")));
        long concurrentTime = System.currentTimeMillis();
        long l = timeout = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{REQUEST_TIME_OUT}) ? Long.parseLong(REQUEST_TIME_OUT) : 3000000L;
        if (concurrentTime - timestamp > timeout) {
            throw new OpenApiException("\u8bf7\u6c42\u94fe\u63a5\u8d85\u65f6\uff01");
        }
    }

    private static String getEncryptParam(String jsonStr) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map objectMap = (Map)mapper.readValue(jsonStr, Map.class);
            if (objectMap == null || objectMap.size() == 0 || !objectMap.containsKey("encryptParam")) {
                throw new OpenApiException("\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return (String)objectMap.get("encryptParam");
        }
        catch (IOException e) {
            throw new OpenApiException("\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\uff01" + e.getMessage());
        }
    }

    private static ApiRequestParameter parse(Map<String, Object> parameterMap) {
        ApiRequestParameter requestParameter = new ApiRequestParameter();
        Field[] fields = requestParameter.getClass().getDeclaredFields();
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            for (Field field : fields) {
                if (!field.getName().equals(key)) continue;
                field.setAccessible(true);
                try {
                    field.set(requestParameter, value);
                }
                catch (IllegalAccessException e) {
                    throw new OpenApiException("\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                }
            }
        }
        return requestParameter;
    }

    public static Map<String, Object> convertToMap(String params) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (Map)mapper.readValue(params, Map.class);
        }
        catch (IOException e) {
            throw new OpenApiException("\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\uff01" + e.getMessage());
        }
    }

    private static String decryptParseByPrivateKey(String privateKey, String encryptParam) {
        String res = HmaRsaUtil.decryptByPrivateKey((String)privateKey, (String)encryptParam);
        try {
            return URLDecoder.decode(res, "UTF-8");
        }
        catch (Exception e) {
            throw new OpenApiException("\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\u83b7\u53d6\u6b63\u786e\u7684private key\uff01");
        }
    }

    public static BdcxxDTO parseBdcxx(String encryptBdcxx) {
        if (StringUtils.isBlank((CharSequence)encryptBdcxx)) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u975e\u6cd5\uff0c\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)API_RSA_PRIVATEKEY)) {
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        String encryptParam = HouMaYcslApiRequestParser.getEncryptParam((String)encryptBdcxx);
        String params = HouMaYcslApiRequestParser.decryptParseByPrivateKey((String)API_RSA_PRIVATEKEY, (String)encryptParam);
        JSONObject object = JSON.parseObject((String)params);
        long timestamp = Long.parseLong(object.get((Object)"timestamp").toString());
        BdcxxDTO bdcxxDTO = (BdcxxDTO)JSON.parseObject((String)String.valueOf(object.get((Object)"bdcxx")), BdcxxDTO.class);
        if (bdcxxDTO != null) {
            long timeout;
            long concurrentTime = System.currentTimeMillis();
            long l = timeout = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{REQUEST_TIME_OUT}) ? Long.parseLong(REQUEST_TIME_OUT) : 3000000L;
            if (concurrentTime - timestamp > timeout) {
                throw new OpenApiException("\u8bf7\u6c42\u94fe\u63a5\u8d85\u65f6\uff01");
            }
        }
        return bdcxxDTO;
    }
}

