/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import cn.gtmap.estateplat.server.utils.ConfigUtils;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.utils.DateUtils;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtils {
    private static Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    private CommonUtils() {
    }

    public static final synchronized String formatLsh(Integer lsh) {
        String slbhPattern = ConfigUtils.getSlbhLshPattern();
        DecimalFormat df = StringUtils.isNotBlank((CharSequence)slbhPattern) ? new DecimalFormat(slbhPattern) : new DecimalFormat("0000");
        return df.format(lsh);
    }

    public static synchronized String formatSlbh(Date slsj, String lsh) {
        return DateUtils.formatTime((Date)slsj, (FastDateFormat)Constants.SLBH_DATE_FORMAT) + lsh;
    }

    public static String validateFiledIsNull(Object object, String[] validateFiledArr) {
        if (validateFiledArr == null || validateFiledArr.length == 0) {
            return null;
        }
        if (object == null) {
            return validateFiledArr[0];
        }
        Field[] filedList = object.getClass().getDeclaredFields();
        for (int i = 0; i < validateFiledArr.length; ++i) {
            String fieldValue = CommonUtils.getNullField((Object)object, (String)validateFiledArr[i], (Field[])filedList);
            if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
            return fieldValue;
        }
        return null;
    }

    private static String getNullField(Object object, String cs2, Field[] filedList) {
        for (Field field : filedList) {
            field.setAccessible(true);
            try {
                if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)cs2)) break;
                if (field.get(object) != null) continue;
                return cs2;
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
            }
        }
        return null;
    }

    public static String getCurrentDateStr(DateTimeFormatter dateTimeFormatter) {
        return new DateTime().toString(dateTimeFormatter);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString("yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static String format(Date date, String formatter) {
        if (date == null) {
            return "";
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString(formatter);
    }

    public static String format(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return date;
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString("yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static Date formatStringDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        DateTimeFormatter simpleDateFormat = DateTimeFormat.forPattern((String)"yyyy\u5e74MM\u6708dd\u65e5");
        return simpleDateFormat.parseDateTime(date).toDate();
    }

    public static Date getCurrentDate() {
        return new DateTime().toDate();
    }

    public static int getCurrentYear() {
        return new DateTime().getYear();
    }
}

