/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.OpenApiResponse;
import cn.gtmap.estateplat.server.core.model.ycsl.ResultEntity;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.enums.ApiResponseCodeEnum;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import cn.gtmap.estateplat.utils.CommonUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenApiResponseServiceImpl
implements OpenApiResponseService {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String[] needZdMcFields = new String[0];
    private String[] needDzMcFields = new String[]{"lcdm"};
    private String[] needDzDmFields = new String[]{"lcdm", "qlrlb"};
    private String loggerRule = "\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fc7\u6ee4\u540e\u7684\u8fd4\u56de\u7ed3\u679c\uff1a{}";

    public Object getExceptionResponse(String message) {
        OpenApiResponse openApiResponse = new OpenApiResponse();
        openApiResponse.setCode(ApiResponseCodeEnum.RESPONSE_CODE_ERROR.getDm());
        openApiResponse.setMsg(message);
        return openApiResponse;
    }

    public <T> List<T> parseResult(List<ResultEntity> resultEntityList, String responseFields, String dzjg) {
        if (CollectionUtils.isEmpty(resultEntityList)) {
            return new ArrayList();
        }
        if (StringUtils.isBlank((CharSequence)responseFields)) {
            return resultEntityList;
        }
        ArrayList<Map> result = new ArrayList<Map>();
        String[] responseFieldArr = StringUtils.split((String)responseFields, (String)",");
        for (ResultEntity resultEntity : resultEntityList) {
            result.add(this.parse(resultEntity, responseFieldArr, dzjg));
        }
        return result;
    }

    private Map<String, Object> parse(ResultEntity resultEntity, String[] responseFieldArr, String dzjg) {
        Field[] fields = resultEntity.getClass().getDeclaredFields();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < responseFieldArr.length; ++i) {
            for (Field field : fields) {
                field.setAccessible(true);
                try {
                    if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)responseFieldArr[i])) continue;
                    result.put(responseFieldArr[i], this.getFieldValue(resultEntity, responseFieldArr[i], field, dzjg));
                }
                catch (IllegalAccessException e) {
                    this.logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private Object getFieldValue(ResultEntity resultEntity, String fieldName, Field field, String dzjg) throws IllegalAccessException {
        String dzbs = "dz_" + fieldName;
        Object value = CommonUtil.indexOfStrs((String[])this.needZdMcFields, (String)fieldName) ? this.bdcZdGlService.convertDmToMc(fieldName, field.get(resultEntity)) : (CommonUtil.indexOfStrs((String[])this.needDzDmFields, (String)fieldName) ? this.bdcZdGlService.getDsfDzDm(field.get(resultEntity), dzbs, dzjg) : (CommonUtil.indexOfStrs((String[])this.needDzMcFields, (String)fieldName) ? this.bdcZdGlService.getDsfDzMc(field.get(resultEntity), dzbs, dzjg) : field.get(resultEntity)));
        return value;
    }

    public OpenApiResponse response(List<Object> resultList, ApiRequestParameter param) {
        this.logger.info(this.loggerRule, (Object)param, resultList);
        OpenApiResponse response = new OpenApiResponse();
        response.setMsg(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getMc());
        response.setCode(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getDm());
        response.setData(resultList);
        return response;
    }

    public OpenApiResponse response(List<Object> resultList, ApiRequestParameter param, String message) {
        this.logger.info(this.loggerRule, (Object)param, resultList);
        OpenApiResponse response = new OpenApiResponse();
        response.setMsg(message);
        response.setCode(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getDm());
        response.setData(resultList);
        return response;
    }

    public <T> OpenApiResponse response(T result) {
        OpenApiResponse response = new OpenApiResponse();
        response.setMsg(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getMc());
        response.setCode(ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS.getDm());
        response.setData(result);
        return response;
    }

    public <T> OpenApiResponse response(T result, String code, String msg) {
        OpenApiResponse response = new OpenApiResponse();
        response.setMsg(msg);
        response.setCode(code);
        response.setData(result);
        return response;
    }
}

