/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.server.core.exception.ConfigNotFoundException;
import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import cn.gtmap.estateplat.server.enums.ZdDzjgEnums;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestService;
import cn.gtmap.estateplat.server.utils.HmaRsaUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OpenApiRequestServiceImpl
implements OpenApiRequestService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SXSTYC_PRIVATEKEY = AppConfig.getProperty((String)"hma.st.ycsl.private.key");
    private static final String SXSTYC_USERID = AppConfig.getProperty((String)"hma.st.ycsl.request.user.id");

    public String request(String url, String parametes, String jgbs) {
        if (StringUtils.isBlank((String)url)) {
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (StringUtils.isBlank((String)parametes)) {
            throw new ParamsValidException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (StringUtils.equals((String)jgbs, (String)ZdDzjgEnums.DZJG_SXYCSL.getDzjg())) {
            return this.requestSxstyc(url, parametes);
        }
        return null;
    }

    private String requestSxstyc(String url, String parametes) {
        if (StringUtils.isBlank((String)SXSTYC_PRIVATEKEY)) {
            this.logger.error("\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u914d\u7f6e\uff1ahma.st.ycsl.private.key");
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (StringUtils.isBlank((String)SXSTYC_USERID)) {
            this.logger.error("\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u914d\u7f6e\uff1ahma.st.ycsl.request.user.id");
            throw new ConfigNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.logger.info("{},\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)parametes);
        try {
            URLEncoder.encode(parametes, "UTF-8");
            String encryptparam = HmaRsaUtil.encryptByPrivateKey((String)SXSTYC_PRIVATEKEY, (String)parametes);
            HashMap<String, String> encryptEntity = new HashMap<String, String>(1);
            encryptEntity.put("encryptParam", encryptparam);
            StringEntity body = new StringEntity(JSON.toJSONString(encryptEntity), "UTF-8");
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpPost http = new HttpPost(url);
            http.addHeader("X-Gisq-Rsa-UserId", SXSTYC_USERID);
            http.setEntity((HttpEntity)body);
            http.setHeader("Content-type", "application/json;charset=utf-8");
            HttpResponse response = null;
            response = httpclient.execute((HttpUriRequest)http);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream in = entity.getContent();
                byte[] data = OpenApiRequestServiceImpl.transformInputstream((InputStream)in);
                return new String(data, "UTF-8");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
        }
        return null;
    }

    private static byte[] transformInputstream(InputStream input) throws IOException {
        byte[] byt = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = 0;
        b = input.read();
        while (b != -1) {
            baos.write(b);
            b = input.read();
        }
        byt = baos.toByteArray();
        return byt;
    }
}

