/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcXtCheckinfo;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.exception.ParameterNotFoundException;
import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.BdcDataDTO;
import cn.gtmap.estateplat.server.core.model.ycsl.dto.BdcXmxxDTO;
import cn.gtmap.estateplat.server.core.service.BdcXtCheckinfoService;
import cn.gtmap.estateplat.server.core.service.ExamineCheckInfoService;
import cn.gtmap.estateplat.server.core.service.check.BdcSqlxForceValidateService;
import cn.gtmap.estateplat.server.service.ProjectCheckInfoService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestParamCheckService;
import cn.gtmap.estateplat.server.utils.InterfaceCodeBeanFactory;
import cn.gtmap.estateplat.server.utils.ReadXmlProps;
import cn.gtmap.estateplat.service.examine.BdcExamineService;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenApiRequestParamCheckServiceImpl
implements OpenApiRequestParamCheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ExamineCheckInfoService examineCheckInfoService;
    @Autowired
    private BdcExamineService bdcExamineService;
    @Autowired
    Set<BdcSqlxForceValidateService> bdcSqlxForceValidateServices;
    @Autowired
    private ProjectCheckInfoService projectCheckInfoService;
    @Autowired
    private BdcXtCheckinfoService bdcXtCheckinfoService;

    public <T> void validateFiledIsNull(T param, String params) {
        if (param == null || StringUtils.isBlank((CharSequence)params)) {
            throw new ParameterNotFoundException("\u67e5\u8be2\u8bf7\u6c42\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] validateFiledArr = StringUtils.split((String)params, (String)",");
        Field[] fieldList = param.getClass().getDeclaredFields();
        for (int i = 0; i < validateFiledArr.length; ++i) {
            String fieldValue = this.getNullField(param, validateFiledArr[i], fieldList);
            if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
            throw new ParameterNotFoundException("\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570" + fieldValue + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public <T> void validateFiledAllNull(T param, String params) {
        if (param == null || StringUtils.isBlank((CharSequence)params)) {
            throw new ParameterNotFoundException("\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] validateFiledArr = StringUtils.split((String)params, (String)",");
        Field[] fieldList = param.getClass().getDeclaredFields();
        ArrayList nullList = Lists.newArrayList();
        for (int i = 0; i < validateFiledArr.length; ++i) {
            String fieldValue = this.getNotNullField(param, validateFiledArr[i], fieldList);
            if (!StringUtils.isBlank((CharSequence)fieldValue)) continue;
            nullList.add(fieldValue);
        }
        if (CollectionUtils.size((Object)nullList) == validateFiledArr.length) {
            throw new ParameterNotFoundException("\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        }
    }

    public void validateFiled(ApiRequestParameter param) {
        if (StringUtils.isNotBlank((CharSequence)param.getAccurateParameters())) {
            this.validateFiledIsNull((Object)param, param.getAccurateParameters());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getLikeParameters())) {
            this.validateFiledAllNull((Object)param, param.getLikeParameters());
        }
    }

    public void checkBdcxx(BdcXmxxDTO bdcXmxxDTO) {
        List unExamineSqlx = ReadXmlProps.getUnExamineSqlxDm();
        String sqlx = bdcXmxxDTO.getSqlx();
        String wdid = bdcXmxxDTO.getWdid();
        Project project = new Project();
        project.setSqlx(sqlx);
        project.setWorkFlowDefId(wdid);
        List bdcDataDTOList = bdcXmxxDTO.getBdcDataDTOList();
        if (CollectionUtils.isNotEmpty((Collection)bdcDataDTOList)) {
            for (BdcDataDTO bdcDataDTO : bdcDataDTOList) {
                this.getProjectFromBdcDataDTO(bdcDataDTO, project);
                this.checkCf(unExamineSqlx, sqlx, project);
                this.checkConfigValidate(project);
            }
        }
    }

    private void checkConfigValidate(Project project) {
        Example example = new Example(BdcXtCheckinfo.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getSqlx()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getQllx()})) {
            List resultList;
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank((CharSequence)project.getSqlx())) {
                criteria.andEqualTo("sqlxdm", (Object)project.getSqlx());
            }
            if (StringUtils.isNotBlank((CharSequence)project.getQllx())) {
                criteria.andEqualTo("qllxdm", (Object)project.getQllx());
            }
            criteria.andNotEqualNvlTo("checkType", (Object)"2", (Object)"0");
            BdcSqlxForceValidateService bdcSqlxForceValidateService = (BdcSqlxForceValidateService)InterfaceCodeBeanFactory.getBean((Set)this.bdcSqlxForceValidateServices, (String)project.getSqlx());
            if (bdcSqlxForceValidateService != null && CollectionUtils.isNotEmpty((Collection)(resultList = bdcSqlxForceValidateService.forceValidateXm(project)))) {
                throw new ParamsValidException(((Map)resultList.get(0)).get("checkMsg").toString());
            }
            List list = this.bdcXtCheckinfoService.getXtCheckinfo(example);
            List resultListTemp = this.projectCheckInfoService.checkXm(list, project);
            if (CollectionUtils.isNotEmpty((Collection)resultListTemp)) {
                throw new ParamsValidException(((Map)resultListTemp.get(0)).get("checkMsg").toString());
            }
        }
    }

    private void checkCf(List<String> unExamineSqlx, String sqlx, Project project) {
        Map examineMap;
        List bdcExamineParamList = null;
        if (CollectionUtils.isEmpty(unExamineSqlx) || CollectionUtils.isNotEmpty(unExamineSqlx) && !unExamineSqlx.contains(sqlx)) {
            bdcExamineParamList = this.examineCheckInfoService.getBdcExamineParam("", project);
        }
        StringBuilder msg = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)bdcExamineParamList) && (examineMap = this.bdcExamineService.performExamine(bdcExamineParamList, project.getWiid())) != null && examineMap.containsKey("info") && examineMap.get("info") != null) {
            msg.append("\u5b58\u5728\u67e5\u5c01\uff0c").append("\u9650\u5236\u6587\u53f7\uff1a").append(examineMap.get("xzwh").toString());
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ParamsValidException(msg.toString());
        }
    }

    private void getProjectFromBdcDataDTO(BdcDataDTO bdcDataDTO, Project project) {
        BdcXm bdcXm = bdcDataDTO.getBdcXm();
        BdcXmRel bdcXmRel = bdcDataDTO.getBdcXmRel();
        BdcBdcdy bdcBdcdy = bdcDataDTO.getBdcBdcdy();
        if (bdcXm != null) {
            project.setQllx(bdcXm.getQllx());
            project.setDjlx(bdcXm.getDjlx());
            project.setYbdcqzh(bdcXm.getYbdcqzh());
            project.setBdclx(bdcXm.getBdclx());
            project.setDwdm(bdcXm.getDwdm());
        }
        if (bdcXmRel != null) {
            project.setYqlid(bdcXmRel.getYqlid());
            if ("3".equals(bdcXmRel.getYdjxmly())) {
                project.setGdproid(bdcXmRel.getYproid());
            } else {
                project.setYxmid(bdcXmRel.getYproid());
            }
        }
        if (bdcBdcdy != null) {
            project.setBdcdyh(bdcBdcdy.getBdcdyh());
            project.setZdzhh(StringUtils.substring((String)bdcBdcdy.getBdcdyh(), (int)0, (int)19));
        }
    }

    private String getNullField(Object object, String cs2, Field[] filedList) {
        for (Field field : filedList) {
            field.setAccessible(true);
            try {
                if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)cs2)) continue;
                if (field.get(object) != null && !StringUtils.isBlank((CharSequence)String.valueOf(field.get(object)))) break;
                return cs2;
            }
            catch (IllegalAccessException e) {
                this.logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private String getNotNullField(Object object, String cs2, Field[] filedList) {
        for (Field field : filedList) {
            field.setAccessible(true);
            try {
                if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)cs2) || field.get(object) == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(field.get(object)))) continue;
                return cs2;
            }
            catch (IllegalAccessException e) {
                this.logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
            }
        }
        return null;
    }
}

