/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.server.core.exception.OpenApiException;
import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.enums.ZdDzjgEnums;
import cn.gtmap.estateplat.server.service.rest.OpenApiCommonService;
import cn.gtmap.estateplat.server.service.rest.OpenApiQueryQlrxxService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestParamCheckService;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import cn.gtmap.estateplat.server.utils.HouMaYcslApiRequestParser;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenApiQueryQlrxxServiceImpl
implements OpenApiQueryQlrxxService {
    @Autowired
    private OpenApiRequestParamCheckService openApiRequestParamCheckService;
    @Autowired
    private OpenApiResponseService openApiResponseService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private OpenApiCommonService openApiCommonService;

    public String queryObligees(ApiRequestParameter apiRequestParameter) {
        try {
            this.openApiRequestParamCheckService.validateFiled(apiRequestParameter);
            List qlbsmList = apiRequestParameter.getQlbsms();
            Map qlbsmMap = this.openApiCommonService.parseBsms(qlbsmList);
            if (qlbsmMap.size() == 0) {
                return JSON.toJSONString((Object)this.openApiResponseService.response(null, apiRequestParameter), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            }
            HashMap param = new HashMap(1);
            ArrayList totalResultEntityList = new ArrayList();
            for (Map.Entry entry : qlbsmMap.entrySet()) {
                param.put("qlbsms", entry.getValue());
                List resultEntityList = this.bdcQlrService.queryObligees(param, (String)entry.getKey());
                if (!CollectionUtils.isNotEmpty((Collection)resultEntityList)) continue;
                totalResultEntityList.addAll(resultEntityList);
            }
            String responseFields = "ywh,qlrlb,qlbm,qlbsm,sxh,qlrmc,zjzl,zjh,sshy,xb,gddh,yddh,dz,yb,gzdw,dzyj,qlrlx,qlmj,qlbl,gyfs,gyqk,qlrfrmc,qlrfrdh,qlrfrzjzl,qlrfrzjh,qlrfrlxdz,qlrdlrmc,qlrdlrdh,qlrdlrzjzl,qlrdlrzjh,qlrdljg,qlrdljgdm,bz,qxdm,gxsj,gj,qllxmc,csny,sfzzp";
            List resultList = this.openApiResponseService.parseResult(totalResultEntityList, responseFields, ZdDzjgEnums.DZJG_SXYCSL.getDzjg());
            return JSON.toJSONString((Object)this.openApiResponseService.response(resultList, apiRequestParameter), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (OpenApiException e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    public String queryFwtc(String decryptParam) {
        Map parameter = HouMaYcslApiRequestParser.convertToMap((String)decryptParam);
        HouMaYcslApiRequestParser.checkParameters((Map)parameter);
        String qlrxx = JSON.toJSONString(parameter.get("qlrxx"));
        if (StringUtils.isBlank((String)qlrxx)) {
            throw new ParamsValidException("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25\uff0c\u6743\u5229\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List qlrxxs = JSONObject.parseArray((String)qlrxx, Map.class);
        if (CollectionUtils.isEmpty((Collection)qlrxxs)) {
            throw new ParamsValidException("\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0c\u672a\u89e3\u6790\u51fa\u53ef\u7528\u6743\u5229\u4eba\u4fe1\u606f\uff01");
        }
        ArrayList resultList = new ArrayList();
        for (Map map : qlrxxs) {
            List fwxx = this.bdcQlrService.queryFwtc(map);
            if (!CollectionUtils.isNotEmpty((Collection)fwxx)) continue;
            resultList.addAll(fwxx);
        }
        return JSON.toJSONString((Object)this.openApiResponseService.response(resultList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }
}

