/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.rest.impl;

import cn.gtmap.estateplat.model.server.core.BdcXtYh;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import cn.gtmap.estateplat.server.core.exception.ParamsValidException;
import cn.gtmap.estateplat.server.core.model.rest.BdcZsbhBO;
import cn.gtmap.estateplat.server.core.model.ycsl.OpenApiResponse;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.enums.ApiResponseCodeEnum;
import cn.gtmap.estateplat.server.service.BdczsBhService;
import cn.gtmap.estateplat.server.service.rest.OpenApiBhxxService;
import cn.gtmap.estateplat.server.service.rest.OpenApiRequestParamCheckService;
import cn.gtmap.estateplat.server.service.rest.OpenApiResponseService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.opengis.parameter.ParameterNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiBhxxServiceImpl
implements OpenApiBhxxService {
    @Autowired
    private BdczsBhService bdczsBhService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private OpenApiResponseService openApiResponseService;
    @Autowired
    private OpenApiRequestParamCheckService openApiRequestParamCheckService;

    public String queryZsbh(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new ParamsValidException("\u8bf7\u6c42\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject obj = JSONObject.parseObject((String)param);
        if (!obj.containsKey((Object)"yhmc") || obj.get((Object)"yhmc") == null) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", "yhmc");
        }
        String yhmc = obj.get((Object)"yhmc").toString();
        BdcXtYh bdcXtYh = this.bdcZdGlService.getBdcXtYh(yhmc);
        if (bdcXtYh == null) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u94f6\u884c\u540d\u79f0\u5728\u767b\u8bb0\u7cfb\u7edf\u672a\u5907\u6848", "yhmc");
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("yhmc", yhmc);
        params.put("zslx", "zms");
        params.put("syqk", "0");
        List zsbhList = this.bdczsBhService.queryBdcZsbh(params);
        String msg = "";
        List data = null;
        if (CollectionUtils.isEmpty((Collection)zsbhList)) {
            msg = "\u672a\u67e5\u8be2\u5230\u5df2\u5206\u914d\u7684\u672a\u4f7f\u7528\u8bc1\u4e66\u7f16\u53f7";
        } else {
            data = this.consistData(zsbhList, bdcXtYh);
            msg = "\u64cd\u4f5c\u6210\u529f";
        }
        OpenApiResponse openApiResponse = this.openApiResponseService.response((Object)data, ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS_T.getDm(), msg);
        return JSON.toJSONString((Object)openApiResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public String updateSyqk(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new ParamsValidException("\u8bf7\u6c42\u53c2\u6570\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject obj = JSONObject.parseObject((String)param);
        if (!obj.containsKey((Object)"zsbhs") || obj.get((Object)"zsbhs") == null) {
            throw new ParameterNotFoundException("\u8bf7\u6c42\u53c2\u6570\u8bc1\u4e66\u7f16\u53f7\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", "zsbhs");
        }
        List zsbhList = JSONObject.parseArray((String)obj.get((Object)"zsbhs").toString(), BdcZsbhBO.class);
        if (CollectionUtils.isEmpty((Collection)zsbhList)) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse("\u672a\u89e3\u6790\u5230\u6b63\u786e\u7684\u8bc1\u4e66\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570"));
        }
        try {
            this.validateZsbhSyqk(zsbhList);
            this.bdczsBhService.updateSyqk(zsbhList);
            return JSON.toJSONString((Object)this.openApiResponseService.response(null, ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS_T.getDm(), ApiResponseCodeEnum.RESPONSE_CODE_SUCCESS_T.getMc()));
        }
        catch (Exception e) {
            return JSON.toJSONString((Object)this.openApiResponseService.getExceptionResponse(e.getMessage()));
        }
    }

    private void validateZsbhSyqk(List<BdcZsbhBO> zsbhBOList) {
        for (BdcZsbhBO zsbhBO : zsbhBOList) {
            this.openApiRequestParamCheckService.validateFiledIsNull((Object)zsbhBO, "yhmc,zjzl,zjh,zslx,syqk,zsbh,lqr,lqrbs");
            if (StringUtils.equals((CharSequence)zsbhBO.getSyqk(), (CharSequence)"2") || !StringUtils.isBlank((CharSequence)zsbhBO.getYwbsm())) continue;
            throw new ParamsValidException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1aywbsm");
        }
        HashMap<String, String> param = new HashMap<String, String>(4);
        for (BdcZsbhBO bdcZsbhBO : zsbhBOList) {
            param.put("yhmc", bdcZsbhBO.getYhmc());
            param.put("zsbh", bdcZsbhBO.getZsbh());
            param.put("zslx", bdcZsbhBO.getZslx());
            List zsbhList = this.bdczsBhService.queryBdcZsbh(param);
            if (!CollectionUtils.isEmpty((Collection)zsbhList)) continue;
            throw new ParamsValidException("\u8bc1\u4e66\u7f16\u53f7\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u8bc1\u4e66\u7f16\u53f7\uff1a" + bdcZsbhBO.getZsbh());
        }
    }

    private List<Map> consistData(List<BdcZsbh> zsbhList, BdcXtYh bdcXtYh) {
        ArrayList bhs = Lists.newArrayList();
        for (BdcZsbh bdcZsbh : zsbhList) {
            HashMap<String, String> bh = new HashMap<String, String>(6);
            bh.put("yhmc", bdcXtYh.getYhmc());
            bh.put("zjzl", bdcXtYh.getZjlx());
            bh.put("zjh", bdcXtYh.getZjbh());
            bh.put("zsbh", bdcZsbh.getZsbh());
            bhs.add(bh);
        }
        return bhs;
    }
}

