/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.server.core.service.BdcSjxxService;
import cn.gtmap.estateplat.server.service.BdcXmFjclService;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.service.FileService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcXmFjclServiceImpl
implements BdcXmFjclService {
    @Autowired
    private BdcSjxxService bdcSjxxService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private PlatformUtil platformUtil;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean uploadFjcl(InputStream file, String proid, String cllx, String clmc) {
        try {
            BdcSjcl bdcSjcl = this.saveBdcSjcl(proid, cllx, clmc);
            this.uploadFileCenter(file, bdcSjcl, proid);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() + "_" + e.toString(), (Throwable)e);
            return false;
        }
    }

    private void uploadFileCenter(InputStream file, BdcSjcl bdcSjcl, String proid) throws IOException {
        String clmc;
        if (file == null || bdcSjcl == null) {
            return;
        }
        FileService fileService = PlatformUtil.getFileService();
        Integer projectFileId = this.platformUtil.getProjectFileId(proid);
        Integer clNodeId = this.platformUtil.createFileFolderByclmcAndnodeid(projectFileId, clmc = bdcSjcl.getClmc(), null);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(clNodeId)})) {
            bdcSjcl.setWjzxid(clNodeId);
        }
        this.entityMapper.saveOrUpdate((Object)bdcSjcl, (Object)bdcSjcl.getSjclid());
        String clmcend = "";
        clmcend = StringUtils.endsWithIgnoreCase((CharSequence)clmc, (CharSequence)".pdf") ? clmc : clmc + ".pdf";
        fileService.uploadFile(file, clNodeId, clmcend, null, true, true);
    }

    private BdcSjcl saveBdcSjcl(String proid, String cllx, String clmc) {
        if (StringUtils.isBlank((CharSequence)proid) || StringUtils.isBlank((CharSequence)cllx) || StringUtils.isBlank((CharSequence)clmc)) {
            return null;
        }
        BdcSjxx bdcSjxx = this.bdcSjxxService.queryBdcSjxxByProid(proid);
        if (bdcSjxx == null) {
            return null;
        }
        Example example = new Example(BdcSjcl.class);
        example.createCriteria().andEqualTo("clmc", (Object)clmc).andEqualTo("sjxxid", (Object)bdcSjxx.getSjxxid());
        List bdcSjclList = this.entityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)bdcSjclList)) {
            return (BdcSjcl)bdcSjclList.get(0);
        }
        BdcSjcl bdcSjcl = new BdcSjcl();
        bdcSjcl.setSjclid(UUIDGenerator.generate18());
        bdcSjcl.setCllx(cllx);
        bdcSjcl.setClmc(clmc);
        bdcSjcl.setSjxxid(bdcSjxx.getSjxxid());
        bdcSjcl.setFs(1);
        bdcSjcl.setMrfs(Integer.valueOf(1));
        this.entityMapper.insertSelective((Object)bdcSjcl);
        return bdcSjcl;
    }
}

