/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.service.core.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.Xmxx;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcSjdService;
import cn.gtmap.estateplat.server.core.service.BdcSpxxService;
import cn.gtmap.estateplat.server.core.service.BdcXmRelService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcXmZsRelService;
import cn.gtmap.estateplat.server.core.service.BdcZsQlrRelService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.BdcZsbhService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.QllxService;
import cn.gtmap.estateplat.server.service.core.ProjectGeneralService;
import cn.gtmap.estateplat.utils.DateUtils;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectGeneralServiceImpl
implements ProjectGeneralService {
    @Autowired
    protected SysUserService sysUserService;
    @Autowired
    private BdcZsbhService bdcZsbhService;
    @Autowired
    private NodeService FileCenterNodeServiceImpl;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private BdcXmRelService bdcXmRelService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private BdcSjdService bdcSjdService;
    @Autowired
    private BdcXmZsRelService bdcXmZsRelService;
    @Autowired
    private BdcZsQlrRelService bdcZsQlrRelService;
    @Autowired
    private BdcZsService bdcZsService;

    @Transactional
    public void createProject(Xmxx xmxx) {
        Project project = null;
        if (xmxx instanceof Project) {
            project = (Project)xmxx;
        }
        if (project != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project.getUserId()})) {
            PfUserVo userVo = this.sysUserService.getUserVo(project.getUserId());
            String userName = "";
            if (userVo != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userVo.getUserName()})) {
                userName = userVo.getUserName();
            }
            BdcXm bdcXm = this.bdcXmService.creatBdcXm(project.getProid(), userName, project.getWorkFlowDefId(), project.getWiid());
            this.bdcSjdService.createSjxxByBdcxm(bdcXm);
        }
    }

    @Transactional
    public void deleteProject(String wiid) {
        List bdcXmList = this.bdcXmService.getBdcXmListByWiid(wiid);
        if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                String proid = bdcXm.getProid();
                this.delZsbh(proid);
                this.deleteBdcXmxx(bdcXm);
                this.bdcXmService.delBdcXmByProid(proid);
                this.delProjectNode(proid);
            }
        }
    }

    private void deleteBdcXmxx(BdcXm bdcXm) {
        List bdcXmzsRelList;
        String proid = bdcXm.getProid();
        this.bdcXmRelService.delBdcXmRelByProid(proid);
        List bdcSjxxList = this.bdcSjdService.queryBdcSjdByWiid(bdcXm.getWiid());
        if (bdcSjxxList != null && CollectionUtils.isNotEmpty((Collection)bdcSjxxList)) {
            for (BdcSjxx bdcSjxx : bdcSjxxList) {
                this.bdcSjdService.delSjclListBySjxxid(bdcSjxx.getSjxxid());
                this.bdcSjdService.delBdcSjxxBySjxxid(bdcSjxx.getSjxxid());
            }
        }
        this.bdcSpxxService.delBdcSpxxByProid(proid);
        List bdcQlrList = this.bdcQlrService.queryBdcQlrYwrByProid(proid);
        if (bdcQlrList != null && CollectionUtils.isNotEmpty((Collection)bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                this.bdcZsQlrRelService.delBdcZsQlrRelByQlrid(bdcQlr.getQlrid());
                this.bdcQlrService.delBdcQlrByQlrid(bdcQlr.getQlrid());
            }
        }
        if ((bdcXmzsRelList = this.bdcXmZsRelService.queryBdcXmZsRelByProid(proid)) != null && CollectionUtils.isNotEmpty((Collection)bdcXmzsRelList)) {
            for (BdcXmzsRel bdcXmzsRel : bdcXmzsRelList) {
                this.bdcXmZsRelService.delBdcXmZsRelByXmzsgxid(bdcXmzsRel.getXmzsgxid());
                this.bdcZsService.delBdcZsByZsid(bdcXmzsRel.getZsid());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bdcXm.getBdcdyid())) {
            List bdcXmListTemp = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bdcdyid", bdcXm.getBdcdyid());
            bdcXmListTemp = this.bdcXmService.andEqualQueryBdcXm(map);
            if (bdcXmListTemp != null && bdcXmListTemp.size() == 1) {
                this.bdcdyService.delBdcdyById(bdcXm.getBdcdyid());
            }
        }
    }

    private void delZsbh(String proid) {
        List zsList = this.bdcZsService.queryBdcZsByProid(proid);
        if (CollectionUtils.isNotEmpty((Collection)zsList)) {
            for (BdcZs bdcZs : zsList) {
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("zsid", bdcZs.getZsid());
                List bdcZsbhList = this.bdcZsbhService.getBdcZsBhListByBhfw(map);
                if (!CollectionUtils.isNotEmpty((Collection)bdcZsbhList)) continue;
                for (BdcZsbh bdcZsbh : bdcZsbhList) {
                    bdcZsbh.setLqr("");
                    bdcZsbh.setLqrid("");
                    bdcZsbh.setZsid("");
                    bdcZsbh.setSyqk("0");
                    this.entityMapper.saveOrUpdate((Object)bdcZsbh, (Object)bdcZsbh.getZsbhid());
                }
            }
        }
    }

    private void delProjectNode(String proid) {
        Space space = this.FileCenterNodeServiceImpl.getWorkSpace("WORK_FLOW_STUFF");
        Node tempNode = this.FileCenterNodeServiceImpl.getNode(space.getId(), proid, true);
        this.FileCenterNodeServiceImpl.remove(tempNode.getId());
    }

    @Transactional
    public void updateProjectStatus(String wiid) {
        List bdcXmList = this.bdcXmService.getBdcXmListByWiid(wiid);
        if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                bdcXm.setBjsj(DateUtils.now());
                bdcXm.setXmzt("1");
                this.entityMapper.saveOrUpdate((Object)bdcXm, (Object)bdcXm.getProid());
                this.qllxService.endQllxZt(bdcXm);
            }
        }
    }

    public void generateProjectZs(String wiid) {
        List bdcXmList = this.bdcXmService.getBdcXmListByWiid(wiid);
        if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                List bdcQlrList;
                List list = this.bdcZsService.creatBdcqz(bdcXm, bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(bdcXm.getProid()));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    this.bdcZsQlrRelService.creatBdcZsQlrRel(bdcXm, list, bdcQlrList);
                    this.bdcXmZsRelService.creatBdcXmZsRel(list, bdcXm.getProid());
                    continue;
                }
                throw new AppException(2004, new Object[0]);
            }
        }
    }
}

