/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.UpdateCxBdcdyZtService;
import cn.gtmap.estateplat.server.utils.ConfigUtils;
import cn.gtmap.estateplat.service.config.QlztService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateCxBdcdyZtServiceImpl
implements UpdateCxBdcdyZtService {
    @Autowired
    private QlztService qlztService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcdyService bdcdyService;
    private static final String PARAMETER_BDCDYHLIST = "bdcdyhList";
    private static final String PARAMETER_BDCLX = "bdclx";

    public Boolean updateBdcdyZtByProid(String proid) {
        Boolean result = false;
        if (ConfigUtils.isPushBdcdjTodcsjgl() && StringUtils.isNotBlank((CharSequence)proid)) {
            Map map = this.getMapByProid(proid);
            result = this.updateBdcdyZtByMap(map);
        }
        return result;
    }

    private Boolean updateBdcdyZtByMap(Map<String, Object> map) {
        Boolean result = false;
        if (map != null && null != map.get(PARAMETER_BDCDYHLIST)) {
            List bdcdyhList = (List)map.get(PARAMETER_BDCDYHLIST);
            String bdclx = (String)map.get(PARAMETER_BDCLX);
            if (CollectionUtils.isNotEmpty((Collection)bdcdyhList)) {
                this.qlztService.updateBdcdyZtByBdcdyh(bdcdyhList, bdclx);
                result = true;
            }
        }
        return result;
    }

    private Map<String, Object> getMapByProid(String proid) {
        ExtendedProperties map = new ExtendedProperties();
        String bdclx = "";
        bdclx = this.bdcdyService.getBdclxByPorid(proid);
        List bdcXmList = this.getBdcXmListByProid(proid);
        List bdcdyhList = this.getBdcdyhList(bdcXmList);
        if (CollectionUtils.isNotEmpty((Collection)bdcdyhList)) {
            map.put(PARAMETER_BDCDYHLIST, bdcdyhList);
        }
        if (StringUtils.isNotBlank((CharSequence)bdclx)) {
            map.put(PARAMETER_BDCLX, bdclx);
        }
        return map;
    }

    private List<String> getBdcdyhList(List<BdcXm> bdcXmList) {
        LinkedList<String> bdcdyhList = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm bdcxm : bdcXmList) {
                String bdcdyh;
                if (null == bdcxm || !StringUtils.isNotBlank((CharSequence)bdcxm.getProid()) || !StringUtils.isNotBlank((CharSequence)(bdcdyh = this.bdcdyService.getBdcdyhByProid(bdcxm.getProid()))) || bdcdyhList.contains(bdcdyh)) continue;
                bdcdyhList.add(bdcdyh);
            }
        }
        return bdcdyhList;
    }

    private List<BdcXm> getBdcXmListByProid(String proid) {
        List<Object> bdcXmList = new ArrayList<BdcXm>();
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null) {
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getWiid())) {
                bdcXmList = this.bdcXmService.getBdcXmListByWiid(bdcXm.getWiid());
            } else {
                bdcXmList.add(bdcXm);
            }
        }
        return bdcXmList;
    }
}

