/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.server.core.model.OntBdcXm;
import cn.gtmap.estateplat.server.core.model.OntQlr;
import cn.gtmap.estateplat.server.core.service.OntService;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.server.utils.ZipFileUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.service.FileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OntServiceImpl
implements OntService {
    @Autowired
    HttpSession session;
    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    private EntityMapper entityMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void createAllFileFolder(String proid, String wiid, String filePath) {
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            Example example = new Example(BdcSjxx.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("wiid", (Object)wiid);
            criteria.andEqualTo("proid", (Object)proid);
            List bdcSjxxList = this.entityMapper.selectByExample(example);
            for (BdcSjxx bdcSjxx : bdcSjxxList) {
                example = new Example(BdcSjcl.class);
                example.createCriteria().andEqualTo("sjxxid", (Object)bdcSjxx.getSjxxid());
                List bdcSjclList = this.entityMapper.selectByExample(example);
                if (bdcSjclList == null) {
                    this.createFileFolder(proid, filePath);
                    continue;
                }
                if (CollectionUtils.isNotEmpty((Collection)example.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)example.getOredCriteria().get(0)).getAllCriteria())) {
                    this.entityMapper.deleteByExample(example);
                }
                this.createFileFolder(proid, filePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileFolder(String proid, String filePath) {
        Integer projectFileId = null;
        try {
            if (proid != null && !"".equals(proid)) {
                projectFileId = this.platformUtil.getProjectFileId(proid);
                File root = new File(filePath);
                if (root.exists()) {
                    File[] files = root.listFiles();
                    this.initOntSjcl(proid, files);
                    if (files != null && files.length != 0) {
                        for (File file : files) {
                            if (!file.isDirectory()) continue;
                            Integer parentId = this.platformUtil.createFileFolderByclmc(projectFileId, file.getName());
                            FileInputStream inputStream = null;
                            FileService fileService = PlatformUtil.getFileService();
                            if (!file.isDirectory() || file.listFiles() == null) continue;
                            for (File tempFile : file.listFiles()) {
                                try {
                                    inputStream = new FileInputStream(tempFile);
                                    fileService.uploadFile((InputStream)inputStream, parentId, tempFile.getName(), null, true, false);
                                }
                                catch (IOException e) {
                                    this.logger.error(e.getMessage());
                                }
                                finally {
                                    if (inputStream != null) {
                                        ((InputStream)inputStream).close();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
    }

    public List<Object> getExcelAsFile(String file, String proid, HttpSession session) {
        FileInputStream ins = null;
        Workbook wb = null;
        File tempFile = new File(file);
        ArrayList<Object> list = new ArrayList<Object>();
        if (tempFile.exists()) {
            try {
                ins = new FileInputStream(tempFile);
                wb = WorkbookFactory.create((InputStream)ins);
                ((InputStream)ins).close();
                block8: for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                    Sheet sheet = wb.getSheetAt(i);
                    Row topRow = sheet.getRow(0);
                    int lineNum = topRow.getLastCellNum();
                    Iterator rowIterator = sheet.rowIterator();
                    switch (i) {
                        case 0: {
                            int j = 0;
                            ArrayList<OntBdcXm> ontBdcXmList = new ArrayList<OntBdcXm>();
                            while (rowIterator.hasNext()) {
                                Row row = (Row)rowIterator.next();
                                row.getLastCellNum();
                                if (j == 0) {
                                    ++j;
                                    continue;
                                }
                                OntBdcXm ontBdcxm = new OntBdcXm(row, ++lineNum, proid);
                                ontBdcXmList.add(ontBdcxm);
                                list.add(ontBdcxm);
                            }
                            session.setAttribute("ontBdcXm_" + proid, ontBdcXmList);
                            continue block8;
                        }
                        case 1: {
                            int k = 0;
                            ArrayList<OntQlr> ontQlrList = new ArrayList<OntQlr>();
                            while (rowIterator.hasNext()) {
                                Row row = (Row)rowIterator.next();
                                row.getLastCellNum();
                                if (k == 0) {
                                    ++k;
                                    continue;
                                }
                                OntQlr ontQlr = new OntQlr(row, lineNum += 2, "qlr", proid);
                                ontQlrList.add(ontQlr);
                                list.add(ontQlr);
                            }
                            session.setAttribute("ontQlr_" + proid, ontQlrList);
                            continue block8;
                        }
                        case 2: {
                            int l = 0;
                            ArrayList<OntQlr> ontYwrList = new ArrayList<OntQlr>();
                            while (rowIterator.hasNext()) {
                                Row row = (Row)rowIterator.next();
                                row.getLastCellNum();
                                if (l == 0) {
                                    ++l;
                                    continue;
                                }
                                OntQlr ontQlr = new OntQlr(row, lineNum + 2, "ywr", proid);
                                ontYwrList.add(ontQlr);
                                list.add(ontQlr);
                            }
                            session.setAttribute("ontYwr_" + proid, ontYwrList);
                            continue block8;
                        }
                        default: {
                            this.logger.info("\u9ed8\u8ba4\u503c");
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
            }
            catch (InvalidFormatException e) {
                this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public void initOntFile(String wiid, String proid) {
        String tempFilePath = null;
        File[] files = (File[])this.session.getAttribute("ontFiles_" + proid);
        if (files != null && files.length != 0) {
            for (File tempFile : files) {
                if (!tempFile.isDirectory()) continue;
                String filePath = tempFile.getAbsolutePath();
                filePath = ZipFileUtil.appendFileSeparator((String)filePath);
                this.createAllFileFolder(proid, wiid, filePath);
                tempFilePath = tempFile.getAbsolutePath();
            }
        }
        try {
            FileUtils.deleteDirectory((File)new File(tempFilePath));
        }
        catch (IOException e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
    }

    private void initOntSjcl(String proid, File[] files) {
        ArrayList<BdcSjcl> sjclList = new ArrayList<BdcSjcl>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            Example example = new Example(BdcSjxx.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("proid", (Object)proid);
            List sjxxList = this.entityMapper.selectByExample(example);
            for (BdcSjxx bdcSjxx : sjxxList) {
                BdcSjcl bdcSjCl = new BdcSjcl();
                bdcSjCl.setSjclid(UUIDGenerator.generate());
                bdcSjCl.setSjxxid(bdcSjxx.getSjxxid());
                bdcSjCl.setClmc(files[i].getName());
                bdcSjCl.setFs(files[i].listFiles().length);
                bdcSjCl.setYs(Integer.valueOf(files[i].listFiles().length));
                bdcSjCl.setXh(i);
                bdcSjCl.setCllx("3");
                sjclList.add(bdcSjCl);
            }
        }
        this.entityMapper.batchSaveSelective(sjclList);
    }
}

