/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.GdQlr;
import cn.gtmap.estateplat.server.core.mapper.server.GdQlrMapper;
import cn.gtmap.estateplat.server.core.model.wqxt.WqxtGdQlr;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.core.service.GdQlrService;
import cn.gtmap.estateplat.server.enums.BdcZdTableEnum;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GdQlrServiceImpl
implements GdQlrService {
    @Autowired
    EntityMapper entryMapper;
    @Autowired
    GdQlrMapper gdQlrMapper;
    @Autowired
    private BdcZdGlService bdcZdGlService;

    public List<GdQlr> queryGdQlrs(String qlid, String qlrlx) {
        ArrayList list = null;
        List listtemp = null;
        if (StringUtils.isNotBlank((CharSequence)qlid)) {
            String[] qlidarr;
            for (String qlidtemp : qlidarr = qlid.split(",")) {
                Example qlrTemp = new Example(GdQlr.class);
                Example.Criteria criteria = qlrTemp.createCriteria();
                criteria.andEqualTo("qlid", (Object)qlidtemp);
                if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                    criteria.andEqualTo("qlrlx", (Object)qlrlx);
                }
                if (CollectionUtils.isNotEmpty((Collection)qlrTemp.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)qlrTemp.getOredCriteria().get(0)).getAllCriteria())) {
                    listtemp = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
                }
                list = new ArrayList();
                if (!CollectionUtils.isNotEmpty(listtemp)) continue;
                list.addAll(listtemp);
            }
        }
        return list;
    }

    public List<BdcQlr> readGdQlrs(List<GdQlr> gdQlrs) {
        ArrayList<BdcQlr> bdcQlrList = new ArrayList<BdcQlr>();
        if (gdQlrs != null && CollectionUtils.isNotEmpty(gdQlrs)) {
            for (GdQlr gdQlr : gdQlrs) {
                BdcQlr bdcQlr = null;
                if (gdQlr == null) continue;
                bdcQlr = new BdcQlr();
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                if (gdQlr.getSxh() == 0) {
                    bdcQlr.setSxh(2);
                } else {
                    bdcQlr.setSxh(gdQlr.getSxh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                    bdcQlr.setQlrmc(gdQlr.getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrzjh())) {
                    bdcQlr.setQlrzjh(gdQlr.getQlrzjh());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrsfzjzl())) {
                    bdcQlr.setQlrsfzjzl(gdQlr.getQlrsfzjzl());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrlx())) {
                    bdcQlr.setQlrlx(gdQlr.getQlrlx());
                }
                if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlrxz())) {
                    bdcQlr.setQlrxz(gdQlr.getQlrxz());
                }
                if (gdQlrs.size() > 1) {
                    if (StringUtils.isNotBlank((CharSequence)gdQlr.getQlbl())) {
                        Double qlbl = CommonUtil.getGybl((String)gdQlr.getQlbl());
                        if (qlbl != null) {
                            if (StringUtils.equals((CharSequence)AppConfig.getProperty((String)"bdcqlr.qlbl.fs"), (CharSequence)"true")) {
                                bdcQlr.setQlbl(gdQlr.getQlbl());
                            } else {
                                bdcQlr.setQlbl(qlbl.toString());
                            }
                            if (CommonUtil.getGybl((String)gdQlr.getQlbl()) < 1.0) {
                                bdcQlr.setGyfs("2");
                            }
                        }
                    } else {
                        bdcQlr.setGyfs("1");
                    }
                } else {
                    bdcQlr.setGyfs("0");
                }
                bdcQlrList.add(bdcQlr);
            }
        }
        return bdcQlrList;
    }

    public void delGdQlrByQlid(String qlid) {
        this.gdQlrMapper.delGdQlrByQlid(qlid);
    }

    @Transactional(readOnly=true)
    public List<GdQlr> queryGdQlrListByProid(String qlid, String qlrlx) {
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)qlid) && StringUtils.isNotBlank((CharSequence)qlrlx)) {
            Example qlrTemp = new Example(GdQlr.class);
            Example.Criteria criteria = qlrTemp.createCriteria();
            criteria.andEqualTo("qlid", (Object)qlid).andEqualTo("qlrlx", (Object)qlrlx);
            list = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
        }
        return list;
    }

    public String getGdQlrsByProid(String proid, String qlrlx) {
        StringBuilder qlrs = new StringBuilder();
        List gdQlrList = this.queryGdQlrListByProid(proid, qlrlx);
        if (CollectionUtils.isNotEmpty((Collection)gdQlrList)) {
            if (CollectionUtils.size((Object)gdQlrList) > 3) {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs.append(",").append(gdQlr.getQlr());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs.append(gdQlr.getQlr());
                }
                if (StringUtils.isNotBlank((CharSequence)qlrs)) {
                    qlrs.append("\u7b49");
                }
            } else {
                for (GdQlr gdQlr : gdQlrList) {
                    if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                        qlrs.append(",").append(gdQlr.getQlr());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                    qlrs.append(gdQlr.getQlr());
                }
            }
        }
        return qlrs.toString();
    }

    public List<GdQlr> queryGdQlrsByQlr(String qlr, String qlrlx) {
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)qlr)) {
            Example qlrTemp = new Example(GdQlr.class);
            Example.Criteria criteria = qlrTemp.createCriteria();
            criteria.andLike("qlr", "%" + qlr + "%");
            if (StringUtils.isNotBlank((CharSequence)qlrlx)) {
                criteria.andEqualTo("qlrlx", (Object)qlrlx);
            }
            if (CollectionUtils.isNotEmpty((Collection)qlrTemp.getOredCriteria()) && CollectionUtils.isNotEmpty((Collection)((Example.Criteria)qlrTemp.getOredCriteria().get(0)).getAllCriteria())) {
                list = this.entryMapper.selectByExample(GdQlr.class, (Object)qlrTemp);
            }
        }
        return list;
    }

    @Transactional(readOnly=true)
    public String getGdQlrsByQlid(String qlid, String qlrlx) {
        StringBuilder qlrs = new StringBuilder();
        List gdQlrList = this.queryGdQlrs(qlid, qlrlx);
        if (CollectionUtils.isNotEmpty((Collection)gdQlrList)) {
            for (GdQlr gdQlr : gdQlrList) {
                if (StringUtils.isNotBlank((CharSequence)qlrs) && StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) {
                    qlrs.append(",").append(gdQlr.getQlr());
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)gdQlr.getQlr())) continue;
                qlrs.append(gdQlr.getQlr());
            }
            if (CollectionUtils.size((Object)gdQlrList) > 3 && StringUtils.isNotBlank((CharSequence)qlrs)) {
                qlrs.append("\u7b49");
            }
        }
        return qlrs.toString();
    }

    public String combinationQlr(List<GdQlr> gdQlrList) {
        StringBuilder qlr = new StringBuilder();
        if (gdQlrList != null && CollectionUtils.isNotEmpty(gdQlrList)) {
            for (GdQlr gdQlr : gdQlrList) {
                if (StringUtils.isBlank((CharSequence)qlr)) {
                    qlr.append(gdQlr.getQlr());
                    continue;
                }
                qlr.append("\u3001").append(gdQlr.getQlr());
            }
        }
        return qlr.toString();
    }

    public ArrayList<GdQlr> queryGdQlr(Map map) {
        if (MapUtils.isEmpty((Map)map)) {
            return Lists.newArrayList();
        }
        return this.gdQlrMapper.queryGdQlr(map);
    }

    public WqxtGdQlr getWqxtGdQlrFromGdQlr(GdQlr qlr) {
        WqxtGdQlr wqxtGdQlr = new WqxtGdQlr();
        wqxtGdQlr.setQlrid(qlr.getQlrid());
        wqxtGdQlr.setQlr(qlr.getQlr());
        wqxtGdQlr.setQlrsfzjzl(qlr.getQlrsfzjzl());
        wqxtGdQlr.setQlrzjh(qlr.getQlrzjh());
        wqxtGdQlr.setQlid(qlr.getQlid());
        wqxtGdQlr.setQlrlx(qlr.getQlrlx());
        wqxtGdQlr.setQlrxz(qlr.getQlrxz());
        wqxtGdQlr.setQlbl(qlr.getQlbl());
        wqxtGdQlr.setProid(qlr.getProid());
        wqxtGdQlr.setSfczr(qlr.getSfczr());
        wqxtGdQlr.setCqzh(qlr.getCqzh());
        wqxtGdQlr.setSxh(qlr.getSxh());
        wqxtGdQlr.setQlrdlr(qlr.getQlrdlr());
        wqxtGdQlr.setQlrdlrzjlx(qlr.getQlrdlrzjlx());
        wqxtGdQlr.setQzysxlh(qlr.getQzysxlh());
        wqxtGdQlr.setCqzhjc(qlr.getCqzhjc());
        wqxtGdQlr.setQlrtxdz(qlr.getQlrtxdz());
        wqxtGdQlr.setQlryb(qlr.getQlryb());
        if (StringUtils.isNotEmpty((CharSequence)wqxtGdQlr.getQlrsfzjzl())) {
            wqxtGdQlr.setQlrsfzjzlmc(this.bdcZdGlService.getBdcZdMc(wqxtGdQlr.getQlrsfzjzl(), BdcZdTableEnum.BDC_ZD_ZJLX.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)wqxtGdQlr.getQlrxz())) {
            if (StringUtils.equals((CharSequence)wqxtGdQlr.getQlrxz(), (CharSequence)"99")) {
                wqxtGdQlr.setQlrxzmc("\u5176\u4ed6");
            } else if (StringUtils.equals((CharSequence)wqxtGdQlr.getQlrxz(), (CharSequence)"1")) {
                wqxtGdQlr.setQlrxzmc("\u4e2a\u4eba");
            } else if (StringUtils.equals((CharSequence)wqxtGdQlr.getQlrxz(), (CharSequence)"2")) {
                wqxtGdQlr.setQlrxzmc("\u4f01\u4e1a");
            } else if (StringUtils.equals((CharSequence)wqxtGdQlr.getQlrxz(), (CharSequence)"3")) {
                wqxtGdQlr.setQlrxzmc("\u4e8b\u4e1a\u5355\u4f4d");
            } else if (StringUtils.equals((CharSequence)wqxtGdQlr.getQlrxz(), (CharSequence)"4")) {
                wqxtGdQlr.setQlrxzmc("\u56fd\u5bb6\u673a\u5173");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)wqxtGdQlr.getQlrdlrzjlx())) {
            wqxtGdQlr.setQlrdlrzjzlmc(this.bdcZdGlService.getBdcZdMc(wqxtGdQlr.getQlrdlrzjlx(), BdcZdTableEnum.BDC_ZD_ZJLX.getName()));
        }
        return wqxtGdQlr;
    }
}

