/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.server.core.service.CadastralService;
import com.gtis.config.AppConfig;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CadastralServiceImpl
implements CadastralService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void syncQlrForCadastral(String wiid) {
        String syncUrl = AppConfig.getProperty((String)"sync.url");
        String syncCadastral = AppConfig.getProperty((String)"isSyncCadastral");
        if (StringUtils.isNotBlank((CharSequence)wiid) && Boolean.parseBoolean(syncCadastral)) {
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = connectionManager.getParams();
            params.setSoTimeout(30000);
            params.setConnectionTimeout(5000);
            params.setMaxTotalConnections(256);
            params.setDefaultMaxConnectionsPerHost(32);
            HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            String syncFwQlrUrl = syncUrl + "/&Operator=TBFWInfo&WIID=" + wiid + "&TBYT=0&TBZL=0&TBMJ=0/";
            PostMethod postMethod = new PostMethod(syncFwQlrUrl);
            try {
                httpClient.executeMethod((HttpMethod)postMethod);
                String responseXml = postMethod.getResponseBodyAsString();
                this.logger.info(responseXml);
                postMethod.releaseConnection();
            }
            catch (IOException e) {
                this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

