/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.print.DataToPrintXml;
import cn.gtmap.estateplat.model.server.print.XmlData;
import cn.gtmap.estateplat.server.core.mapper.server.BdcZsPrintMapper;
import cn.gtmap.estateplat.server.core.model.MulDataToPrintXml;
import cn.gtmap.estateplat.server.core.model.PageXml;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZsPrintService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcZsPrintServiceImpl
implements BdcZsPrintService {
    @Autowired
    private BdcZsPrintMapper bdcZsPrintMapper;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcXmService bdcXmService;
    private final Logger logger = LoggerFactory.getLogger(BdcZsPrintServiceImpl.class);

    public MulDataToPrintXml getMulZsPrintXml(String zslx, String serverUrl, Map<String, String> proidAndzsid) throws UnsupportedEncodingException {
        MulDataToPrintXml muldataToPrintXml = new MulDataToPrintXml();
        ArrayList pageXmlList = Lists.newArrayList();
        PageXml pageXml = null;
        for (Map.Entry<String, String> proidAndZsidEntry : proidAndzsid.entrySet()) {
            String proid = String.valueOf(proidAndZsidEntry.getKey());
            String zsid = String.valueOf(proidAndZsidEntry.getValue());
            String bz = "";
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("proid", proid);
            map.put("zsid", zsid);
            List hashMapList = StringUtils.equals((CharSequence)zslx, (CharSequence)"scdjxx") ? this.bdcZsPrintMapper.getZmdPrint(proid) : this.bdcZsPrintMapper.getZsPrint(map);
            BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
            if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getBh())) {
                bz = bdcXm.getBh();
            }
            pageXml = this.createMulPageXmlData(hashMapList, zslx, bz, serverUrl);
            pageXmlList.add(pageXml);
        }
        muldataToPrintXml.setPage((List)pageXmlList);
        return muldataToPrintXml;
    }

    public PageXml createMulPageXmlData(List<HashMap> hashMapList, String zslx, String bz, String serverUrl) throws UnsupportedEncodingException {
        PageXml pageXml = new PageXml();
        ArrayList<XmlData> dataSourceDataList = new ArrayList<XmlData>();
        if (CollectionUtils.isNotEmpty(hashMapList)) {
            this.createDataList(hashMapList, dataSourceDataList);
        } else {
            this.createEmpty(zslx, dataSourceDataList);
        }
        dataSourceDataList.add(this.getEwm(bz, serverUrl));
        pageXml.setData(dataSourceDataList);
        return pageXml;
    }

    public void createEmpty(String zslx, List<XmlData> dataSourceDataList) {
        String[] zsname = new String[]{"SQSJC", "NF", "SZSXQC", "ZHLSH", "GYQK", "ZL", "BDCDYH", "QLLX", "QLXZ", "YT", "MJ", "SYQX", "QLQTZK", "FJ", "QFDW", "BDCQZH", "ZSBH"};
        if (StringUtils.equals((CharSequence)zslx, (CharSequence)"zs")) {
            for (int i = 0; i != zsname.length; ++i) {
                dataSourceDataList.add(this.zzData(zsname[i], "String", ""));
            }
        } else {
            dataSourceDataList.add(this.getData("", "\u5e74"));
            dataSourceDataList.add(this.getData("", "\u6708"));
            dataSourceDataList.add(this.getData("", "\u65e5"));
        }
    }

    public void createDataList(List<HashMap> hashMapList, List<XmlData> dataSourceDataList) {
        String qfdw = AppConfig.getProperty((String)"qfdw");
        for (HashMap hashMap : hashMapList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                XmlData dataSourceData;
                if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue(entry.getKey()), (CharSequence)"FZRQ")) {
                    Date date = null;
                    date = StringUtils.isBlank((CharSequence)CommonUtil.formatEmptyValue(entry.getValue())) ? new Date() : CalendarUtil.formatDate((String)CommonUtil.formatEmptyValue(entry.getValue()));
                    String dateStr = CalendarUtil.sdf_China.format(date);
                    dataSourceDataList.add(this.zzData("YEAR", "String", String.valueOf(CalendarUtil.getDateYear((Date)date))));
                    dataSourceDataList.add(this.zzData("MONTH", "String", String.valueOf(CalendarUtil.getDateMonth((Date)date))));
                    dataSourceDataList.add(this.zzData("DAY", "String", String.valueOf(CalendarUtil.getDateDay((Date)date))));
                    dataSourceData = this.zzData("FZRQ", "String", dateStr);
                    dataSourceDataList.add(dataSourceData);
                    continue;
                }
                dataSourceData = this.zzData(CommonUtil.formatEmptyValue(entry.getKey()), "String", CommonUtil.formatEmptyValue(entry.getValue()));
                dataSourceDataList.add(dataSourceData);
            }
        }
        dataSourceDataList.add(this.zzData("QFDW", "String", qfdw));
    }

    public DataToPrintXml getZsPrintXml(String proid, String zslx, String serverUrl, String zsid) throws UnsupportedEncodingException {
        DataToPrintXml dataToPrintXml = new DataToPrintXml();
        String bz = "";
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("proid", proid);
        map.put("zsid", zsid);
        List hashMapList = StringUtils.equals((CharSequence)zslx, (CharSequence)"scdjxx") ? this.bdcZsPrintMapper.getZmdPrint(proid) : this.bdcZsPrintMapper.getZsPrint(map);
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getBh())) {
            bz = bdcXm.getBh();
        }
        Integer bdcdyCount = 0;
        if (StringUtils.isNotBlank((CharSequence)zsid)) {
            bdcdyCount = this.bdcZsService.getBdcdyCountByZsid(zsid);
        }
        List dataSourceDataList = this.createPrintXmlData(hashMapList, bdcdyCount, zslx);
        dataSourceDataList.add(this.getEwm(bz, serverUrl));
        dataToPrintXml.setData(dataSourceDataList);
        return dataToPrintXml;
    }

    public List<XmlData> createPrintXmlData(List<HashMap> hashMapList, Integer bdcdyCount, String zslx) {
        ArrayList<XmlData> dataSourceDataList = new ArrayList<XmlData>();
        String[] zsname = new String[]{"SQSJC", "NF", "SZSXQC", "ZHLSH", "GYQK", "ZL", "BDCDYH", "QLLX", "QLXZ", "YT", "MJ", "SYQX", "QLQTZK", "FJ", "QFDW", "BDCQZH", "ZSBH"};
        if (CollectionUtils.isNotEmpty(hashMapList)) {
            this.createPrintXmlList(hashMapList, dataSourceDataList, bdcdyCount);
        } else if (StringUtils.equals((CharSequence)zslx, (CharSequence)"zs")) {
            for (int i = 0; i != zsname.length; ++i) {
                dataSourceDataList.add(this.zzData(zsname[i], "String", ""));
            }
        } else {
            dataSourceDataList.add(this.getData("", "\u5e74"));
            dataSourceDataList.add(this.getData("", "\u6708"));
            dataSourceDataList.add(this.getData("", "\u65e5"));
        }
        return dataSourceDataList;
    }

    public void createPrintXmlList(List<HashMap> hashMapList, List<XmlData> dataSourceDataList, Integer bdcdyCount) {
        XmlData dataSourceData = null;
        String qfdw = AppConfig.getProperty((String)"qfdw");
        for (HashMap hashMap : hashMapList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue(entry.getKey()), (CharSequence)"FZRQ")) {
                    Date date = null;
                    date = StringUtils.isBlank((CharSequence)CommonUtil.formatEmptyValue(entry.getValue())) ? new Date() : CalendarUtil.formatDate((String)CommonUtil.formatEmptyValue(entry.getValue()));
                    String dateStr = CalendarUtil.sdf_China.format(date);
                    dataSourceDataList.add(this.zzData("YEAR", "String", String.valueOf(CalendarUtil.getDateYear((Date)date))));
                    dataSourceDataList.add(this.zzData("MONTH", "String", String.valueOf(CalendarUtil.getDateMonth((Date)date))));
                    dataSourceDataList.add(this.zzData("DAY", "String", String.valueOf(CalendarUtil.getDateDay((Date)date))));
                    dataSourceData = this.zzData("FZRQ", "String", dateStr);
                    dataSourceDataList.add(dataSourceData);
                    continue;
                }
                if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue(entry.getKey()), (CharSequence)"ZL") && bdcdyCount > 1) {
                    dataSourceData = this.zzData("ZL", "String", CommonUtil.formatEmptyValue(entry.getValue()) + "\u7b49");
                    dataSourceDataList.add(dataSourceData);
                    continue;
                }
                if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue(entry.getKey()), (CharSequence)"BDCDYH") && bdcdyCount > 1) {
                    dataSourceData = this.zzData("BDCDYH", "String", CommonUtil.formatEmptyValue(entry.getValue()) + "\u7b49");
                    dataSourceDataList.add(dataSourceData);
                    continue;
                }
                dataSourceData = this.zzData(CommonUtil.formatEmptyValue(entry.getKey()), "String", CommonUtil.formatEmptyValue(entry.getValue()));
                dataSourceDataList.add(dataSourceData);
            }
        }
        dataSourceDataList.add(this.zzData("QFDW", "String", qfdw));
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public XmlData getEwm(String bz, String serverUrl) throws UnsupportedEncodingException {
        XmlData xmlData = null;
        if (StringUtils.isNotBlank((CharSequence)bz)) {
            String s = URLEncoder.encode(bz, "utf-8");
            xmlData = this.zzData("EWM", "Image", serverUrl + "/bdcPrint/getEwm?bz=" + s + "&random=" + Math.random());
        }
        return xmlData;
    }

    public XmlData getData(String fzrq, String sjgs) {
        String date = "";
        date = StringUtils.isBlank((CharSequence)fzrq) ? CalendarUtil.sdf.format(CalendarUtil.getCurDate()) : CalendarUtil.sdf.format(CalendarUtil.formatDate((String)fzrq));
        String[] dates = date.split("-");
        XmlData xmlData = null;
        if (dates.length > 2) {
            xmlData = StringUtils.equals((CharSequence)sjgs, (CharSequence)"\u5e74") ? this.zzData("YEAR", "String", dates[0]) : (StringUtils.equals((CharSequence)sjgs, (CharSequence)"\u6708") ? this.zzData("MONTH", "String", dates[1]) : this.zzData("DAY", "String", dates[2]));
        }
        return xmlData;
    }

    public XmlData zzData(String name, String type, String value) {
        XmlData xmlData = new XmlData();
        xmlData.setName(name);
        xmlData.setType(type);
        xmlData.setValue(value);
        return xmlData;
    }

    public void reponseModalUrl(String hiddeMode, StringBuilder modalUrls, StringBuilder xmlUrls, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)modalUrls)) {
            StringBuilder sb = new StringBuilder();
            try (PrintWriter out = null;){
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.append("<frs>");
                if (StringUtils.indexOf((CharSequence)modalUrls, (CharSequence)",") > -1) {
                    String[] modalUrlList = modalUrls.toString().split(",");
                    String[] xmlUrlsList = xmlUrls.toString().split(",");
                    for (int i = 0; i < modalUrlList.length; ++i) {
                        sb.append("<fr url=\"eprt://v2|designMode=false|frURL=" + modalUrlList[i] + "|dataURL=" + xmlUrlsList[i] + "|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini|hiddeMode=" + hiddeMode + "\"/>");
                    }
                } else {
                    sb.append("<fr url=\"eprt://v2|designMode=false|frURL=" + modalUrls + "|dataURL=" + xmlUrls + "|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini|hiddeMode=true" + hiddeMode + "\"/>");
                }
                sb.append("</frs>");
                response.setContentType("text/xml;charset=utf-8");
                out = response.getWriter();
                out.write(sb.toString());
                out.flush();
            }
        }
    }
}

