/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSqlxQllxRel;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtCheckinfo;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.BdcXtLimitfield;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import cn.gtmap.estateplat.model.server.core.BdcXtOpinion;
import cn.gtmap.estateplat.model.server.core.BdcXtSjglRelation;
import cn.gtmap.estateplat.model.server.core.BdcXtSjglResource;
import cn.gtmap.estateplat.model.server.core.BdcZdLogController;
import cn.gtmap.estateplat.model.server.core.BdcZdTables;
import cn.gtmap.estateplat.server.core.mapper.server.BdcXtConfigMapper;
import cn.gtmap.estateplat.server.core.service.BdcXtConfigService;
import cn.gtmap.estateplat.server.core.service.BdcXtSjglRelationService;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BdcXtConfigServiceImpl
implements BdcXtConfigService {
    @Autowired
    public BdcXtConfigMapper bdcXtConfigMapper;
    @Autowired
    public EntityMapper entityMapper;
    @Autowired
    private BdcXtSjglRelationService bdcXtSjglRelationService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BdcXtConfig queryBdczsBhConfig(BdcXm bdcXm) {
        BdcXtConfig bdcXtConfig = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getDwdm())) {
            map.put("dwdm", bdcXm.getDwdm());
            Calendar calendar = Calendar.getInstance();
            map.put("nf", calendar.get(1) + "");
            bdcXtConfig = this.bdcXtConfigMapper.selectBdcXtConfig(map);
        }
        return bdcXtConfig;
    }

    public List<BdcSqlxQllxRel> getOthersBySqlx(String sqlx) {
        Example example = new Example(BdcSqlxQllxRel.class);
        example.createCriteria().andEqualTo("sqlxdm", (Object)sqlx);
        return this.entityMapper.selectByExample(example);
    }

    public void autoUpdateBdcXtConfig() {
        Calendar currTime = Calendar.getInstance();
        int year = currTime.get(1);
        Example example = new Example(BdcXtConfig.class);
        List bdcXtConfigList = this.entityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)bdcXtConfigList)) {
            int i = 1;
            for (BdcXtConfig bdcXtConfig : bdcXtConfigList) {
                if (!StringUtils.isNotBlank((CharSequence)bdcXtConfig.getNf()) || StringUtils.equals((CharSequence)bdcXtConfig.getNf(), (CharSequence)String.valueOf(year))) continue;
                bdcXtConfig.setNf(String.valueOf(year));
                this.entityMapper.updateByPrimaryKeySelective((Object)bdcXtConfig);
                this.logger.info("\u8de8\u5e74\u65f6\u5b9a\u65f6\u670d\u52a1\u66f4\u65b0bdc_xt_config\u8868\u5e74\u4efd\uff0c\u66f4\u65b0\u6210\u529f\uff1a\u5f53\u524d\u5e74\u4efd={}", (Object)year);
                this.logger.info("\u7b2c{}\u6761\uff0c\u5e74\u4efd={}\u66f4\u65b0\u6210\u529f", (Object)i, (Object)year);
                BdcXtLog bdcXtLog = new BdcXtLog();
                if (StringUtils.isBlank((CharSequence)bdcXtLog.getLogid())) {
                    bdcXtLog.setLogid(UUIDGenerator.generate18());
                }
                bdcXtLog.setCzrq(new Date());
                bdcXtLog.setController("\u7cfb\u7edf\u914d\u7f6e\u8868\u4fdd\u5b58\u65e5\u5fd7");
                HashMap jsonMap = new HashMap();
                HashMap<String, String> paramMap = new HashMap<String, String>(4);
                paramMap.put("dwdm", bdcXtConfig.getDwdm());
                paramMap.put("djjg", bdcXtConfig.getDjjg());
                paramMap.put("nf", bdcXtConfig.getNf());
                paramMap.put("szsxqc", bdcXtConfig.getSzsxqc());
                jsonMap.put("BdcXtConfig\u66f4\u65b0\u5e74\u4efd", paramMap);
                bdcXtLog.setParmjson(JSONObject.toJSONString(jsonMap));
                bdcXtLog.setReason("\u5b9a\u65f6\u670d\u52a1\uff1a\u8de8\u5e74\u65f6\u81ea\u52a8\u66f4\u65b0bdc_xt_config\u8868\u4e2d\u7684\u5e74\u4efd\u4e3a\u5f53\u524d\u5e74\u4efd");
                this.entityMapper.saveOrUpdate((Object)bdcXtLog, (Object)bdcXtLog.getLogid());
                ++i;
            }
        }
    }

    public void delOpinion(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
                this.entityMapper.deleteByPrimaryKey(BdcXtOpinion.class, (Object)id[i]);
            }
        }
    }

    public void saveOpinion(BdcXtOpinion bdcXtOpinion) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcXtOpinion.getOpinid()})) {
            this.entityMapper.updateByPrimaryKeyNull((Object)bdcXtOpinion);
        } else {
            bdcXtOpinion.setOpinid(UUIDGenerator.generate18());
            this.entityMapper.insertSelective((Object)bdcXtOpinion);
        }
    }

    public void delLimitFieldConfig(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
            this.entityMapper.deleteByPrimaryKey(BdcXtLimitfield.class, (Object)id[i]);
        }
    }

    public void saveLimitField(BdcXtLimitfield bdcXtLimitfield) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcXtLimitfield.getId()})) {
            this.entityMapper.updateByPrimaryKeyNull((Object)bdcXtLimitfield);
        } else {
            bdcXtLimitfield.setId(UUIDGenerator.generate18());
            this.entityMapper.insertSelective((Object)bdcXtLimitfield);
        }
    }

    public String delLimitTableConfig(String ids) {
        String result = "\u5220\u9664\u6210\u529f";
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
            Example example = new Example(BdcXtLimitfield.class);
            example.createCriteria().andEqualTo("tableId", (Object)id[i]);
            int count = this.entityMapper.countByExample(example);
            if (count > 0) {
                result = "\u6b64\u6570\u636e\u4e0e\u5176\u4ed6\u8868\u5173\u8054,\u65e0\u6cd5\u5220\u9664!";
                continue;
            }
            this.entityMapper.deleteByPrimaryKey(BdcZdTables.class, (Object)id[i]);
        }
        return result;
    }

    public void saveLimitTable(BdcZdTables bdcZdTables) {
        if (bdcZdTables != null) {
            bdcZdTables.setId(UUIDGenerator.generate18());
            this.entityMapper.insertSelective((Object)bdcZdTables);
        }
    }

    public void delLogConfig(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
                this.entityMapper.deleteByPrimaryKey(BdcZdLogController.class, (Object)id[i]);
            }
        }
    }

    public void saveSqlxQllxRel(BdcSqlxQllxRel bdcSqlxQllxRel) {
        if (bdcSqlxQllxRel != null) {
            String sqlx = bdcSqlxQllxRel.getSqlxdm();
            if (this.getOthersBySqlx(sqlx) != null) {
                BdcSqlxQllxRel oBdcSqlxQllxRel = (BdcSqlxQllxRel)this.getOthersBySqlx(sqlx).get(0);
                bdcSqlxQllxRel.setId(oBdcSqlxQllxRel.getId());
                this.entityMapper.updateByPrimaryKeyNull((Object)bdcSqlxQllxRel);
            } else {
                bdcSqlxQllxRel.setId(UUIDGenerator.generate18());
                this.entityMapper.insertSelective((Object)bdcSqlxQllxRel);
            }
        }
    }

    public void updateRelation(String id, Integer xh) {
        if (StringUtils.isNotBlank((CharSequence)id) && xh != null) {
            BdcXtSjglRelation bdcXtSjglRelation = (BdcXtSjglRelation)this.entityMapper.selectByPrimaryKey(BdcXtSjglRelation.class, (Object)id);
            bdcXtSjglRelation.setXh(xh);
            this.entityMapper.updateByPrimaryKeySelective((Object)bdcXtSjglRelation);
        }
    }

    public void addRelation(BdcXtSjglRelation bdcXtSjglRelation) {
        bdcXtSjglRelation.setRelationId(UUIDGenerator.generate18());
        Integer xh = this.bdcXtSjglRelationService.getMaxXh(bdcXtSjglRelation.getDjlxId());
        if (xh == null) {
            xh = 1;
        }
        bdcXtSjglRelation.setXh(xh);
        this.entityMapper.insertSelective((Object)bdcXtSjglRelation);
    }

    public void delRelation(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
            this.entityMapper.deleteByPrimaryKey(BdcXtSjglRelation.class, (Object)id[i]);
        }
    }

    public void delYz(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
            this.entityMapper.deleteByPrimaryKey(BdcXtCheckinfo.class, (Object)id[i]);
        }
    }

    public void delResource(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)id[i])) continue;
            this.entityMapper.deleteByPrimaryKey(BdcXtSjglResource.class, (Object)id[i]);
        }
    }
}

