/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcSllsh;
import cn.gtmap.estateplat.server.core.mapper.server.BdcSllshMapper;
import cn.gtmap.estateplat.server.core.service.BdcSllshService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.DateUtils;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcSllshServiceImpl
implements BdcSllshService {
    private static final FastDateFormat SLBH_DATE_MM_FORMAT = FastDateFormat.getInstance((String)"yyyyMM");
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcSllshMapper bdcSllshMapper;

    @Transactional
    public void saveBh(String slbhlsh) {
        if (StringUtils.isNotBlank((CharSequence)slbhlsh)) {
            HashMap map = Maps.newHashMap();
            map.put("cjsj", CalendarUtil.formatDateToString((Date)new Date()));
            List bdcSllshList = this.bdcSllshMapper.getBdcSllshList((Map)map);
            BdcSllsh bdcSllsh = null;
            if (CollectionUtils.isNotEmpty((Collection)bdcSllshList)) {
                bdcSllsh = (BdcSllsh)bdcSllshList.get(0);
                bdcSllsh.setSlbhlsh(slbhlsh);
            } else {
                bdcSllsh = new BdcSllsh();
                bdcSllsh.setBhid(UUIDGenerator.generate());
                bdcSllsh.setSlbhlsh(slbhlsh);
            }
            bdcSllsh.setCjsj(new Date());
            this.entityMapper.saveOrUpdate((Object)bdcSllsh, (Object)bdcSllsh.getBhid());
        }
    }

    @Transactional
    public void saveBh(String slbhlsh, String qh) {
        if (StringUtils.isNotBlank((CharSequence)slbhlsh) && StringUtils.isNotBlank((CharSequence)qh)) {
            HashMap map = Maps.newHashMap();
            map.put("cjyf", DateUtils.formatTime((Date)new Date(), (FastDateFormat)SLBH_DATE_MM_FORMAT));
            map.put("qh", qh);
            List bdcSllshList = this.bdcSllshMapper.getBdcSllshList((Map)map);
            BdcSllsh bdcSllsh = null;
            if (CollectionUtils.isNotEmpty((Collection)bdcSllshList)) {
                bdcSllsh = (BdcSllsh)bdcSllshList.get(0);
                bdcSllsh.setSlbhlsh(slbhlsh);
            } else {
                bdcSllsh = new BdcSllsh();
                bdcSllsh.setBhid(UUIDGenerator.generate());
                bdcSllsh.setQh(qh);
                bdcSllsh.setSlbhlsh(slbhlsh);
            }
            bdcSllsh.setCjsj(new Date());
            this.entityMapper.saveOrUpdate((Object)bdcSllsh, (Object)bdcSllsh.getBhid());
        }
    }

    @Transactional
    public Integer getSlbhLsh() {
        HashMap map = Maps.newHashMap();
        map.put("cjsj", CalendarUtil.formatDateToString((Date)new Date()));
        List bdcSllshList = this.bdcSllshMapper.getBdcSllshList((Map)map);
        if (CollectionUtils.isNotEmpty((Collection)bdcSllshList) && StringUtils.isNotBlank((CharSequence)((BdcSllsh)bdcSllshList.get(0)).getSlbhlsh())) {
            return Integer.parseInt(((BdcSllsh)bdcSllshList.get(0)).getSlbhlsh());
        }
        return null;
    }

    @Transactional
    public Integer getSlbhLsh(Map map) {
        List bdcSllshList = this.bdcSllshMapper.getBdcSllshList(map);
        if (CollectionUtils.isNotEmpty((Collection)bdcSllshList) && StringUtils.isNotBlank((CharSequence)((BdcSllsh)bdcSllshList.get(0)).getSlbhlsh())) {
            return Integer.parseInt(((BdcSllsh)bdcSllshList.get(0)).getSlbhlsh());
        }
        return null;
    }
}

