/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.mapper.server.BdcSjclMapper;
import cn.gtmap.estateplat.server.core.model.ycsl.bo.BdcMediaBO;
import cn.gtmap.estateplat.server.core.service.BdcSjclService;
import cn.gtmap.estateplat.server.utils.Base64Util;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import com.gtis.fileCenter.service.FileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSjclServiceImpl
implements BdcSjclService {
    @Autowired
    private BdcSjclMapper bdcSjclMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private PlatformUtil platformUtil;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<BdcSjcl> getBdcSjclListByProid(String proid) {
        return this.bdcSjclMapper.getSjclByproid(proid);
    }

    public void delBdcsjcl(String sjxxid, String clmc) {
        if (StringUtils.isNotBlank((CharSequence)sjxxid) && StringUtils.isNotBlank((CharSequence)clmc)) {
            Example example = new Example(BdcSjcl.class);
            example.createCriteria().andEqualTo("sjxxid", (Object)sjxxid).andEqualTo("clmc", (Object)clmc);
            this.entityMapper.deleteByExample(BdcSjcl.class, (Object)example);
        }
    }

    public void postBdcFjxx(List<BdcMediaBO> mediaBOList, BdcXm bdcXm) {
        if (CollectionUtils.isNotEmpty(mediaBOList)) {
            String clmc = mediaBOList.get(0).getDatumName();
            BdcSjcl bdcSjcl = this.getBdcSjcl(bdcXm.getProid(), clmc);
            if (bdcSjcl != null) {
                for (BdcMediaBO bdcMediaBO : mediaBOList) {
                    this.uploadFj(bdcSjcl, bdcMediaBO, bdcXm.getProid());
                }
            }
        }
    }

    private void uploadFj(BdcSjcl bdcSjcl, BdcMediaBO bdcMediaBO, String proid) {
        String clmc;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Util.decodeBase64StrToByte((String)bdcMediaBO.getPageContent().replace("data:image/jpeg;base64,", "")));
        FileService fileService = PlatformUtil.getFileService();
        Integer projectFileId = this.platformUtil.getProjectFileId(proid);
        Integer clNodeId = this.platformUtil.createFileFolderByclmcAndnodeid(projectFileId, clmc = bdcSjcl.getClmc(), null);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(clNodeId)})) {
            bdcSjcl.setWjzxid(clNodeId);
        }
        this.entityMapper.saveOrUpdate((Object)bdcSjcl, (Object)bdcSjcl.getSjclid());
        try {
            String clmcend = "";
            String clmctemp = bdcMediaBO.getName();
            clmcend = StringUtils.endsWithIgnoreCase((CharSequence)clmctemp, (CharSequence)".jpg") ? bdcMediaBO.getName() : bdcMediaBO.getName() + ".jpg";
            fileService.uploadFile((InputStream)inputStream, clNodeId, clmcend, null, false, true);
        }
        catch (Exception err) {
            this.logger.info("\u4e00\u7a97\u9644\u4ef6\u6750\u6599\u4e0a\u4f20\u9519\u8bef\uff1a{}", (Object)err.getMessage());
        }
    }

    private BdcSjcl getBdcSjcl(String proid, String clmc) {
        List bdcSjclList = this.bdcSjclMapper.getSjclByproid(proid);
        if (CollectionUtils.isNotEmpty((Collection)bdcSjclList) && StringUtils.isNotBlank((CharSequence)clmc)) {
            for (BdcSjcl bdcSjcl : bdcSjclList) {
                if (!StringUtils.equals((CharSequence)bdcSjcl.getClmc(), (CharSequence)clmc)) continue;
                return bdcSjcl;
            }
        }
        return null;
    }
}

