/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.Xmxx;
import cn.gtmap.estateplat.server.core.model.BdcSjClxx;
import cn.gtmap.estateplat.server.core.model.BdcSjJbxx;
import cn.gtmap.estateplat.server.core.model.BdcSjQlrxx;
import cn.gtmap.estateplat.server.core.model.QueryParam;
import cn.gtmap.estateplat.server.core.service.BdcQlrService;
import cn.gtmap.estateplat.server.core.service.BdcSjService;
import cn.gtmap.estateplat.server.core.service.BdcSjclService;
import cn.gtmap.estateplat.server.core.service.BdcSjxxService;
import cn.gtmap.estateplat.server.core.service.BdcSllshService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.core.service.CreateSjdclService;
import cn.gtmap.estateplat.server.enums.MapKeyLowerCaseEnum;
import cn.gtmap.estateplat.server.service.CreatProjectService;
import cn.gtmap.estateplat.server.service.core.ProjectLifeManageService;
import cn.gtmap.estateplat.server.service.impl.CreatProjectDefaultServiceImpl;
import cn.gtmap.estateplat.server.utils.CommonUtils;
import cn.gtmap.estateplat.server.utils.ConfigUtils;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class BdcSjServiceImpl
implements BdcSjService {
    @Autowired
    private Repo repository;
    @Autowired
    private BdcSllshService bdcSllshService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private ProjectLifeManageService projectLifeManageService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private BdcSjxxService bdcSjxxService;
    @Autowired
    private BdcSjclService bdcSjclService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private PlatformUtil platformUtil;
    @Autowired
    private CreateSjdclService createSjdclService;
    @Autowired
    @Qualifier(value="createProjectAutoTurnTaskServiceImpl")
    private CreatProjectService creatProjectService;
    @Autowired
    private CreatProjectDefaultServiceImpl creatProjectDefaultService;

    public Model initBdcSjdListModel(Model model, String proid, String operateRole) {
        model.addAttribute("proid", (Object)proid);
        model.addAttribute("operateRole", (Object)operateRole);
        model.addAttribute("admin", (Object)String.valueOf(SessionUtil.getCurrentUser().isAdmin()));
        model.addAttribute("userName", (Object)SessionUtil.getCurrentUser().getUsername());
        return model;
    }

    public Model initBdcSjdModel(Model model, String proid, String operateRole) {
        BdcSjJbxx bdcSjJbxx = null;
        List bdcsjclxxList = null;
        if (StringUtils.isBlank((CharSequence)proid)) {
            proid = UUIDGenerator.generate18();
            bdcSjJbxx = this.newBdcSjJbxx(proid);
            bdcsjclxxList = this.newBdcSjclxx(proid);
        } else {
            bdcSjJbxx = this.getBdcSjJbxxByProid(proid);
            bdcsjclxxList = this.getBdcSjClxxList(proid);
        }
        if (bdcSjJbxx != null) {
            model.addAttribute("proid", (Object)bdcSjJbxx.getProid());
            model.addAttribute("sjrq", (Object)com.gtis.common.util.CommonUtil.formateDate((Date)bdcSjJbxx.getSjrq()));
            model.addAttribute("sjbh", (Object)this.newSjbh(bdcSjJbxx.getSjrq()));
            List djlxList = this.bdcZdGlService.getDjlxByBdclx("TDFW");
            List sqlxList = this.bdcZdGlService.getSqlxByBdclxDjlx("TDFW", "100");
            model.addAttribute("sqlxList", (Object)sqlxList);
            model.addAttribute("djlxList", (Object)djlxList);
            model.addAttribute("sjclxx_num", (Object)(bdcsjclxxList != null ? bdcsjclxxList.size() : 1));
            model.addAttribute("userName", (Object)bdcSjJbxx.getSjr());
            model.addAttribute("operateRole", (Object)operateRole);
        }
        return model;
    }

    private BdcSjJbxx newBdcSjJbxx(String proid) {
        if (StringUtils.isBlank((CharSequence)proid)) {
            proid = UUIDGenerator.generate18();
        }
        BdcSjJbxx bdcSjJbxx = new BdcSjJbxx();
        bdcSjJbxx.setProid(proid);
        bdcSjJbxx.setSjrq(new Date());
        bdcSjJbxx.setSjr(SessionUtil.getCurrentUser().getUsername());
        bdcSjJbxx.setSjbh(this.newSjbh(bdcSjJbxx.getSjrq()));
        this.entityMapper.saveOrUpdate((Object)bdcSjJbxx, (Object)bdcSjJbxx.getProid());
        return bdcSjJbxx;
    }

    private List<BdcSjClxx> newBdcSjclxx(String proid) {
        String[] clmcs = ConfigUtils.getBdcsjSjclmc();
        ArrayList<BdcSjClxx> bdcSjClxxList = new ArrayList<BdcSjClxx>();
        if (clmcs.length > 0) {
            for (int i = 0; i < clmcs.length; ++i) {
                BdcSjClxx bdcSjClxx = new BdcSjClxx();
                bdcSjClxx.setProid(proid);
                bdcSjClxx.setClxxid(UUIDGenerator.generate18());
                bdcSjClxx.setClmc(clmcs[i]);
                bdcSjClxx.setFs(1);
                bdcSjClxx.setYs(0);
                bdcSjClxx.setXh(1);
                bdcSjClxxList.add(bdcSjClxx);
                this.entityMapper.saveOrUpdate((Object)bdcSjClxx, (Object)bdcSjClxx.getClxxid());
            }
        }
        return bdcSjClxxList;
    }

    private String newSjbh(Date sjrq) {
        String slbh = "";
        if (sjrq == null) {
            sjrq = new Date();
        }
        if (!ConfigUtils.getXmbhUsemodelOrder()) {
            slbh = CommonUtil.getCurrentTimeMillisId();
        } else {
            Integer maxLsh = this.bdcSllshService.getSlbhLsh();
            Integer lsh = maxLsh == null ? 1 : maxLsh + 1;
            slbh = CommonUtils.formatSlbh((Date)sjrq, (String)CommonUtils.formatLsh((Integer)lsh));
        }
        return slbh;
    }

    public Object getjbxxByPage(QueryParam queryParam, Pageable pageable) {
        if (queryParam != null) {
            if (StringUtils.equals((CharSequence)queryParam.getOperateRole(), (CharSequence)"sj")) {
                if (!SessionUtil.getCurrentUser().isAdmin()) {
                    queryParam.setSjr(SessionUtil.getCurrentUser().getUsername());
                }
            } else if (StringUtils.equals((CharSequence)queryParam.getOperateRole(), (CharSequence)"sl") && !SessionUtil.getCurrentUser().isAdmin()) {
                queryParam.setSlr(SessionUtil.getCurrentUser().getUsername());
            }
        }
        return this.repository.selectPaging("getjbxxByPage", (Object)queryParam, pageable);
    }

    @Transactional(rollbackFor={Exception.class})
    public String deleteBdcSj(String proid) {
        String result = "fail";
        if (StringUtils.isBlank((CharSequence)proid)) {
            return result;
        }
        String msg = this.checkHasDistribute(proid);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        this.deleteBdcSjQlrxx(proid);
        this.deleteBdcSjClxx(proid);
        this.deleteBdcSjjbxx(proid);
        result = "success";
        return result;
    }

    private String checkHasDistribute(String proid) {
        String result = "";
        BdcSjJbxx bdcSjJbxx = this.getBdcSjJbxxByProid(proid);
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null && bdcSjJbxx != null && StringUtils.equals((CharSequence)bdcXm.getBh(), (CharSequence)bdcSjJbxx.getSjbh()) && StringUtils.equals((CharSequence)bdcSjJbxx.getProid(), (CharSequence)bdcXm.getProid())) {
            result = "\u8be5\u6536\u4ef6\u4e1a\u52a1\u5df2\u6d3e\u4ef6\u529e\u7406";
        }
        return result;
    }

    public String deleteBdcSjs(String proids) {
        String result = "fail";
        if (StringUtils.isBlank((CharSequence)proids)) {
            return result;
        }
        String[] proidArr = StringUtils.split((String)proids, (String)",");
        for (int i = 0; i < proidArr.length; ++i) {
            result = this.deleteBdcSj(proidArr[i]);
        }
        return result;
    }

    private void deleteBdcSjjbxx(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            this.entityMapper.deleteByPrimaryKey(BdcSjJbxx.class, (Object)proid);
        }
    }

    private void deleteBdcSjClxx(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcSjClxx.class);
            example.createCriteria().andEqualTo(MapKeyLowerCaseEnum.PROID.getMapKey(), (Object)proid);
            this.entityMapper.deleteByExample(example);
        }
    }

    private void deleteBdcSjQlrxx(String proid) {
        if (StringUtils.isNotBlank((CharSequence)proid)) {
            Example example = new Example(BdcSjQlrxx.class);
            example.createCriteria().andEqualTo(MapKeyLowerCaseEnum.PROID.getMapKey(), (Object)proid);
            this.entityMapper.deleteByExample(example);
        }
    }

    public String distributeBdcSj(String proid) {
        List bdcSjClxxList;
        List bdcSjQlrxxList;
        String result = "fail";
        if (StringUtils.isBlank((CharSequence)proid)) {
            return result;
        }
        result = this.checkHasDistribute(proid);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        BdcSjJbxx bdcSjJbxx = this.getBdcSjJbxxByProid(proid);
        result = this.checkBdcSj(bdcSjJbxx, bdcSjQlrxxList = this.getBdcSjQlrxxList(proid), bdcSjClxxList = this.getBdcSjClxxList(proid));
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.distribute(bdcSjJbxx);
        }
        return result;
    }

    private String checkBdcSj(BdcSjJbxx bdcSjJbxx, List<BdcSjQlrxx> bdcSjQlrxxList, List<BdcSjClxx> bdcSjClxxList) {
        String res = "";
        if (bdcSjJbxx == null) {
            return BdcSjJbxx.class.getSimpleName() + "\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String nulField = CommonUtils.validateFiledIsNull((Object)bdcSjJbxx, (String[])new String[]{"sqlx", "sjr", "sjrq", "sqzsbs", "sjbh", "sffbcz"});
        if (StringUtils.isNotBlank((CharSequence)nulField)) {
            return bdcSjJbxx.getClass().getSimpleName() + "." + nulField + "\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty(bdcSjQlrxxList)) {
            return BdcSjQlrxx.class.getSimpleName() + "\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty(bdcSjClxxList)) {
            return BdcSjClxx.class.getSimpleName() + "\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return res;
    }

    private String distribute(BdcSjJbxx bdcSjJbxx) {
        Project project = this.newProjectFromBdcsj(bdcSjJbxx);
        Project returnProject = null;
        if (StringUtils.isNotBlank((CharSequence)bdcSjJbxx.getSlrid())) {
            project.setUserId(bdcSjJbxx.getSlrid());
            returnProject = this.creatProjectDefaultService.creatWorkFlow((Xmxx)project);
        } else {
            returnProject = this.creatProjectService.creatWorkFlow((Xmxx)project);
        }
        this.projectLifeManageService.createProject((Xmxx)returnProject);
        if (StringUtils.isBlank((CharSequence)bdcSjJbxx.getSlrid())) {
            bdcSjJbxx.setSlrid(returnProject.getUserId());
        }
        this.saveBdcSlxxToBdcSj(bdcSjJbxx);
        return "success";
    }

    private void saveBdcSlxxToBdcSj(BdcSjJbxx bdcSjJbxx) {
        BdcXm bdcXm;
        if (bdcSjJbxx != null && (bdcXm = this.bdcXmService.getBdcXmByProid(bdcSjJbxx.getProid())) != null) {
            bdcSjJbxx.setSlr(bdcXm.getCjr());
            bdcSjJbxx.setSlrq(bdcXm.getCjsj());
            this.entityMapper.saveOrUpdate((Object)bdcSjJbxx, (Object)bdcSjJbxx.getProid());
        }
    }

    private Project newProjectFromBdcsj(BdcSjJbxx bdcSjJbxx) {
        Project project = new Project();
        project.setBh(bdcSjJbxx.getSjbh());
        project.setProid(bdcSjJbxx.getProid());
        project.setWiid(bdcSjJbxx.getProid());
        project.setDjyy(bdcSjJbxx.getDjyy());
        project.setDjzx(bdcSjJbxx.getDjzx());
        project.setWorkFlowDefId(this.bdcZdGlService.getWdidBySqlxdm(bdcSjJbxx.getSqlx()));
        return project;
    }

    public List<BdcSjClxx> getBdcSjClxxList(String proid) {
        if (StringUtils.isBlank((CharSequence)proid)) {
            return new ArrayList<BdcSjClxx>();
        }
        Example example = new Example(BdcSjClxx.class);
        example.createCriteria().andEqualTo(MapKeyLowerCaseEnum.PROID.getMapKey(), (Object)proid);
        return this.entityMapper.selectByExample(example);
    }

    public List<BdcSjQlrxx> getBdcSjQlrxxList(String proid) {
        if (StringUtils.isBlank((CharSequence)proid)) {
            return new ArrayList<BdcSjQlrxx>();
        }
        Example example = new Example(BdcSjQlrxx.class);
        example.createCriteria().andEqualTo(MapKeyLowerCaseEnum.PROID.getMapKey(), (Object)proid);
        return this.entityMapper.selectByExample(example);
    }

    public BdcSjJbxx getBdcSjJbxxByProid(String proid) {
        if (StringUtils.isBlank((CharSequence)proid)) {
            return null;
        }
        return (BdcSjJbxx)this.entityMapper.selectByPrimaryKey(BdcSjJbxx.class, (Object)proid);
    }

    public String distributeBdcSjs(String proids) {
        String result = "fail";
        if (StringUtils.isBlank((CharSequence)proids)) {
            return result;
        }
        String[] proidArr = StringUtils.split((String)proids, (String)",");
        for (int i = 0; i < proidArr.length; ++i) {
            result = this.distributeBdcSj(proidArr[i]);
        }
        return result;
    }

    public String saveToSl(String proid) {
        if (StringUtils.isBlank((CharSequence)proid)) {
            return "fail";
        }
        String res = this.checkHasBdcdy(proid);
        if (StringUtils.isNotBlank((CharSequence)res)) {
            return res;
        }
        this.saveBdcqlr(proid);
        this.saveBdcsjcl(proid);
        this.saveBdcXm(proid);
        return "success";
    }

    private void saveBdcXm(String proid) {
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        BdcSjJbxx bdcSjJbxx = this.getBdcSjJbxxByProid(proid);
        if (bdcXm != null && bdcSjJbxx != null) {
            bdcXm.setDjzx(bdcSjJbxx.getDjzx());
            bdcXm.setDjyy(bdcSjJbxx.getDjyy());
            this.entityMapper.saveOrUpdate((Object)bdcXm, (Object)bdcXm.getProid());
        }
    }

    private void saveBdcqlr(String proid) {
        List bdcSjQlrxxList = this.getBdcSjQlrxxList(proid);
        ArrayList<BdcQlr> bdcQlrList = this.bdcQlrService.queryBdcQlrByProid(proid);
        boolean save = false;
        boolean hasBdcQlr = CollectionUtils.isNotEmpty((Collection)bdcQlrList);
        if (CollectionUtils.isNotEmpty((Collection)bdcSjQlrxxList)) {
            for (BdcSjQlrxx bdcSjQlrxx : bdcSjQlrxxList) {
                boolean contains = false;
                if (hasBdcQlr) {
                    contains = this.containsBdcSjQlrxx(bdcSjQlrxx, (List)bdcQlrList);
                } else {
                    bdcQlrList = new ArrayList<BdcQlr>();
                }
                if (contains) continue;
                BdcQlr bdcQlr = new BdcQlr();
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                bdcQlr.setProid(proid);
                bdcQlr.setQlrlx("qlr");
                bdcQlr.setQlrmc(bdcSjQlrxx.getQlrmc());
                bdcQlr.setQlrzjh(bdcSjQlrxx.getQlrzjh());
                bdcQlr.setQlrsfzjzl(bdcSjQlrxx.getQlrsfzjzl());
                bdcQlr.setQlrlxdh(bdcSjQlrxx.getLxdh());
                bdcQlrList.add(bdcQlr);
                save = true;
            }
        }
        if (save) {
            this.bdcQlrService.batchSaveOrUpdateBdcQlr((List)bdcQlrList);
        }
    }

    private boolean containsBdcSjQlrxx(BdcSjQlrxx bdcSjQlrxx, List<BdcQlr> bdcQlrList) {
        boolean contain = false;
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (!StringUtils.equals((CharSequence)bdcSjQlrxx.getQlrmc(), (CharSequence)bdcQlr.getQlrmc())) continue;
                contain = true;
                break;
            }
        }
        return contain;
    }

    private void saveBdcsjcl(String proid) {
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        List bdcSjClxxList = this.getBdcSjClxxList(proid);
        BdcSjxx bdcSjxx = this.bdcSjxxService.queryBdcSjxxByProid(proid);
        List bdcSjclList = null;
        if (bdcSjxx != null) {
            bdcSjclList = this.bdcSjclService.getBdcSjclListByProid(proid);
        }
        if (CollectionUtils.isNotEmpty((Collection)bdcSjClxxList)) {
            for (BdcSjClxx bdcSjClxx : bdcSjClxxList) {
                BdcSjcl bdcSjcl = this.checkContainSjcl(bdcSjClxx, bdcSjclList);
                if (bdcSjcl != null) {
                    this.copyFile(bdcSjClxx, proid, bdcSjcl, bdcXm);
                    continue;
                }
                this.newSjclAndCopyFile(bdcSjClxx, proid, bdcSjxx, bdcXm, bdcSjclList);
            }
        }
    }

    private void newSjclAndCopyFile(BdcSjClxx bdcSjClxx, String proid, BdcSjxx bdcSjxx, BdcXm bdcXm, List<BdcSjcl> bdcSjclList) {
        BdcSjcl bdcSjcl = new BdcSjcl();
        bdcSjcl.setSjclid(UUIDGenerator.generate18());
        bdcSjcl.setCllx(bdcSjClxx.getCllx());
        bdcSjcl.setClmc(bdcSjClxx.getClmc());
        bdcSjcl.setMrfs(Integer.valueOf(bdcSjClxx.getFs()));
        bdcSjcl.setYs(Integer.valueOf(bdcSjClxx.getYs()));
        bdcSjcl.setFs(bdcSjClxx.getYs());
        bdcSjcl.setSjxxid(bdcSjxx.getSjxxid());
        bdcSjcl.setXh(CollectionUtils.isNotEmpty(bdcSjclList) ? bdcSjclList.size() + 1 : 1);
        this.entityMapper.saveOrUpdate((Object)bdcSjcl, (Object)bdcSjcl.getSjclid());
        this.createSjdclService.createAllFileFolder(proid, bdcXm.getWiid(), bdcSjClxx.getClmc());
        if (bdcSjClxx.getWjzxid() != null) {
            BdcSjcl bdcSjclTemp;
            List listNode = this.nodeService.getAllChildNodes(bdcSjClxx.getWjzxid());
            ArrayList<Integer> idList = new ArrayList<Integer>();
            if (CollectionUtils.isNotEmpty((Collection)listNode)) {
                for (Node node : listNode) {
                    idList.add(node.getId());
                }
            }
            if ((bdcSjclTemp = (BdcSjcl)this.entityMapper.selectByPrimaryKey(BdcSjcl.class, (Object)bdcSjcl.getSjclid())).getWjzxid() != null) {
                this.platformUtil.copyFileImplToNode(idList, bdcSjclTemp.getWjzxid());
            }
        }
    }

    private void copyFile(BdcSjClxx bdcSjClxx, String proid, BdcSjcl bdcSjcl, BdcXm bdcXm) {
        this.createSjdclService.createAllFileFolder(proid, bdcXm.getWiid(), bdcSjcl.getClmc());
        if (bdcSjClxx != null && bdcSjClxx.getWjzxid() != null) {
            List listNode = this.nodeService.getAllChildNodes(bdcSjClxx.getWjzxid());
            ArrayList<Integer> idList = new ArrayList<Integer>();
            if (CollectionUtils.isNotEmpty((Collection)listNode)) {
                for (Node node : listNode) {
                    idList.add(node.getId());
                }
            }
            if (bdcSjcl.getWjzxid() != null) {
                this.platformUtil.copyFileImplToNode(idList, bdcSjcl.getWjzxid());
            }
        }
    }

    private BdcSjcl checkContainSjcl(BdcSjClxx bdcSjClxx, List<BdcSjcl> bdcSjclList) {
        if (CollectionUtils.isNotEmpty(bdcSjclList)) {
            for (BdcSjcl bdcSjcl : bdcSjclList) {
                if (!StringUtils.equals((CharSequence)bdcSjcl.getClmc(), (CharSequence)bdcSjClxx.getClmc())) continue;
                return bdcSjcl;
            }
        }
        return null;
    }

    private String checkHasBdcdy(String proid) {
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        return bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getBdcdyid()) ? "" : "\u8bf7\u5148\u9009\u62e9\u4e0d\u52a8\u4ea7\u5355\u5143\u518d\u5173\u8054\u6536\u4ef6\u4fe1\u606f";
    }

    public void updateBdcSjJbxxThyy(String proid, String wiid) {
        boolean updateBdcSjJbxxThyy = AppConfig.getBooleanProperty((String)"updateBdcSjJbxxThyy");
        if (updateBdcSjJbxxThyy && StringUtils.isNotBlank((CharSequence)wiid) && StringUtils.isNotBlank((CharSequence)proid)) {
            BdcSjJbxx bdcSjJbxx;
            BdcXtLog bdcXtLog;
            Example example = new Example(BdcXtLog.class);
            example.createCriteria().andEqualTo("wiid", (Object)wiid).andEqualTo("controller", (Object)"\u5220\u9664");
            example.setOrderByClause("czrq desc");
            List bdcXtLogList = this.entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)bdcXtLogList) && StringUtils.isNotBlank((CharSequence)(bdcXtLog = (BdcXtLog)bdcXtLogList.get(0)).getReason()) && null != (bdcSjJbxx = this.getBdcSjJbxxByProid(proid))) {
                bdcSjJbxx.setThyy(bdcXtLog.getReason());
                bdcSjJbxx.setSlr(null);
                bdcSjJbxx.setSlrq(null);
                this.entityMapper.updateByPrimaryKeyNull((Object)bdcSjJbxx);
            }
        }
    }
}

