/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.model.server.core.BdcFwHs;
import cn.gtmap.estateplat.server.core.mapper.server.BdcHsMapper;
import cn.gtmap.estateplat.server.core.service.BdcHsService;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.config.AppConfig;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.xml.sax.InputSource;

@Repository
public class BdcHsServiceImpl
implements BdcHsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BdcHsMapper bdcHsMapper;

    public List<String> getbdcdyListByXml(String xmlDoc, String djbid) {
        ArrayList<String> bdcdyList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)xmlDoc)) {
            return new ArrayList<String>();
        }
        StringReader read = new StringReader(xmlDoc);
        InputSource source = new InputSource(read);
        SAXBuilder sb = new SAXBuilder();
        ArrayList fwlist = new ArrayList();
        String bdcdjUrl = AppConfig.getProperty((String)"bdcdj.url");
        try {
            Document doc = sb.build(source);
            Element root = doc.getRootElement();
            List jiedian = root.getChildren();
            Element et = null;
            if (jiedian != null && CollectionUtils.isNotEmpty((Collection)jiedian)) {
                for (int i = 0; i < jiedian.size(); ++i) {
                    HashMap<String, Object> fwMap = new HashMap<String, Object>();
                    et = (Element)jiedian.get(i);
                    if (StringUtils.equals((CharSequence)et.getName(), (CharSequence)"BDCDY") || StringUtils.equals((CharSequence)et.getName(), (CharSequence)"TD")) {
                        if (root.getAttributeValue("DZ") != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{CommonUtil.formatEmptyValue((Object)root.getAttributeValue("DZ"))}) || et.getAttributeValue("DZ") != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{CommonUtil.formatEmptyValue((Object)et.getAttributeValue("DZ"))})) {
                            fwMap.put("MC", et.getAttributeValue("DZ"));
                        } else {
                            fwMap.put("MC", et.getAttributeValue("BDCDYH"));
                        }
                        fwMap.put("DM", et.getAttributeValue("BDCDYH"));
                        fwMap.put("URL", bdcdjUrl + "/bdcDjb/showQL?bdcdyh=" + et.getAttributeValue("BDCDYH") + "&isql=false&djbid=" + djbid);
                        fwlist.add(fwMap);
                        continue;
                    }
                    fwMap.put("MC", et.getAttributeValue("FWMC"));
                    fwMap.put("DM", et.getAttributeValue("ZRZH"));
                    List zjiedian = et.getChildren();
                    ArrayList ljzList = new ArrayList();
                    fwMap.put("LJZ", ljzList);
                    fwlist.add(fwMap);
                    for (int j = 0; j < zjiedian.size(); ++j) {
                        HashMap<String, String> lzjMap = new HashMap<String, String>();
                        Element xet = (Element)zjiedian.get(j);
                        lzjMap.put("FWMC", xet.getAttributeValue("FWMC"));
                        lzjMap.put("KEYCODE", xet.getAttributeValue("KEYCode"));
                        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xet.getAttributeValue("KEYCode")})) continue;
                        for (String temp : this.bdcHsMapper.selectHsCount(xet.getAttributeValue("KEYCode"))) {
                            bdcdyList.add(temp);
                        }
                    }
                }
            }
        }
        catch (JDOMException e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
        return bdcdyList;
    }

    public List<HashMap> xmlToJson(String xmlDoc, String djbid) {
        if (StringUtils.isBlank((CharSequence)xmlDoc)) {
            return new ArrayList<HashMap>();
        }
        StringReader read = new StringReader(xmlDoc);
        InputSource source = new InputSource(read);
        SAXBuilder sb = new SAXBuilder();
        ArrayList<HashMap> fwlist = new ArrayList<HashMap>();
        String bdcdjUrl = AppConfig.getProperty((String)"bdcdj.url");
        try {
            Document doc = sb.build(source);
            Element root = doc.getRootElement();
            List jiedian = root.getChildren();
            Element et = null;
            if (jiedian != null && CollectionUtils.isNotEmpty((Collection)jiedian)) {
                for (int i = 0; i < jiedian.size(); ++i) {
                    HashMap<String, Object> fwMap = new HashMap<String, Object>();
                    et = (Element)jiedian.get(i);
                    if (StringUtils.equals((CharSequence)et.getName(), (CharSequence)"BDCDY") || StringUtils.equals((CharSequence)et.getName(), (CharSequence)"TD")) {
                        if (root.getAttributeValue("DZ") != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{CommonUtil.formatEmptyValue((Object)root.getAttributeValue("DZ"))}) || et.getAttributeValue("DZ") != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{CommonUtil.formatEmptyValue((Object)et.getAttributeValue("DZ"))})) {
                            fwMap.put("MC", et.getAttributeValue("DZ"));
                        } else {
                            fwMap.put("MC", et.getAttributeValue("BDCDYH"));
                        }
                        fwMap.put("DM", et.getAttributeValue("BDCDYH"));
                        fwMap.put("URL", bdcdjUrl + "/bdcDjb/showQL?bdcdyh=" + et.getAttributeValue("BDCDYH") + "&isql=false&djbid=" + djbid);
                        fwlist.add(fwMap);
                        continue;
                    }
                    fwMap.put("MC", et.getAttributeValue("FWMC"));
                    fwMap.put("DM", et.getAttributeValue("ZRZH"));
                    List zjiedian = et.getChildren();
                    ArrayList ljzList = new ArrayList();
                    fwMap.put("LJZ", ljzList);
                    fwlist.add(fwMap);
                    for (int j = 0; j < zjiedian.size(); ++j) {
                        HashMap<String, String> lzjMap = new HashMap<String, String>();
                        Element xet = (Element)zjiedian.get(j);
                        lzjMap.put("FWMC", xet.getAttributeValue("FWMC"));
                        lzjMap.put("KEYCODE", xet.getAttributeValue("KEYCode"));
                        String type = "";
                        String url = "";
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xet.getAttributeValue("KEYCode")})) {
                            List bdcdyList = this.bdcHsMapper.selectHsCount(xet.getAttributeValue("KEYCode"));
                            if (bdcdyList != null && bdcdyList.size() > 1) {
                                type = "LPB";
                                url = bdcdjUrl + "/lpb/lpb?dcbId=" + xet.getAttributeValue("KEYCode") + "&showQl=true&isNotBack=true&isNotWf=true&openQlWay=win&djbid=" + djbid;
                            } else if (bdcdyList != null && bdcdyList.size() == 1) {
                                type = "DY";
                                url = bdcdjUrl + "/bdcDjb/showQL?bdcdyh=" + (String)bdcdyList.get(0) + "&isql=false";
                            }
                        }
                        lzjMap.put("TYPE", type);
                        lzjMap.put("URL", url);
                        ljzList.add(lzjMap);
                    }
                }
            } else if (root != null) {
                HashMap<String, String> fwMap = new HashMap<String, String>();
                if (StringUtils.equals((CharSequence)root.getName(), (CharSequence)"BDCDY")) {
                    if (root.getAttributeValue("DZ") != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{CommonUtil.formatEmptyValue((Object)root.getAttributeValue("DZ"))})) {
                        fwMap.put("MC", root.getAttributeValue("DZ"));
                    } else {
                        fwMap.put("MC", root.getAttributeValue("BDCDYH"));
                    }
                    fwMap.put("DM", root.getAttributeValue("BDCDYH"));
                    fwMap.put("URL", bdcdjUrl + "/bdcDjb/showQL?bdcdyh=" + root.getAttributeValue("BDCDYH") + "&isql=false");
                    fwlist.add(fwMap);
                }
            }
        }
        catch (JDOMException e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
        }
        return fwlist;
    }

    public String getLpbUrl(String djbId) {
        String url = "";
        if (StringUtils.isNotBlank((CharSequence)djbId)) {
            String bdcdjUrl = AppConfig.getProperty((String)"bdcdj.url");
            List bdcdyList = this.bdcHsMapper.selectHsCount(djbId);
            if (bdcdyList != null) {
                url = bdcdyList.size() > 1 ? bdcdjUrl + "/lpb/lpb?dcbId=" + djbId + "&showQl=true&isNotWf=true&openQlWay=win" : bdcdjUrl + "/bdcDjb/showQL?bdcdyh=" + (String)bdcdyList.get(0) + "&isql=false";
            }
        }
        return url;
    }

    public List<BdcFwHs> getBdcFwhsQlztList(Map map) {
        return this.bdcHsMapper.getBdcFwhsQlztList(map);
    }

    public List<Map> getGdFwhsList(Map map) {
        return this.bdcHsMapper.getGdFwhsList(map);
    }

    public String getHsQsztByHsId(List<BdcFwHs> bdcFwHsList, List<Map> gdFwhsList, String hsId, String djHsQlzt) {
        String qszt = "";
        if (StringUtils.isNotBlank((CharSequence)hsId)) {
            if (bdcFwHsList != null && CollectionUtils.isNotEmpty(bdcFwHsList)) {
                for (BdcFwHs bdcFwHs : bdcFwHsList) {
                    if (!StringUtils.equals((CharSequence)hsId, (CharSequence)bdcFwHs.getFwHsIndex())) continue;
                    qszt = qszt + bdcFwHs.getQlzt();
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszt})) {
                    if (qszt.contains(String.valueOf(Constants.QLLX_QSZT_ZZ))) {
                        qszt = String.valueOf(Constants.QLLX_QSZT_ZZ);
                    } else if (qszt.contains(String.valueOf(Constants.QLLX_QSZT_HR))) {
                        qszt = String.valueOf(Constants.QLLX_QSZT_HR);
                    } else {
                        for (BdcFwHs bdcFwHs : bdcFwHsList) {
                            if (!StringUtils.equals((CharSequence)hsId, (CharSequence)bdcFwHs.getFwHsIndex())) continue;
                            qszt = bdcFwHs.getQlzt();
                            break;
                        }
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)qszt) || StringUtils.equals((CharSequence)qszt, (CharSequence)"0")) {
                qszt = djHsQlzt;
            }
            if ((StringUtils.isBlank((CharSequence)qszt) || StringUtils.equals((CharSequence)qszt, (CharSequence)"0")) && gdFwhsList != null && CollectionUtils.isNotEmpty(gdFwhsList)) {
                for (Map gdFwhs : gdFwhsList) {
                    if (!StringUtils.equals((CharSequence)hsId, (CharSequence)CommonUtil.formatEmptyValue(gdFwhs.get("FW_HS_INDEX")))) continue;
                    qszt = qszt + CommonUtil.formatEmptyValue(gdFwhs.get("QSZT"));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qszt})) {
                    if (qszt.contains(String.valueOf(Constants.QLLX_QSZT_ZZ))) {
                        qszt = String.valueOf(Constants.QLLX_QSZT_ZZ);
                    } else if (qszt.contains(String.valueOf(Constants.QLLX_QSZT_HR))) {
                        qszt = String.valueOf(Constants.QLLX_QSZT_HR);
                    } else {
                        for (Map gdFwhs : gdFwhsList) {
                            if (!StringUtils.equals((CharSequence)hsId, (CharSequence)CommonUtil.formatEmptyValue(gdFwhs.get("FW_HS_INDEX")))) continue;
                            qszt = CommonUtil.formatEmptyValue(gdFwhs.get("QSZT"));
                            break;
                        }
                    }
                }
            }
        }
        return qszt;
    }

    public List<BdcFwHs> getBdcYcFwhsQlztList(HashMap map) {
        return this.bdcHsMapper.getBdcYcFwhsQlztList(map);
    }

    public List<Map> getGdYcFwhsList(HashMap map) {
        return this.bdcHsMapper.getGdYcFwhsList((Map)map);
    }
}

