/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcGdxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.mapper.server.BdcGdxxMapper;
import cn.gtmap.estateplat.server.core.service.BdcGdxxService;
import cn.gtmap.estateplat.server.service.ArchivePostService;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcGdxxServiceImpl
implements BdcGdxxService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcGdxxMapper bdcGdxxMapper;
    @Autowired
    private Repo repository;
    @Autowired
    ArchivePostService archivePostService;

    public void insertBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null) {
            if (StringUtils.isBlank((CharSequence)bdcGdxx.getGdxxid())) {
                bdcGdxx.setGdxxid(UUIDGenerator.generate18());
            }
            this.entityMapper.insertSelective((Object)bdcGdxx);
        }
    }

    public void updateBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null && StringUtils.isNotBlank((CharSequence)bdcGdxx.getGdxxid())) {
            this.entityMapper.updateByPrimaryKeySelective((Object)bdcGdxx);
        }
    }

    public BdcGdxx initBdcGdxx(BdcGdxx bdcGdxx, String gdxml) {
        try {
            Document document;
            Node archiveNode;
            if (StringUtils.isNotBlank((CharSequence)gdxml) && (archiveNode = (document = DocumentHelper.parseText((String)gdxml)).selectSingleNode("//list/archive")) != null) {
                Element archiveElement;
                if (bdcGdxx == null) {
                    bdcGdxx = new BdcGdxx();
                    bdcGdxx.setGdxxid(UUIDGenerator.generate18());
                }
                if (StringUtils.isNotBlank((CharSequence)(archiveElement = (Element)archiveNode).attributeValue("result"))) {
                    if ("succeed".equals(archiveElement.attributeValue("result"))) {
                        List fieldList = archiveNode.selectNodes("field");
                        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                            for (Node field : fieldList) {
                                Element fieldElement = (Element)field;
                                String name = fieldElement.attributeValue("name");
                                if (name != null && "id".equals(name)) {
                                    bdcGdxx.setDaid(field.getText());
                                }
                                if (name != null && "ajh".equals(name)) {
                                    bdcGdxx.setAjh(field.getText());
                                }
                                if (name == null || !"mlh".equals(name)) continue;
                                bdcGdxx.setMlh(field.getText());
                            }
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)archiveElement.attributeValue("msg"))) {
                        bdcGdxx.setGdxx(archiveElement.attributeValue("msg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bdcGdxx;
    }

    public boolean checkIsGd(String proid) {
        int count = this.bdcGdxxMapper.countXmid(proid);
        return count <= 0;
    }

    public BdcGdxx selectBdcGdxx(BdcXm bdcXm) {
        BdcGdxx bdcGdxx = null;
        if (bdcXm != null && StringUtils.isNotBlank((CharSequence)bdcXm.getProid())) {
            String proid = bdcXm.getProid();
            bdcGdxx = (BdcGdxx)this.repository.selectOne("selectBdcGdxx", (Object)proid);
        }
        return bdcGdxx;
    }

    public String gdBdcXmxx(BdcXm bdcXm, String userName) {
        String msg = "\u5f52\u6863\u6210\u529f";
        BdcGdxx bdcGdxx = this.archivePostService.postBdcXmInfo(bdcXm);
        bdcGdxx.setGdr(userName);
        bdcGdxx.setXmid(bdcXm.getProid());
        if (this.selectBdcGdxx(bdcXm) == null) {
            this.insertBdcGdxx(bdcGdxx);
        } else {
            this.updateBdcGdxx(bdcGdxx);
        }
        if (StringUtils.isBlank((CharSequence)bdcGdxx.getDaid())) {
            msg = "";
        }
        return msg;
    }

    public Map getResultFromXmxx(Map xmxxOfGdxx, int xmNum) {
        HashMap result = Maps.newHashMap();
        StringBuilder bdcqzh = new StringBuilder();
        StringBuilder bdcdyh = new StringBuilder();
        StringBuilder zl = new StringBuilder();
        if (MapUtils.isNotEmpty((Map)xmxxOfGdxx)) {
            String bdcqzhStr = (String)xmxxOfGdxx.get("BDCQZH");
            String bdcdyhStr = (String)xmxxOfGdxx.get("BDCDYH");
            String zlStr = (String)xmxxOfGdxx.get("ZL");
            bdcqzh.append(StringUtils.isNotBlank((CharSequence)bdcqzhStr) ? bdcqzhStr : "");
            bdcdyh.append(StringUtils.isNotBlank((CharSequence)bdcdyhStr) ? bdcdyhStr : "");
            zl.append(StringUtils.isNotBlank((CharSequence)zlStr) ? zlStr : "");
        }
        if (xmNum > 1) {
            bdcqzh.append(StringUtils.isNotBlank((CharSequence)bdcqzh) ? "\u7b49" : "");
            bdcdyh.append(StringUtils.isNotBlank((CharSequence)bdcdyh) ? "\u7b49" : "");
            zl.append(StringUtils.isNotBlank((CharSequence)zl) ? "\u7b49" : "");
        }
        result.put("bdcqzh", bdcqzh);
        result.put("bdcdyh", bdcdyh);
        result.put("zl", zl);
        return result;
    }
}

