/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcFdcq;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.server.core.mapper.server.BdcFdcqMapper;
import cn.gtmap.estateplat.server.core.model.ycsl.ApiRequestParameter;
import cn.gtmap.estateplat.server.core.model.ycsl.ResultEntity;
import cn.gtmap.estateplat.server.core.service.BdcFdcqService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.utils.Constants;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BdcFdcqServiceImpl
implements BdcFdcqService {
    @Autowired
    BdcFdcqMapper bdcFdcqMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcXmService bdcXmService;

    public List<BdcFdcq> getBdcFdcq(Map map) {
        return this.bdcFdcqMapper.getBdcFdcq(map);
    }

    public List<BdcFdcq> getBdcFdcqByProid(String proid) {
        return this.bdcFdcqMapper.getBdcFdcqByProid(proid);
    }

    @Transactional
    public void delBdcFdcqByProid(String proid) {
        List bdcFdcqList = this.getBdcFdcqByProid(proid);
        if (bdcFdcqList != null) {
            for (BdcFdcq bdcFdcq : bdcFdcqList) {
                if (bdcFdcq == null || !StringUtils.isNotBlank((CharSequence)bdcFdcq.getQlid())) continue;
                this.entityMapper.deleteByPrimaryKey(BdcFdcq.class, (Object)bdcFdcq.getQlid());
            }
        }
    }

    public Map<String, Object> checkDbBdcFdcq(Project project) {
        HashMap result = Maps.newHashMap();
        List bdcXmList = null;
        if (project != null && StringUtils.isNotBlank((CharSequence)project.getBdcdyh())) {
            bdcXmList = this.bdcXmService.queryBdcxmByBdcdyh(project.getBdcdyh());
        }
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm bdcXm : bdcXmList) {
                List bdcFdcqList = this.bdcFdcqMapper.getBdcFdcqByProid(bdcXm.getProid());
                if (!CollectionUtils.isNotEmpty((Collection)bdcFdcqList)) continue;
                BdcFdcq bdcFdcq = (BdcFdcq)bdcFdcqList.get(0);
                boolean djsjAvalible = bdcFdcq.getDjsj() != null;
                boolean dbrAvalible = StringUtils.isNotBlank((CharSequence)bdcFdcq.getDbr());
                boolean xsql = Constants.QLLX_QSZT_XS.equals(bdcFdcq.getQszt());
                if (!djsjAvalible || !dbrAvalible || !xsql) continue;
                result.put("info", bdcXm.getProid());
                break;
            }
        }
        return result;
    }

    public List<BdcFdcq> getBdcFdcqList(Map<String, Object> param) {
        if (MapUtils.isEmpty(param)) {
            return Lists.newArrayList();
        }
        return this.bdcFdcqMapper.getBdcFdcqList(param);
    }

    public void updateBdcFdcqQszt(Map map) {
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        this.bdcFdcqMapper.updateBdcFdcqQszt(map);
    }

    public List<ResultEntity> queryFdcqxx(Map param) {
        if (param == null || param.size() == 0) {
            return new ArrayList<ResultEntity>();
        }
        return this.bdcFdcqMapper.queryFdcqxx(param);
    }

    public List<Map<String, Object>> queryHasZs(ApiRequestParameter apiRequestParameter) {
        return this.bdcFdcqMapper.queryHasZs(apiRequestParameter);
    }
}

