/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.GdCf;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import cn.gtmap.estateplat.server.core.service.BdcCheckCfDyService;
import cn.gtmap.estateplat.server.core.service.BdcGdDyhRelService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcdyService;
import cn.gtmap.estateplat.server.core.service.GdFwService;
import cn.gtmap.estateplat.server.core.service.GdTdService;
import cn.gtmap.estateplat.server.enums.MapKeyEnum;
import cn.gtmap.estateplat.utils.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcCheckCfDyServiceImpl
implements BdcCheckCfDyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private BdcXmService bdcXmService;

    public List<Map> checkCfByBdcdyh(String bdcdyh) {
        List cfList = null;
        if (StringUtils.isNotBlank((CharSequence)bdcdyh) && CollectionUtils.isEmpty((Collection)(cfList = this.checkCfForBdc(bdcdyh)))) {
            cfList = this.checkCfForGd(bdcdyh);
        }
        return cfList;
    }

    private List<Map> checkCfForBdc(String bdcdyh) {
        ArrayList<Map> cfList = new ArrayList<Map>();
        BdcBdcdy bdcBdcdy = this.bdcdyService.queryBdcdyByBdcdyh(bdcdyh);
        if (bdcBdcdy != null) {
            Example bdcCfExample = new Example(BdcCf.class);
            bdcCfExample.createCriteria().andEqualNvlTo("qszt", (Object)1, (Object)0).andEqualTo(MapKeyEnum.BDCDYID.getMapKey(), (Object)bdcBdcdy.getBdcdyid());
            List bdcCfList = this.entityMapper.selectByExample(bdcCfExample);
            if (CollectionUtils.isNotEmpty((Collection)bdcCfList)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                for (BdcCf bdcCf : bdcCfList) {
                    if (bdcCf.getCfjsqx() != null) {
                        try {
                            Date cfjdqx = format.parse(format.format(bdcCf.getCfjsqx()));
                            Date toDay = format.parse(format.format(new Date()));
                            long day = (cfjdqx.getTime() - toDay.getTime()) / 86400000L;
                            if (day < 0L) continue;
                            HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                            cfMap.put("Cf", 1);
                            cfList.add(cfMap);
                            break;
                        }
                        catch (ParseException e) {
                            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
                            continue;
                        }
                    }
                    HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                    cfMap.put("Cf", 1);
                    cfList.add(cfMap);
                    break;
                }
            }
            if (CollectionUtils.isEmpty(cfList)) {
                Example example = new Example(BdcXm.class);
                example.createCriteria().andEqualTo(MapKeyEnum.BDCDYID.getMapKey(), (Object)bdcBdcdy.getBdcdyid());
                List bdcXmList = this.entityMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
                    block3: for (BdcXm bdcXm : bdcXmList) {
                        Example bdcCfExampleTemp = new Example(BdcCf.class);
                        bdcCfExampleTemp.createCriteria().andEqualNvlTo("qszt", (Object)1, (Object)0).andEqualTo(MapKeyEnum.PROID.getMapKey(), (Object)bdcXm.getProid());
                        List bdcCfListTemp = this.entityMapper.selectByExample(bdcCfExampleTemp);
                        if (!CollectionUtils.isNotEmpty((Collection)bdcCfListTemp)) continue;
                        for (BdcCf bdcCf : bdcCfListTemp) {
                            if (bdcCf.getCfjsqx() != null) {
                                Long dayL = CommonUtil.getDaySub((Date)bdcCf.getCfjsqx(), (Date)new Date()) - 1L;
                                if (dayL >= 0L) continue;
                                HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                                cfMap.put("Cf", 1);
                                cfList.add(cfMap);
                                continue block3;
                            }
                            HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                            cfMap.put("Cf", 1);
                            cfList.add(cfMap);
                            continue block3;
                        }
                    }
                }
            }
        }
        return cfList;
    }

    private List<Map> checkCfForGd(String bdcdyh) {
        ArrayList cfList = null;
        List bdcGdDyhRelList = this.bdcGdDyhRelService.getGdDyhRelByDyh(bdcdyh);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty((Collection)bdcGdDyhRelList)) {
            block2: for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                List bdcCfList;
                if (StringUtils.isNotBlank((CharSequence)bdcGdDyhRel.getGdid())) {
                    List gdCfList = this.gdFwService.getGdCfByBdcid(bdcGdDyhRel.getGdid());
                    if (!CollectionUtils.isNotEmpty((Collection)gdCfList)) continue;
                    for (GdCf gdCf : gdCfList) {
                        if (gdCf.getIsjf() == 1 || gdCf.getCfjsrq() == null) continue;
                        try {
                            Date cfjdqx = format.parse(format.format(gdCf.getCfjsrq()));
                            Date toDay = format.parse(format.format(new Date()));
                            long day = (cfjdqx.getTime() - toDay.getTime()) / 86400000L;
                            if (day <= 0L) continue;
                            cfList = new ArrayList();
                            HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                            cfMap.put("Cf", 1);
                            cfList.add(cfMap);
                            continue block2;
                        }
                        catch (ParseException e) {
                            this.logger.error(e.toString() + "_" + e.getMessage(), (Throwable)e);
                        }
                    }
                    continue;
                }
                List gdFwsyqList = this.gdFwService.getGdFwsyqByGdid(bdcGdDyhRel.getGdid());
                List gdTdsyqList = this.gdTdService.queryTdsyqByTdid(bdcGdDyhRel.getGdid());
                if (CollectionUtils.isNotEmpty((Collection)gdFwsyqList)) {
                    for (GdFwsyq gdFwsyq : gdFwsyqList) {
                        bdcCfList = this.bdcXmService.getBdcCfByYqlid(gdFwsyq.getQlid());
                        if (!CollectionUtils.isNotEmpty((Collection)bdcCfList)) continue;
                        cfList = new ArrayList();
                        HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                        cfMap.put("Cf", 1);
                        cfList.add(cfMap);
                        break;
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)gdTdsyqList)) continue;
                for (GdTdsyq gdTdsyq : gdTdsyqList) {
                    bdcCfList = this.bdcXmService.getBdcCfByYqlid(gdTdsyq.getQlid());
                    if (!CollectionUtils.isNotEmpty((Collection)bdcCfList)) continue;
                    cfList = new ArrayList();
                    HashMap<String, Integer> cfMap = new HashMap<String, Integer>();
                    cfMap.put("Cf", 1);
                    cfList.add(cfMap);
                    continue block2;
                }
            }
        }
        return cfList;
    }
}

