/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.service.fuping.impl;

import cn.gtmap.estateplat.server.core.service.fuping.MarriageQueryService;
import cn.gtmap.estateplat.server.utils.Constants;
import cn.gtmap.estateplat.server.utils.HttpRequestUtils;
import cn.gtmap.estateplat.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MarriageQueryServiceImpl
implements MarriageQueryService {
    private static final Logger logger = LoggerFactory.getLogger(MarriageQueryServiceImpl.class);

    public String queryMarriageInfo(String cert_num) {
        String accessTokenUrl = AppConfig.getProperty((String)"marriage.accessTokenUrl");
        String marriageInfoUrl = AppConfig.getProperty((String)"marriage.marriageInfoUrl");
        String sxmz_client_ip = AppConfig.getProperty((String)"marriage.sxmz_client_ip");
        String client_id = AppConfig.getProperty((String)"marriage.client_id");
        String client_secret = AppConfig.getProperty((String)"marriage.client_secret");
        String accessToken = this.getAccessToken(accessTokenUrl, client_id, client_secret);
        String sxmz_client_id = AppConfig.getProperty((String)"marriage.sxmz_client_id");
        String sxmz_client_secret = AppConfig.getProperty((String)"marriage.sxmz_client_secret");
        String sxmz_nonce = this.getSixInt();
        String sxmz_access_token = this.getSxmzAccessToken(sxmz_client_secret, sxmz_nonce);
        return this.getMarriageInfo(marriageInfoUrl, accessToken, sxmz_client_id, sxmz_access_token, sxmz_client_ip, sxmz_nonce, cert_num);
    }

    private String getMarriageInfo(String url, String accessToken, String sxmz_client_id, String sxmz_access_token, String sxmz_client_ip, String sxmz_nonce, String cert_num) {
        String param = "cert_num=" + cert_num;
        HashMap<String, String> headMap = new HashMap<String, String>(12);
        headMap.put("accessToken", accessToken);
        headMap.put("sxmz_client_id", sxmz_client_id);
        headMap.put("sxmz_access_token", sxmz_access_token);
        headMap.put("sxmz_client_ip", sxmz_client_ip);
        headMap.put("sxmz_nonce", sxmz_nonce);
        logger.info("\u5bcc\u5e73\u5a5a\u59fb\u4fe1\u606f\u67e5\u8be2\uff1a\u5a5a\u59fb\u4fe1\u606f\u83b7\u53d6\uff1a\u8bf7\u6c42\u5730\u5740\u53c2\u6570\uff1a" + url + "?" + param + "\u8bf7\u6c42\u5934\u53c2\u6570\uff1a" + JSON.toJSONString(headMap));
        String result = HttpRequestUtils.sendGet((String)url, (String)param, headMap, (String)"utf-8");
        logger.info("\u5bcc\u5e73\u5a5a\u59fb\u4fe1\u606f\u67e5\u8be2\uff1a\u5a5a\u59fb\u4fe1\u606f\u83b7\u53d6\uff1a\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\uff1a" + result);
        return result;
    }

    private String getSxmzAccessToken(String sxmz_client_secret, String sxmz_nonce) {
        String sixDate = DateUtils.formatTime((Date)DateUtils.now(), (FastDateFormat)Constants.DATE_FORMAT);
        String str = sxmz_client_secret + sixDate + sxmz_nonce;
        return DigestUtils.sha1Hex((String)str);
    }

    private String getAccessToken(String url, String client_id, String client_secret) {
        JSONObject jsonObject;
        String accessToken = "";
        String param = "client_id=" + client_id + "&" + "client_secret=" + client_secret;
        logger.info("\u5bcc\u5e73\u5a5a\u59fb\u4fe1\u606f\u67e5\u8be2\uff1aaccessToken\u83b7\u53d6\uff1a\u8bf7\u6c42\u5730\u5740\u53c2\u6570\uff1a" + url + "?" + param);
        String result = HttpRequestUtils.sendGet((String)url, (String)param, null, (String)"utf-8");
        logger.info("\u5bcc\u5e73\u5a5a\u59fb\u4fe1\u606f\u67e5\u8be2\uff1aaccessToken\u83b7\u53d6\uff1a\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\uff1a" + result);
        if (StringUtils.isNotBlank((String)result) && null != (jsonObject = JSON.parseObject((String)result))) {
            accessToken = (String)jsonObject.get((Object)"accessToken");
        }
        return accessToken;
    }

    String getSixInt() {
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            result.append(random.nextInt(10));
        }
        return result.toString();
    }
}

