/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.aop;

import cn.gtmap.estateplat.server.utils.ValidUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Aspect
@Component
public class ServiceValidateAspect {
    @Autowired
    ValidUtil validUtil;

    @Pointcut(value="execution(* cn.gtmap.estateplat.server.service.rest.impl..*.*(..))")
    public void servicePointcut() {
    }

    @Around(value="servicePointcut()")
    public Object serviceParamCheckAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Annotation[][] argAnnotations = method.getParameterAnnotations();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            for (Annotation annotation : argAnnotations[i]) {
                if (!Validated.class.isInstance(annotation)) continue;
                Validated validated = (Validated)annotation;
                Class[] groups = validated.value();
                this.validUtil.validAndReturnFirstErrorTips(args[i], groups);
            }
        }
        return joinPoint.proceed(args);
    }
}

