/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.core.aop;

import com.gtis.config.AppConfig;
import com.gtis.util.ThreadPool;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Aspect
@Component
public class AutoAccessInterceptor {
    private final Logger log = LoggerFactory.getLogger(AutoAccessInterceptor.class);
    @Autowired
    private RestTemplate restTemplate;

    @AfterReturning(value="execution(* cn.gtmap.estateplat.server.web.main.WfProjectController.changeQlztProjectEvent(..))&& args(proid,activityid,userid,taskid)||execution(* cn.gtmap.estateplat.server.web.main.WfProjectController.endProjectEvent(..)) && args(proid,activityid,userid,taskid)")
    private void autoAccess(JoinPoint jp, String proid, String activityid, String userid, String taskid) {
        String signatureName;
        String autoAccessMethod = AppConfig.getProperty((String)"autoAccessMethod");
        if (!StringUtils.equals((CharSequence)autoAccessMethod, (CharSequence)(signatureName = jp.getSignature().getName()))) {
            return;
        }
        ThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void exchangeAutoAccess(String proid, String userid) {
        if (StringUtils.isNotBlank((CharSequence)userid) && StringUtils.isNotBlank((CharSequence)proid)) {
            StringBuilder stringBuilder = new StringBuilder();
            String exchangeUrl = AppConfig.getProperty((String)"exchange.url");
            String autoAccessUrl = AppConfig.getProperty((String)"autoAccess.url");
            if (StringUtils.isNotBlank((CharSequence)autoAccessUrl)) {
                stringBuilder.append(exchangeUrl);
                stringBuilder.append(autoAccessUrl);
                stringBuilder.append("?userid=" + userid);
                stringBuilder.append("&proid=" + proid);
                String result = (String)this.restTemplate.getForObject(stringBuilder.toString(), String.class, new Object[0]);
                this.log.info(result);
            }
        }
    }

    static /* synthetic */ void access$000(AutoAccessInterceptor x0, String x1, String x2) {
        x0.exchangeAutoAccess(x1, x2);
    }
}

