package cn.gtmap.estateplat.model.server.core;

import cn.gtmap.estateplat.core.annotation.Zd;
import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;

import javax.persistence.Table;
import java.util.Date;

/**
 * 房地产权登记信息（独幢、层、套、间房屋）
 * 修改字典类型为国标
 * Created by lst on 2015/3/18
 */
@Table(name = "bdc_fdcq")
public class BdcFdcqNew extends QllxParent implements InsertVo, QllxVo {
    //    private String qlid;//权利Id
    //    private String bdcdyid;//不动产单元Id
    private String tdsyqr;//土地使用人
    private Date tdsyksqx;//土地使用开始期限
    private Date tdsyjsqx;//土地使用结束期限
    private Double jyjg;//房地产交易价格
    //zdd 读取不动产单元的定着物用途
    @Zd(table = "bdc_zd_fwyt")
    private String ghyt;//规划用途

    @Zd(table = "djsj_zd_fwxz")
    private String fwxz;//房屋性质

    @Zd(table = "bdc_zd_fwjg")
    private String fwjg;//房屋结构
    private String szc;//所在层
    private Integer zcs;//总层数
    private Integer wlc;//物理层
    private Double jzmj;//建筑面积
    private Double tnjzmj;//专有/套内建筑面积(m2)
    private Double ftjzmj;//分摊建筑面积
    private Date jgsj;//竣工时间
    private String mjdw;//面积单位
    private Double dytdmj;//独用土地面积(m2)
    private Double fttdmj;//分摊土地面积(m2)
    private String fwsyqr;//房屋所有权人
    private String ywh;//业务号
    private String qllx;//权利类型
    //     private String proid;//项目ID
    private String gyqk;//共有情况
    private Date djsj;//登记时间
    private String dbr;//登簿人
    private String fj;//附记

    private Integer qszt;//权属状态
    private String zrzh;//自然幢号
    private String fwdah;//房屋档案号
    private String cqly;//产权来源
    private String lsyd;//隶属用地
    @Zd(table = "bdc_zd_fwlx")
    private Integer fwlx;//房屋类型
    private String szmyc;//所在名义层
    private Double cg;//层高
    private String myzcs;//名义总层数
    private String djzch;//所有权登记注册号

    /**
     * 用于土地多用途
     */
    private Date tdsyksqx2;//土地使用开始期限2
    private Date tdsyjsqx2;//土地使用结束期限2
    private Date tdsyksqx3;//土地使用开始期限3
    private Date tdsyjsqx3;//土地使用结束期限3

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 房地产交易合同号
     */
    private String fdcjyhth;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/6/25
     * @description 土地使用权面积，记录既有独用又有分摊的情况，是独用土地面积和分摊土地面积之和，单位为平方米
     */
    private Double tdsyqmj;

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @date: 2016/7/18
     * @param:
     * @return:
     * @description: 用途子项，用于手动填写用途
     */
    private String ytzx;

    private String pth;
    /**
     * @author:<a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @date: 2016/7/18
     * @param:
     * @return:
     * @description: 发证类型，商品房发证时，1、发证2、发证明3、不发证
     */
    private String fzlx;

    private String zxyy;//注销原因
    private String zxdbr;//注销登簿人
    private Date zxdbsj;//注销登薄时间
    private String zxywh;//注销业务号
    private Integer jznd;//建筑年度

    private Double htje;//合同金额

    private Date htqdsj;//合同签订时间

    private String sfzjf;//是否自建房

    private Double zzdmj;//幢占地面积

    private Date basj;//备案时间

    private Integer tknx;//调控年限

    private Double scmj;//实测面积

    private String fwsx;//房屋属性

    private String jedw;//金额单位 字典表BDC_ZD_JEDW
    private String ytmc;// 用途名称
    private String pzyt;//批准用途
    private String sjyt;//实际用途
    private String fwxzmc;//房屋性质名称
    private String fklx;//付款类型
    private Double pgjg;//评估价格


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description bdc_fdcq表增加冗余字段qlrzjzl、qlrzjh、ywr、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcdybh、zl
     */
    private String qlrzjzl; //权利人证件种类
    @Crypt(versions = "V1")
    private String qlrzjh; //权利人证件号

    private String ywr;  //义务人

    private String ywrzjzl; //义务人证件种类
    @Crypt(versions = "V1")
    private String ywrzjh; //义务人证件号

    private String bdcdyh; //不动产单元号

    private String bdcqzh; //不动产权证号

    private String bdcdybh; //不动产单元编号

    private String zl; //坐落

    private String bz;//备注
    private String qlqtzk; //权利其他状况
    private Double fzmj;//发证面积

    private Double czmj; //超占面积
    private Integer tdycsynx; //土地有偿使用年限
    private String sfcz; //是否超占
    private String sfcc; //是否拆除
    private String fcqdh; //房产丘地号
    private String sfjckh;//是否继承空户 0不继承，1继承
    private Integer xzzrnx;//限制转让年限
    private Date xzzrdbsj;//限制转让登簿时间
    private Integer cxzt;//撤销状态 1：已撤销,0或空：未撤销
    private String zxzh;//准销证号

    /**
     * @author <a href="mailto:guting@gtmap.cn">guting</a>
     * @version 1.0,
     * @description 买方查询数量
     */
    private Integer buyerscount;

    /**
     * @author <a href="mailto:guting@gtmap.cn">guting</a>
     * @version 1.0,
     * @description 卖方查询数量
     */
    private Integer sellerscount;

    /**
     * @author <a href="mailto:guting@gtmap.cn">guting</a>
     * @version 1.0,
     * @description 不含税成交价格
     */
    private Double bhscjjg;

    /**
     * @author <a href="mailto:guting@gtmap.cn">guting</a>
     * @version 1.0,
     * @description 登记前已缴税
     */
    private Integer djqyjs;

    private String ghhshgz;//规划核实合格证证号

    public String getGhhshgz() {
        return ghhshgz;
    }

    public void setGhhshgz(String ghhshgz) {
        this.ghhshgz = ghhshgz;
    }


    private String jcnd;//建成年代

    private String fsss;//附属设施

    private String bazt;//备案状态 0：撤销 1：备案

    private Double qqtdmj;//确权土地面积

    private Double qqjzmj;//确权建筑面积

    private String sfjjsyf;//是否经济适用房

    private String sfhbzcr;//是否划拨转出让

    private String sfblbt;//是否办理补贴

    private Date btblsj;//补贴办理时间

    private String fytz;//房源特征 （首次登记后第一次办理转移登记的填“1"，第二次及以上办理转移登记的填“2”）


    public Integer getCxzt() {
        return cxzt;
    }

    public void setCxzt(Integer cxzt) {
        this.cxzt = cxzt;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getQlrzjzl() {
        return qlrzjzl;
    }

    public void setQlrzjzl(String qlrzjzl) {
        this.qlrzjzl = qlrzjzl;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getYwr() {
        return ywr;
    }

    public void setYwr(String ywr) {
        this.ywr = ywr;
    }

    public String getYwrzjzl() {
        return ywrzjzl;
    }

    public void setYwrzjzl(String ywrzjzl) {
        this.ywrzjzl = ywrzjzl;
    }

    public String getYwrzjh() {
        return ywrzjh;
    }

    public void setYwrzjh(String ywrzjh) {
        this.ywrzjh = ywrzjh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getBdcdybh() {
        return bdcdybh;
    }

    public void setBdcdybh(String bdcdybh) {
        this.bdcdybh = bdcdybh;
    }


    public Double getZzdmj() {
        return zzdmj;
    }

    public void setZzdmj(Double zzdmj) {
        this.zzdmj = zzdmj;
    }

    public String getZxyy() {
        return zxyy;
    }

    public void setZxyy(String zxyy) {
        this.zxyy = zxyy;
    }

    public String getZxdbr() {
        return zxdbr;
    }

    public void setZxdbr(String zxdbr) {
        this.zxdbr = zxdbr;
    }

    public Date getZxdbsj() {
        return zxdbsj;
    }

    public void setZxdbsj(Date zxdbsj) {
        this.zxdbsj = zxdbsj;
    }

    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getBdcdyid() {
        return bdcdyid;
    }

    public void setBdcdyid(String bdcdyid) {
        this.bdcdyid = bdcdyid;
    }

    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public Integer getFwlx() {
        return fwlx;
    }

    public void setFwlx(Integer fwlx) {
        this.fwlx = fwlx;
    }

    public String getTdsyqr() {
        return tdsyqr;
    }

    public void setTdsyqr(String tdsyqr) {
        this.tdsyqr = tdsyqr;
    }

    public Date getTdsyksqx() {
        return tdsyksqx;
    }

    public void setTdsyksqx(Date tdsyksqx) {
        this.tdsyksqx = tdsyksqx;
    }

    public Date getTdsyjsqx() {
        return tdsyjsqx;
    }

    public void setTdsyjsqx(Date tdsyjsqx) {
        this.tdsyjsqx = tdsyjsqx;
    }

    public Double getJyjg() {
        return jyjg;
    }

    public void setJyjg(Double jyjg) {
        this.jyjg = jyjg;
    }


    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }

    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }


    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

    public Double getTnjzmj() {
        return tnjzmj;
    }

    public void setTnjzmj(Double tnjzmj) {
        this.tnjzmj = tnjzmj;
    }

    public Double getFtjzmj() {
        return ftjzmj;
    }

    public void setFtjzmj(Double ftjzmj) {
        this.ftjzmj = ftjzmj;
    }

    public Date getJgsj() {
        return jgsj;
    }

    public void setJgsj(Date jgsj) {
        this.jgsj = jgsj;
    }

    public Integer getWlc() {
        return wlc;
    }

    public void setWlc(Integer wlc) {
        this.wlc = wlc;
    }

    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    public Double getDytdmj() {
        return dytdmj;
    }

    public void setDytdmj(Double dytdmj) {
        this.dytdmj = dytdmj;
    }

    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    public String getFwsyqr() {
        return fwsyqr;
    }

    public void setFwsyqr(String fwsyqr) {
        this.fwsyqr = fwsyqr;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getFwdah() {
        return fwdah;
    }

    public void setFwdah(String fwdah) {
        this.fwdah = fwdah;
    }

    public String getCqly() {
        return cqly;
    }

    public void setCqly(String cqly) {
        this.cqly = cqly;
    }

    public String getLsyd() {
        return lsyd;
    }

    public void setLsyd(String lsyd) {
        this.lsyd = lsyd;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getSzc() {
        return szc;
    }

    public void setSzc(String szc) {
        this.szc = szc;
    }

    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    public String getSzmyc() {
        return szmyc;
    }

    public void setSzmyc(String szmyc) {
        this.szmyc = szmyc;
    }

    public Double getCg() {
        return cg;
    }

    public void setCg(Double cg) {
        this.cg = cg;
    }

    public String getFdcjyhth() {
        return fdcjyhth;
    }

    public void setFdcjyhth(String fdcjyhth) {
        this.fdcjyhth = fdcjyhth;
    }

    public String getMyzcs() {
        return myzcs;
    }

    public void setMyzcs(String myzcs) {
        this.myzcs = myzcs;
    }

    public Date getTdsyksqx2() {
        return tdsyksqx2;
    }

    public void setTdsyksqx2(Date tdsyksqx2) {
        this.tdsyksqx2 = tdsyksqx2;
    }

    public Date getTdsyjsqx2() {
        return tdsyjsqx2;
    }

    public void setTdsyjsqx2(Date tdsyjsqx2) {
        this.tdsyjsqx2 = tdsyjsqx2;
    }

    public Date getTdsyksqx3() {
        return tdsyksqx3;
    }

    public void setTdsyksqx3(Date tdsyksqx3) {
        this.tdsyksqx3 = tdsyksqx3;
    }

    public Date getTdsyjsqx3() {
        return tdsyjsqx3;
    }

    public void setTdsyjsqx3(Date tdsyjsqx3) {
        this.tdsyjsqx3 = tdsyjsqx3;
    }

    public Double getTdsyqmj() {
        return tdsyqmj;
    }

    public void setTdsyqmj(Double tdsyqmj) {
        this.tdsyqmj = tdsyqmj;
    }

    public String getDjzch() {
        return djzch;
    }

    public void setDjzch(String djzch) {
        this.djzch = djzch;
    }

    public String getYtzx() {
        return ytzx;
    }

    public void setYtzx(String ytzx) {
        this.ytzx = ytzx;
    }

    public String getPth() {
        return pth;
    }

    public void setPth(String pth) {
        this.pth = pth;
    }

    public String getFzlx() {
        return fzlx;
    }

    public void setFzlx(String fzlx) {
        this.fzlx = fzlx;
    }

    public Integer getJznd() {
        return jznd;
    }

    public void setJznd(Integer jznd) {
        this.jznd = jznd;
    }

    public Double getHtje() {
        return htje;
    }

    public void setHtje(Double htje) {
        this.htje = htje;
    }

    public Date getHtqdsj() {
        return htqdsj;
    }

    public void setHtqdsj(Date htqdsj) {
        this.htqdsj = htqdsj;
    }

    public String getSfzjf() {
        return sfzjf;
    }

    public void setSfzjf(String sfzjf) {
        this.sfzjf = sfzjf;
    }

    public Date getBasj() {
        return basj;
    }

    public void setBasj(Date basj) {
        this.basj = basj;
    }

    public Integer getTknx() {
        return tknx;
    }

    public void setTknx(Integer tknx) {
        this.tknx = tknx;
    }

    public Double getScmj() {
        return scmj;
    }

    public void setScmj(Double scmj) {
        this.scmj = scmj;
    }

    public String getFwsx() {
        return fwsx;
    }

    public void setFwsx(String fwsx) {
        this.fwsx = fwsx;
    }

    public String getQlqtzk() {
        return qlqtzk;
    }

    public void setQlqtzk(String qlqtzk) {
        this.qlqtzk = qlqtzk;
    }

    public Double getFzmj() {
        return fzmj;
    }

    public void setFzmj(Double fzmj) {
        this.fzmj = fzmj;
    }

    public Double getCzmj() {
        return czmj;
    }

    public void setCzmj(Double czmj) {
        this.czmj = czmj;
    }

    public Integer getTdycsynx() {
        return tdycsynx;
    }

    public void setTdycsynx(Integer tdycsynx) {
        this.tdycsynx = tdycsynx;
    }

    public String getSfcz() {
        return sfcz;
    }

    public void setSfcz(String sfcz) {
        this.sfcz = sfcz;
    }

    public String getZxywh() {
        return zxywh;
    }

    public void setZxywh(String zxywh) {
        this.zxywh = zxywh;
    }

    public String getSfcc() {
        return sfcc;
    }

    public void setSfcc(String sfcc) {
        this.sfcc = sfcc;
    }

    public String getFcqdh() {
        return fcqdh;
    }

    public void setFcqdh(String fcqdh) {
        this.fcqdh = fcqdh;
    }

    public String getSfjckh() {
        return sfjckh;
    }

    public void setSfjckh(String sfjckh) {
        this.sfjckh = sfjckh;
    }

    public Integer getXzzrnx() {
        return xzzrnx;
    }

    public void setXzzrnx(Integer xzzrnx) {
        this.xzzrnx = xzzrnx;
    }

    public Date getXzzrdbsj() {
        return xzzrdbsj;
    }

    public void setXzzrdbsj(Date xzzrdbsj) {
        this.xzzrdbsj = xzzrdbsj;
    }

    public String getZxzh() {
        return zxzh;
    }

    public void setZxzh(String zxzh) {
        this.zxzh = zxzh;
    }

    public Integer getBuyerscount() {
        return buyerscount;
    }

    public void setBuyerscount(Integer buyerscount) {
        this.buyerscount = buyerscount;
    }

    public Double getBhscjjg() {
        return bhscjjg;
    }

    public void setBhscjjg(Double bhscjjg) {
        this.bhscjjg = bhscjjg;
    }

    public Integer getSellerscount() {
        return sellerscount;
    }

    public void setSellerscount(Integer sellerscount) {
        this.sellerscount = sellerscount;
    }

    public Integer getDjqyjs() {
        return djqyjs;
    }

    public void setDjqyjs(Integer djqyjs) {
        this.djqyjs = djqyjs;
    }

    public String getJcnd() {
        return jcnd;
    }

    public void setJcnd(String jcnd) {
        this.jcnd = jcnd;
    }

    public String getFsss() {
        return fsss;
    }

    public void setFsss(String fsss) {
        this.fsss = fsss;
    }

    public String getBazt() {
        return bazt;
    }

    public void setBazt(String bazt) {
        this.bazt = bazt;
    }

    public Double getQqtdmj() {
        return qqtdmj;
    }

    public void setQqtdmj(Double qqtdmj) {
        this.qqtdmj = qqtdmj;
    }

    public Double getQqjzmj() {
        return qqjzmj;
    }

    public void setQqjzmj(Double qqjzmj) {
        this.qqjzmj = qqjzmj;
    }

    public String getSjyt() {
        return sjyt;
    }

    public void setSjyt(String sjyt) {
        this.sjyt = sjyt;
    }

    public String getFklx() {
        return fklx;
    }

    public void setFklx(String fklx) {
        this.fklx = fklx;
    }

    public Double getPgjg() {
        return pgjg;
    }

    public void setPgjg(double pgjg) {
        this.pgjg = pgjg;
    }

    public String getYtmc() {
        return ytmc;
    }

    public void setYtmc(String ytmc) {
        this.ytmc = ytmc;
    }

    public String getPzyt() {
        return pzyt;
    }

    public void setPzyt(String pzyt) {
        this.pzyt = pzyt;
    }

    public String getFwxzmc() {
        return fwxzmc;
    }

    public void setFwxzmc(String fwxzmc) {
        this.fwxzmc = fwxzmc;
    }

    public String getJedw() {
        return jedw;
    }

    public void setJedw(String jedw) {
        this.jedw = jedw;
    }

    public void setPgjg(Double pgjg) {
        this.pgjg = pgjg;
    }

    public String getSfjjsyf() {
        return sfjjsyf;
    }

    public void setSfjjsyf(String sfjjsyf) {
        this.sfjjsyf = sfjjsyf;
    }

    public String getSfhbzcr() {
        return sfhbzcr;
    }

    public void setSfhbzcr(String sfhbzcr) {
        this.sfhbzcr = sfhbzcr;
    }

    public String getSfblbt() {
        return sfblbt;
    }

    public void setSfblbt(String sfblbt) {
        this.sfblbt = sfblbt;
    }

    public Date getBtblsj() {
        return btblsj;
    }

    public void setBtblsj(Date btblsj) {
        this.btblsj = btblsj;
    }

    public String getFytz() {
        return fytz;
    }

    public void setFytz(String fytz) {
        this.fytz = fytz;
    }
}
