package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * @author jiangganzhi <a href="mailto:jiangganzhi@gtmap.cn">jiangganzhi</a>
 * @date 2022年06月20日
 * @description
 */
public class JaxbNotnullDecimalThreeWithZeroAdapter extends XmlAdapter<String, BigDecimal> {
    @Override
    public BigDecimal unmarshal(String v) throws Exception {
        if (StringUtils.isNoneBlank(v)) {
            return new BigDecimal(v);
        }
        return null;
    }

    @Override
    public String marshal(BigDecimal v) throws Exception {
        String str = "";
        if (v != null) {
            DecimalFormat df = new DecimalFormat("0.000");
            str = df.format(v);
        }
        return str;
    }
}
