package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzZh;

import java.util.List;

/**
 * 宗海信息接口
 *
 * @author <a href="mailto: lijian@gtmap.cn">lj</a>
 * @version 1.0 15-11-21
 */
public interface QzZhService {
    /**
     * 通过不动产单元编号获取宗海信息
     *
     * @param bdcdybh a {@link java.lang.String} object.
     * @return a {@link cn.gtmap.estateplat.model.exchange.transition.QzZh} object.
     */
    public QzZh getQzzhByBdcdybh(String bdcdybh);

    /**
     * 通过业务号获取宗海信息
     *
     * @param ywh a {@link java.lang.String} object.
     * @return a {@link java.util.List} object.
     */
    public List<QzZh> getQzzhByYwh(String ywh);

    /**
     * 通过海籍号获取宗海信息
     *
     * @param hjh a {@link java.lang.String} object.
     * @return a {@link java.util.List} object.
     */
    public List<QzZh> getQzzhByHjh(String hjh);
}
