package cn.gtmap.estateplat.model.server.core;

import java.util.Date;

/**
 * 
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-4-1
 */
public class OnlineUser {

    public static final String ONLINE_USER_IP = "online_user_ip";

    private String userId;
    private String userName;
    private Date onlineTime;
    private String ip;

    public OnlineUser(String ip, Date onlineTime, String userId, String userName) {
        this.ip = ip;
        this.onlineTime = onlineTime;
        this.userId = userId;
        this.userName = userName;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Date getOnlineTime() {
        return onlineTime;
    }

    public void setOnlineTime(Date onlineTime) {
        this.onlineTime = onlineTime;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OnlineUser))
            return false;
        OnlineUser ou = (OnlineUser) obj;
        return userId != null && userId.equals(ou.getUserId()) &&
                ip != null && ip.equals(ou.getIp());
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + userId.hashCode();
        hash = hash * 31 + ip.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "[" + userId + "," + userName + "," + onlineTime + "]";
    }
}
