package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbStringNoNullAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * @author jiangganzhi <a href="mailto:jiangganzhi@gtmap.cn">jiangganzhi</a>
 * @date 2022年04月19日
 * @description 当日登簿详单
 */
@XmlType(name = "register", propOrder = {"ywh", "djlx","qllx","bdcdyh","zszmh","sfsb",
        "bwid"})
@XmlRootElement(name = "Register")
public class Register {
    private String ywh;//业务号
    private String djlx;//登记类型
    private String qllx;//权利类型
    private String bdcdyh;//不动产单元号
    private String zszmh;//证书证明号
    private String sfsb;//是否上报
    private String bwid;//报文ID

    @XmlAttribute(name = "YWH")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }
    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }
    @XmlAttribute(name = "QLLX")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }
    @XmlAttribute(name = "BDCDYH")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }
    @XmlAttribute(name = "ZSZMH")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getZszmh() {
        return zszmh;
    }

    public void setZszmh(String zszmh) {
        this.zszmh = zszmh;
    }
    @XmlAttribute(name = "BWID")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getBwid() {
        return bwid;
    }

    public void setBwid(String bwid) {
        this.bwid = bwid;
    }
    @XmlAttribute(name = "SFSB")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getSfsb() {
        return sfsb;
    }

    public void setSfsb(String sfsb) {
        this.sfsb = sfsb;
    }
}
