package cn.gtmap.estateplat.core.support.spring;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.Set;

/**
 * 
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-1
 */
public class ConversionService extends DefaultConversionService implements InitializingBean {
    private Set<Converter> converters;

    public void setConverters(Set<Converter> converters) {
        this.converters = converters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (converters != null) {
            for (Converter converter : converters) {
                addConverter(converter);
            }
        }
    }
}
