package cn.gtmap.estateplat.core.support.freemarker.directive;


import cn.gtmap.estateplat.core.support.freemarker.FmUtils;
import cn.gtmap.estateplat.utils.RequestUtils;
import com.google.common.collect.Maps;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

import java.io.IOException;
import java.util.Map;

/**
 * 
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-24
 */
public class UrlDirective implements TemplateDirectiveModel {
    public static final String PATH = "path";

    @Override
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String path = FmUtils.getString(params, PATH);
        if (path == null) {
            path = FmUtils.renderBody(body);
        }
        Map<Object, Object> args = Maps.newHashMap();
        for (Object obj : params.entrySet()) {
            Map.Entry entry = (Map.Entry) obj;
            if (PATH.equals(entry.getKey())) {
                continue;
            }
            args.put(entry.getKey(), FmUtils.unwrap(entry.getValue()));
        }
        env.getOut().write(RequestUtils.buildUrl(path, args));
    }
}
