package cn.gtmap.estateplat.core.support.freemarker;

import freemarker.template.*;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Arrays;

/**
 * 
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-27
 */
public class HttpScopesHashModel extends SimpleHash {
    private static final long serialVersionUID = -303440337217898597L;
    private final ServletContext context;
    private final HttpServletRequest request;

    public HttpScopesHashModel(ObjectWrapper wrapper, ServletContext context, HttpServletRequest request) {
        setObjectWrapper(wrapper);
        this.context = context;
        this.request = request;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        // Lookup in page scope
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }

        // Lookup in request scope
        Object obj = request.getAttribute(key);
        if (obj != null) {
            return wrap(obj);
        }

        // Lookup in session scope
        HttpSession session = request.getSession(false);
        if (session != null) {
            obj = session.getAttribute(key);
            if (obj != null) {
                return wrap(obj);
            }
        }

        // Lookup in application scope
        obj = context.getAttribute(key);
        if (obj != null) {
            return wrap(obj);
        }

        // Lookup in request parameter
        String[] param = request.getParameterValues(key);
        if (param != null) {
            switch (param.length) {
                case 0:
                    break;
                case 1:
                    return new SimpleScalar(param[0]);
                default:
                    return new SimpleSequence(Arrays.asList(param), getObjectWrapper());
            }
        }

        // return wrapper's null object (probably null).
        return wrap(null);
    }
}
