package cn.gtmap.estateplat.core.support.freemarker;

import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.*;
import freemarker.template.SimpleHash;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;

/**
 * 
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-9-7
 */
public class FreeMarkerView extends org.springframework.web.servlet.view.freemarker.FreeMarkerView {

    private TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;

    @Override
    protected void initServletContext(ServletContext servletContext) throws BeansException {
        if (getConfiguration() != null) {
            taglibFactory = new TaglibFactory(servletContext);
        } else {
            FreeMarkerConfig config = autodetectConfiguration();
            setConfiguration(config.getConfiguration());
            taglibFactory = config.getTaglibFactory();
        }

        GenericServlet servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        } catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", ex);
        }
        servletContextHashModel = new ServletContextHashModel(servlet, getObjectWrapper());
    }

    @Override
    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        HttpScopesHashModel fmModel = new HttpScopesHashModel(getObjectWrapper(), getServletContext(), request);
        fmModel.put(FreemarkerServlet.KEY_JSP_TAGLIBS, taglibFactory);
        fmModel.put(FreemarkerServlet.KEY_APPLICATION, servletContextHashModel);
        fmModel.put(FreemarkerServlet.KEY_SESSION, buildSessionModel(request, response));
        fmModel.put(FreemarkerServlet.KEY_REQUEST, new HttpRequestHashModel(request, response, getObjectWrapper()));
        HttpRequestParametersHashModel param = new HttpRequestParametersHashModel(request);
        fmModel.put(FreemarkerServlet.KEY_REQUEST_PARAMETERS, param);
        fmModel.put("param", param);
        fmModel.put("base", request.getContextPath());
        fmModel.put("req", request);
        fmModel.putAll(model);
        return fmModel;
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel(session, getObjectWrapper());
        } else {
            return new HttpSessionHashModel(null, request, response, getObjectWrapper());
        }
    }

    @SuppressWarnings("serial")
    private static class GenericServletAdapter extends GenericServlet {

        @Override
        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }

    private class DelegatingServletConfig implements ServletConfig {

        public String getServletName() {
            return FreeMarkerView.this.getBeanName();
        }

        public ServletContext getServletContext() {
            return FreeMarkerView.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.<String>emptySet());
        }
    }
}
