package cn.gtmap.estateplat.core.support.fastjson;

import cn.gtmap.estateplat.utils.Charsets;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

/**
 * 
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-9
 */
public class Helper {
    public static final Charset DEFAULT_CHARSET = Charsets.CHARSET_UTF8;

    public static void render(Object obj, String jsonpCallback, OutputStream writer) {
        SerializeWriter out = new SerializeWriter();
        out.config(SerializerFeature.DisableCircularReferenceDetect, true);
        JSONSerializer serializer = new JSONSerializer(out);
        serializer.write(obj);
        try {
            if (StringUtils.isEmpty(jsonpCallback)) {
                out.writeTo(writer, DEFAULT_CHARSET);
            } else {
                writer.write((jsonpCallback + "(").getBytes());
                out.writeTo(writer, DEFAULT_CHARSET);
                writer.write((");").getBytes());
            }
            writer.flush();
        } catch (IOException ex){

        } finally {
            out.close();
        }
    }
}
